/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.replication;

import com.yugabyte.core.BaseConnection;
import com.yugabyte.replication.PGReplicationConnection;
import com.yugabyte.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.yugabyte.replication.fluent.ChainedStreamBuilder;
import com.yugabyte.replication.fluent.ReplicationCreateSlotBuilder;
import com.yugabyte.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private final BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

