/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.LoadBalanceService;
import com.yugabyte.ysql.LoadBalancer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;

public class TopologyAwareLoadBalancer
implements LoadBalancer {
    protected static final Logger LOGGER = Logger.getLogger("com.yugabyte." + TopologyAwareLoadBalancer.class.getName());
    private final String placements;
    private final LoadBalanceService.LoadBalanceType loadBalance;
    private long lastRequestTime;
    private final Map<Integer, Set<LoadBalanceService.CloudPlacement>> allowedPlacements = new HashMap<Integer, Set<LoadBalanceService.CloudPlacement>>();
    private final int PRIMARY_PLACEMENTS_INDEX = 1;
    private final int REST_OF_CLUSTER_INDEX = -1;
    private int currentPlacementIndex = 1;
    private List<String> attempted = new ArrayList<String>();
    private final int refreshIntervalSeconds;
    private boolean explicitFallbackOnly = false;
    private byte requestFlags;

    public TopologyAwareLoadBalancer(LoadBalanceService.LoadBalanceType lb, String placementValues, boolean onlyExplicitFallback) {
        this.loadBalance = lb != null ? lb : LoadBalanceService.LoadBalanceType.FALSE;
        this.placements = placementValues;
        this.explicitFallbackOnly = onlyExplicitFallback;
        this.refreshIntervalSeconds = Integer.getInteger("yb-servers-refresh-interval", 300);
        this.parseGeoLocations();
    }

    protected String loadBalancingNodes() {
        return this.placements;
    }

    private void populatePlacementSet(String placement, Set<LoadBalanceService.CloudPlacement> allowedPlacements) {
        String[] placementParts = placement.split("\\.");
        if (placementParts.length != 3 || placementParts[0].equals("*") || placementParts[1].equals("*")) {
            LOGGER.warning("Malformed topology-keys property value: " + placement);
            throw new IllegalArgumentException("Malformed topology-keys property value: " + placement);
        }
        LoadBalanceService.CloudPlacement cp = new LoadBalanceService.CloudPlacement(placementParts[0], placementParts[1], placementParts[2]);
        LOGGER.fine("Adding placement " + cp + " to allowed list");
        allowedPlacements.add(cp);
    }

    private void parseGeoLocations() {
        String[] values;
        for (String value : values = this.placements.split(",")) {
            String[] v = value.split(":");
            if (v.length > 2 || value.endsWith(":")) {
                throw new IllegalArgumentException("Invalid value part for property topology-keys: " + value);
            }
            if (v.length == 1) {
                Set primary = this.allowedPlacements.computeIfAbsent(1, k -> new HashSet());
                this.populatePlacementSet(v[0], primary);
                continue;
            }
            int pref = Integer.parseInt(v[1]);
            if (pref > 0 && pref <= 10) {
                Set cpSet = this.allowedPlacements.computeIfAbsent(pref, k -> new HashSet());
                this.populatePlacementSet(v[0], cpSet);
                continue;
            }
            throw new IllegalArgumentException("Invalid preference value for property topology-keys: " + value);
        }
        LOGGER.fine("allowedPlacements: " + this.allowedPlacements);
    }

    @Override
    public int getRefreshListSeconds() {
        return Integer.getInteger("yb-servers-refresh-interval", this.refreshIntervalSeconds);
    }

    public boolean isExplicitFallbackOnly() {
        return this.explicitFallbackOnly;
    }

    @Override
    public boolean isHostEligible(Map.Entry<String, LoadBalanceService.NodeInfo> e, Byte requestFlags) {
        Set<LoadBalanceService.CloudPlacement> set = this.allowedPlacements.get(this.currentPlacementIndex);
        boolean found = this.currentPlacementIndex == -1 && (!this.explicitFallbackOnly || this.loadBalance == LoadBalanceService.LoadBalanceType.PREFER_PRIMARY || this.loadBalance == LoadBalanceService.LoadBalanceType.PREFER_RR) || set != null && e.getValue().getPlacement().isContainedIn(set);
        boolean isRightNode = LoadBalanceService.isRightNodeType(this.loadBalance, e.getValue().getNodeType(), requestFlags);
        boolean isAttempted = this.attempted.contains(e.getKey());
        boolean isDown = e.getValue().isDown();
        LOGGER.fine(e.getKey() + " has currentPlacementIndex " + this.currentPlacementIndex + ", required placement? " + found + ", isDown? " + isDown + ", attempted? " + isAttempted + ", isRightNodeType? " + isRightNode);
        return found && !isAttempted && !isDown && isRightNode;
    }

    @Override
    public synchronized String getLeastLoadedServer(boolean newRequest, List<String> failedHosts, ArrayList<String> timedOutHosts) {
        LOGGER.fine("newRequest: " + newRequest + ", failedHosts: " + failedHosts);
        if (newRequest && LoadBalanceService.getLastRefreshTime() - this.lastRequestTime >= 0L) {
            this.currentPlacementIndex = 1;
        } else {
            LOGGER.fine("Placements: [" + this.placements + "]. Attempting to connect to servers in fallback level-" + (this.currentPlacementIndex - 1) + " ...");
        }
        String chosenHost = null;
        byte by = this.requestFlags = newRequest ? (byte)1 : this.requestFlags;
        while (chosenHost == null && this.currentPlacementIndex <= 10) {
            this.attempted = failedHosts;
            if (timedOutHosts != null) {
                this.attempted.addAll(timedOutHosts);
            }
            ArrayList<String> hosts = LoadBalanceService.getAllEligibleHosts(this, this.requestFlags);
            int min = Integer.MAX_VALUE;
            ArrayList<String> minConnectionsHostList = new ArrayList<String>();
            for (String h : hosts) {
                if (failedHosts.contains(h)) {
                    LOGGER.fine("Skipping failed host " + h);
                    continue;
                }
                int currLoad = LoadBalanceService.getLoad(h);
                LOGGER.fine("Number of connections to " + h + ": " + currLoad);
                if (currLoad < min) {
                    min = currLoad;
                    minConnectionsHostList.clear();
                    minConnectionsHostList.add(h);
                    continue;
                }
                if (currLoad != min) continue;
                minConnectionsHostList.add(h);
            }
            if (!minConnectionsHostList.isEmpty()) {
                int idx = ThreadLocalRandom.current().nextInt(0, minConnectionsHostList.size());
                chosenHost = (String)minConnectionsHostList.get(idx);
            }
            if (chosenHost != null) {
                LoadBalanceService.incrementConnectionCount(chosenHost);
                continue;
            }
            LOGGER.fine("chosenHost is null for placement level " + this.currentPlacementIndex + ", allowedPlacements: " + this.allowedPlacements);
            ++this.currentPlacementIndex;
            while (this.allowedPlacements.get(this.currentPlacementIndex) == null && this.currentPlacementIndex > 0) {
                ++this.currentPlacementIndex;
                if (this.currentPlacementIndex <= 10) continue;
                this.currentPlacementIndex = -1;
            }
            if (this.currentPlacementIndex == 0) {
                if (this.requestFlags != 1 || this.loadBalance != LoadBalanceService.LoadBalanceType.PREFER_PRIMARY && this.loadBalance != LoadBalanceService.LoadBalanceType.PREFER_RR) break;
                LOGGER.fine("Even rest of cluster did not have a host for us. So relax the node type condition for prefer-* and try again once");
                this.currentPlacementIndex = -1;
                this.requestFlags = 0;
            }
            LOGGER.fine("Next, attempting to connect to hosts from placement level " + this.currentPlacementIndex);
        }
        this.lastRequestTime = System.currentTimeMillis();
        LOGGER.fine("Host chosen for new connection: " + chosenHost);
        if (chosenHost == null && (this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_PRIMARY || this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_RR || this.loadBalance == LoadBalanceService.LoadBalanceType.ANY && this.explicitFallbackOnly)) {
            throw new IllegalStateException("No node available in the given placements for the " + (this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_PRIMARY ? "primary" : (this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_RR ? "read-replica" : "entire")) + " cluster to connect to.");
        }
        return chosenHost;
    }
}

