/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.SafeEncoder;

public abstract class JedisClusterCommand<T> {
    private JedisClusterConnectionHandler connectionHandler;
    private int maxAttempts;
    private ThreadLocal<Jedis> askConnection = new ThreadLocal();

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int maxAttempts) {
        this.connectionHandler = connectionHandler;
        this.maxAttempts = maxAttempts;
    }

    public abstract T execute(Jedis var1);

    public T run() {
        return this.runWithRetries(this.maxAttempts, false, false, 0, new byte[0][]);
    }

    public T run(String key) {
        if (key == null) {
            return this.run();
        }
        return this.runWithRetries(this.maxAttempts, false, false, 1, new byte[][]{SafeEncoder.encode(key)});
    }

    public T run(int keyCount, String ... keys) {
        if (keys == null || keys.length == 0) {
            return this.run();
        }
        byte[][] encodedKeys = new byte[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            encodedKeys[i] = SafeEncoder.encode(keys[i]);
        }
        return this.runWithRetries(this.maxAttempts, false, false, keyCount, encodedKeys);
    }

    public T runBinary(byte[] key) {
        if (key == null) {
            return this.run();
        }
        return this.runWithRetries(this.maxAttempts, false, false, 1, new byte[][]{key});
    }

    public T runBinary(int keyCount, byte[] ... keys) {
        if (keys == null || keys.length == 0) {
            return this.run();
        }
        return this.runWithRetries(this.maxAttempts, false, false, keyCount, keys);
    }

    public T runWithAnyNode() {
        Jedis connection = null;
        try {
            connection = this.connectionHandler.getConnection();
            T t = this.execute(connection);
            return t;
        }
        catch (JedisConnectionException e) {
            throw e;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * Exception decompiling
     */
    private T runWithRetries(int attempts, boolean tryRandomNode, boolean asking, int keyCount, byte[] ... keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void releaseConnection(Jedis connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

