/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;

public abstract class JedisClusterConnectionHandler
implements Closeable {
    protected final Set<HostAndPort> contactPoints;
    protected final String password;
    protected final JedisClusterInfoCache cache;

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password) {
        this.contactPoints = nodes;
        this.password = password;
        this.cache = new JedisClusterInfoCache(poolConfig, connectionTimeout, soTimeout, password);
    }

    abstract Jedis getConnection();

    abstract Jedis getConnection(int var1, byte[] ... var2);

    abstract void refreshNodesCache();

    abstract void refreshNodesCache(Jedis var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        return this.cache.setupNodeIfNotExist(node).getResource();
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    @Override
    public void close() {
        this.cache.reset();
    }
}

