/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;

public class JedisRandomNodeConnectionHandler
extends JedisClusterConnectionHandler {
    private static long DEFAULT_NODES_REFRESH_INTERVAL_MILLIS = 10000L;
    private boolean includeOnlyLiveNodes;
    private Random random = new Random(System.currentTimeMillis());
    private Thread thread = null;

    public JedisRandomNodeConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, true, DEFAULT_NODES_REFRESH_INTERVAL_MILLIS);
    }

    public JedisRandomNodeConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, boolean includeOnlyLiveNodes, final long refreshIntervalMillis) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, null);
        this.includeOnlyLiveNodes = includeOnlyLiveNodes;
        this.refreshNodesCache();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(refreshIntervalMillis);
                        JedisRandomNodeConnectionHandler.this.refreshNodesCache();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        this.thread = new Thread(r);
        this.thread.start();
    }

    @Override
    Jedis getConnection(int keyCount, byte[] ... keys) {
        return this.getConnection();
    }

    @Override
    Jedis getConnection() {
        return this.cache.getNode(this.cache.getRandomNodeKey(this.random)).getResource();
    }

    @Override
    void refreshNodesCache() {
        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
        for (HostAndPort hostAndPort : this.contactPoints) {
            try {
                for (InetAddress address : InetAddress.getAllByName(hostAndPort.getHost())) {
                    HostAndPort node = new HostAndPort(address.getHostAddress(), hostAndPort.getPort());
                    nodes.add(node);
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        this.cache.renewClusterNodes(nodes, this.includeOnlyLiveNodes);
    }

    @Override
    void refreshNodesCache(Jedis jedis) {
        this.refreshNodesCache();
    }

    @Override
    public void close() {
        super.close();
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

