/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisNoReachableClusterNodeException;
import redis.clients.util.JedisClusterCRC16;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int timeout) {
        this(nodes, poolConfig, timeout, timeout);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, null);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, password);
        this.initializeSlotsCache(nodes, poolConfig, password);
    }

    @Override
    Jedis getConnection(int keyCount, byte[] ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        int slot = JedisClusterCRC16.getSlot(keys[0]);
        for (int i = 1; i < keyCount; ++i) {
            int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
            if (slot == nextSlot) continue;
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster because keys have different slots.");
        }
        JedisPool connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        this.refreshNodesCache();
        connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }

    @Override
    void refreshNodesCache() {
        this.cache.renewClusterSlots(null);
    }

    @Override
    void refreshNodesCache(Jedis jedis) {
        this.cache.renewClusterSlots(jedis);
    }

    @Override
    public Jedis getConnection() {
        List<JedisPool> pools = this.cache.getShuffledNodesPool();
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                String result = jedis.ping();
                if (result.equalsIgnoreCase("pong")) {
                    return jedis;
                }
                jedis.close();
            }
            catch (JedisException ex) {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        throw new JedisNoReachableClusterNodeException("No reachable node in cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig, String password) {
        for (HostAndPort hostAndPort : startNodes) {
            Jedis jedis = new Jedis(hostAndPort.getHost(), hostAndPort.getPort());
            if (password != null) {
                jedis.auth(password);
            }
            try {
                List<Object> slots = jedis.clusterSlots();
                this.cache.discoverClusterNodesAndSlots(slots);
                break;
            }
            catch (JedisConnectionException jedisConnectionException) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
    }
}

