/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.AdvancedBinaryJedisCommands;
import redis.clients.jedis.BinaryJedisCluster;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.JedisSlotBasedConnectionHandler;

public class YBBinaryJedis
extends BinaryJedisCluster
implements AdvancedBinaryJedisCommands {
    public YBBinaryJedis() {
        this("localhost");
    }

    public YBBinaryJedis(String host) {
        this(host, 6379);
    }

    public YBBinaryJedis(String host, int port) {
        this(host, port, 2000);
    }

    public YBBinaryJedis(String host, int port, int timeout) {
        this(host, port, timeout, timeout);
    }

    public YBBinaryJedis(String host, int port, int connectionTimeout, int soTimeout) {
        this(new HashSet<HostAndPort>(Collections.singletonList(new HostAndPort(host, port))), connectionTimeout, soTimeout, 5, new GenericObjectPoolConfig());
    }

    public YBBinaryJedis(Set<HostAndPort> contactPoints, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(new JedisSlotBasedConnectionHandler(contactPoints, poolConfig, connectionTimeout, soTimeout), maxAttempts);
    }

    @Override
    public void close() {
        if (this.connectionHandler != null) {
            this.connectionHandler.close();
        }
    }

    @Override
    public List<byte[]> configGet(final byte[] pattern) {
        return (List)new JedisClusterCommand<List<byte[]>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<byte[]> execute(Jedis connection) {
                return connection.configGet(pattern);
            }
        }.run();
    }

    @Override
    public byte[] configSet(final byte[] parameter, final byte[] value) {
        return (byte[])new JedisClusterCommand<byte[]>(this.connectionHandler, this.maxAttempts){

            @Override
            public byte[] execute(Jedis connection) {
                return connection.configSet(parameter, value);
            }
        }.run();
    }

    @Override
    public String slowlogReset() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.slowlogReset();
            }
        }.run();
    }

    @Override
    public Long slowlogLen() {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.slowlogLen();
            }
        }.run();
    }

    @Override
    public List<byte[]> slowlogGetBinary() {
        return (List)new JedisClusterCommand<List<byte[]>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<byte[]> execute(Jedis connection) {
                return connection.slowlogGetBinary();
            }
        }.run();
    }

    @Override
    public List<byte[]> slowlogGetBinary(final long entries) {
        return (List)new JedisClusterCommand<List<byte[]>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<byte[]> execute(Jedis connection) {
                return connection.slowlogGetBinary(entries);
            }
        }.run();
    }

    @Override
    public Long objectRefcount(final byte[] key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.objectRefcount(key);
            }
        }.run();
    }

    @Override
    public byte[] objectEncoding(final byte[] key) {
        return (byte[])new JedisClusterCommand<byte[]>(this.connectionHandler, this.maxAttempts){

            @Override
            public byte[] execute(Jedis connection) {
                return connection.objectEncoding(key);
            }
        }.run();
    }

    @Override
    public Long objectIdletime(final byte[] key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.objectIdletime(key);
            }
        }.run();
    }
}

