/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.AdvancedBinaryJedisCommands;
import redis.clients.jedis.AdvancedJedisCommands;
import redis.clients.jedis.BasicCommands;
import redis.clients.jedis.ClusterCommands;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisRandomNodeConnectionHandler;
import redis.clients.jedis.Pipeline;
import redis.clients.util.Slowlog;

public class YBJedis
extends JedisCluster
implements AdvancedJedisCommands,
AdvancedBinaryJedisCommands,
BasicCommands,
ClusterCommands {
    public YBJedis() {
        this("localhost");
    }

    public YBJedis(String host) {
        this(host, 6379);
    }

    public YBJedis(String host, int port) {
        this(host, port, 2000);
    }

    public YBJedis(String host, int port, int timeout) {
        this(host, port, timeout, timeout);
    }

    public YBJedis(String host, int port, int connectionTimeout, int soTimeout) {
        this(new HashSet<HostAndPort>(Collections.singletonList(new HostAndPort(host, port))), connectionTimeout, soTimeout, 5, (GenericObjectPoolConfig)new JedisPoolConfig());
    }

    public YBJedis(Set<HostAndPort> hosts, int timeout) {
        this(hosts, timeout, timeout, 5, (GenericObjectPoolConfig)new JedisPoolConfig());
    }

    public YBJedis(Set<HostAndPort> contactPoints, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        this(new JedisRandomNodeConnectionHandler(contactPoints, poolConfig, connectionTimeout, soTimeout), maxAttempts);
    }

    public YBJedis(JedisClusterConnectionHandler connectionHandler, int maxAttempts) {
        super(connectionHandler, maxAttempts);
    }

    public Pipeline pipelined() {
        return (Pipeline)new JedisClusterCommand<Pipeline>(this.connectionHandler, this.maxAttempts){

            @Override
            public Pipeline execute(Jedis connection) {
                return connection.pipelined();
            }
        }.run();
    }

    @Override
    public List<byte[]> configGet(final byte[] pattern) {
        return (List)new JedisClusterCommand<List<byte[]>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<byte[]> execute(Jedis connection) {
                return connection.configGet(pattern);
            }
        }.run();
    }

    @Override
    public byte[] configSet(final byte[] parameter, final byte[] value) {
        return (byte[])new JedisClusterCommand<byte[]>(this.connectionHandler, this.maxAttempts){

            @Override
            public byte[] execute(Jedis connection) {
                return connection.configSet(parameter, value);
            }
        }.run();
    }

    @Override
    public String slowlogReset() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.slowlogReset();
            }
        }.run();
    }

    @Override
    public Long slowlogLen() {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.slowlogLen();
            }
        }.run();
    }

    @Override
    public List<byte[]> slowlogGetBinary() {
        return (List)new JedisClusterCommand<List<byte[]>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<byte[]> execute(Jedis connection) {
                return connection.slowlogGetBinary();
            }
        }.run();
    }

    @Override
    public List<byte[]> slowlogGetBinary(final long entries) {
        return (List)new JedisClusterCommand<List<byte[]>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<byte[]> execute(Jedis connection) {
                return connection.slowlogGetBinary(entries);
            }
        }.run();
    }

    @Override
    public Long objectRefcount(final byte[] key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.objectRefcount(key);
            }
        }.run();
    }

    @Override
    public byte[] objectEncoding(final byte[] key) {
        return (byte[])new JedisClusterCommand<byte[]>(this.connectionHandler, this.maxAttempts){

            @Override
            public byte[] execute(Jedis connection) {
                return connection.objectEncoding(key);
            }
        }.run();
    }

    @Override
    public Long objectIdletime(final byte[] key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.objectIdletime(key);
            }
        }.run();
    }

    @Override
    public List<String> configGet(final String pattern) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<String> execute(Jedis connection) {
                return connection.configGet(pattern);
            }
        }.run();
    }

    @Override
    public String configSet(final String parameter, final String value) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.configSet(parameter, value);
            }
        }.run();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        return (List)new JedisClusterCommand<List<Slowlog>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<Slowlog> execute(Jedis connection) {
                return connection.slowlogGet();
            }
        }.run();
    }

    @Override
    public List<Slowlog> slowlogGet(final long entries) {
        return (List)new JedisClusterCommand<List<Slowlog>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<Slowlog> execute(Jedis connection) {
                return connection.slowlogGet(entries);
            }
        }.run();
    }

    @Override
    public Long objectRefcount(final String string) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.objectRefcount(string);
            }
        }.run();
    }

    @Override
    public String objectEncoding(final String string) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.objectEncoding(string);
            }
        }.run();
    }

    @Override
    public Long objectIdletime(final String string) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.objectIdletime(string);
            }
        }.run();
    }

    @Override
    public String clusterNodes() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterNodes();
            }
        }.run();
    }

    @Override
    public String clusterMeet(final String ip, final int port) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterMeet(ip, port);
            }
        }.run();
    }

    @Override
    public String clusterAddSlots(final int ... slots) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterAddSlots(slots);
            }
        }.run();
    }

    @Override
    public String clusterDelSlots(final int ... slots) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterDelSlots(slots);
            }
        }.run();
    }

    @Override
    public String clusterInfo() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterInfo();
            }
        }.run();
    }

    @Override
    public List<String> clusterGetKeysInSlot(final int slot, final int count) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<String> execute(Jedis connection) {
                return connection.clusterGetKeysInSlot(slot, count);
            }
        }.run();
    }

    @Override
    public String clusterSetSlotNode(final int slot, final String nodeId) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterSetSlotNode(slot, nodeId);
            }
        }.run();
    }

    @Override
    public String clusterSetSlotMigrating(final int slot, final String nodeId) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterSetSlotMigrating(slot, nodeId);
            }
        }.run();
    }

    @Override
    public String clusterSetSlotImporting(final int slot, final String nodeId) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterSetSlotImporting(slot, nodeId);
            }
        }.run();
    }

    @Override
    public String clusterSetSlotStable(final int slot) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterSetSlotStable(slot);
            }
        }.run();
    }

    @Override
    public String clusterForget(final String nodeId) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterForget(nodeId);
            }
        }.run();
    }

    @Override
    public String clusterFlushSlots() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterFlushSlots();
            }
        }.run();
    }

    @Override
    public Long clusterKeySlot(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.clusterKeySlot(key);
            }
        }.run();
    }

    @Override
    public Long clusterCountKeysInSlot(final int slot) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.maxAttempts){

            @Override
            public Long execute(Jedis connection) {
                return connection.clusterCountKeysInSlot(slot);
            }
        }.run();
    }

    @Override
    public String clusterSaveConfig() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterSaveConfig();
            }
        }.run();
    }

    @Override
    public String clusterReplicate(final String nodeId) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterReplicate(nodeId);
            }
        }.run();
    }

    @Override
    public List<String> clusterSlaves(final String nodeId) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<String> execute(Jedis connection) {
                return connection.clusterSlaves(nodeId);
            }
        }.run();
    }

    @Override
    public String clusterFailover() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterFailover();
            }
        }.run();
    }

    @Override
    public List<Object> clusterSlots() {
        return (List)new JedisClusterCommand<List<Object>>(this.connectionHandler, this.maxAttempts){

            @Override
            public List<Object> execute(Jedis connection) {
                return connection.clusterSlots();
            }
        }.run();
    }

    @Override
    public String clusterReset(final JedisCluster.Reset resetType) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.clusterReset(resetType);
            }
        }.run();
    }

    @Override
    public String readonly() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.readonly();
            }
        }.run();
    }

    @Override
    public String set(final String key, final String value, final String nxxx) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.set(key, value, nxxx);
            }
        }.run(key);
    }
}

