/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.maven.wagon;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.WebIdentityTokenCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.google.common.base.Optional;
import com.yugabyte.maven.wagon.AuthenticationInfoCredentialsProvider;
import java.util.ArrayList;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenAwsCredentialsProviderChain
extends AWSCredentialsProviderChain {
    final Logger log = LoggerFactory.getLogger(MavenAwsCredentialsProviderChain.class);

    public MavenAwsCredentialsProviderChain(Optional<AuthenticationInfo> auth) {
        super(MavenAwsCredentialsProviderChain.getProviders(auth));
    }

    private static AWSCredentialsProvider[] getProviders(Optional<AuthenticationInfo> auth) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new SystemPropertiesCredentialsProvider());
        providers.add(new EnvironmentVariableCredentialsProvider());
        providers.add(WebIdentityTokenCredentialsProvider.create());
        providers.add(new AuthenticationInfoCredentialsProvider(auth));
        providers.add(new ProfileCredentialsProvider());
        providers.add(new EC2ContainerCredentialsProviderWrapper());
        return providers.toArray(new AWSCredentialsProvider[providers.size()]);
    }

    public AWSCredentials getCredentials() {
        try {
            return super.getCredentials();
        }
        catch (SdkClientException exception) {
            this.log.warn("No credentials found. Trying with anonymous request.");
            return new AnonymousAWSCredentials();
        }
    }
}

