/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.maven.wagon;

import com.yugabyte.maven.wagon.TransferProgress;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

class TransferProgressFileOutputStream
extends FileOutputStream {
    private TransferProgress progress;

    public TransferProgressFileOutputStream(File file, TransferProgress progress) throws FileNotFoundException {
        super(file);
        this.progress = progress;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.progress.notify(new byte[]{(byte)b}, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.progress.notify(b, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (off == 0) {
            this.progress.notify(b, len);
        } else {
            byte[] bytes = new byte[len];
            System.arraycopy(b, off, bytes, 0, len);
            this.progress.notify(bytes, len);
        }
    }
}

