/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.data.jdbc.core.convert;

import com.yugabyte.data.jdbc.core.QueryOptions;
import com.yugabyte.data.jdbc.core.convert.YsqlDataAccessStrategy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.data.jdbc.core.convert.DefaultDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class DefaultYsqlDataAccessStrategy
extends DefaultDataAccessStrategy
implements YsqlDataAccessStrategy {
    private static final String DEFERRABLE_TRANSACTION = "BEGIN ISOLATION LEVEL SERIALIZABLE, READ ONLY, DEFERRABLE";
    private final DataSource dataSource;
    private final RelationalMappingContext context;

    public DefaultYsqlDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, DataSource dataSource) {
        super(sqlGeneratorSource, context, converter, operations);
        this.context = context;
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Class<?> domainType, QueryOptions queryOptions) throws SQLException {
        String tableName = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getTableName().toSql(IdentifierProcessing.ANSI);
        String sqlString = String.format("SELECT COUNT(*) FROM %s", tableName);
        Connection readConnection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        Boolean originalAutoCommit = readConnection.getAutoCommit();
        if (queryOptions.isDeferrable() != null && queryOptions.isDeferrable().booleanValue() && !TransactionSynchronizationManager.isActualTransactionActive()) {
            readConnection.setAutoCommit(false);
            Statement deferrableStatement = readConnection.createStatement();
            deferrableStatement.executeUpdate(DEFERRABLE_TRANSACTION);
        }
        Statement countStatement = readConnection.createStatement();
        Long result = null;
        try {
            ResultSet rs = countStatement.executeQuery(sqlString);
            while (rs.next()) {
                result = rs.getLong(1);
            }
        }
        finally {
            readConnection.setAutoCommit(originalAutoCommit);
            readConnection.close();
        }
        Assert.notNull((Object)result, (String)"The result of a count query must not be null.");
        return result;
    }
}

