/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.data.jdbc.repository.support;

import com.yugabyte.data.jdbc.core.YsqlTemplate;
import com.yugabyte.data.jdbc.core.convert.YsqlDataAccessStrategy;
import com.yugabyte.data.jdbc.repository.support.SimpleYsqlRepository;
import com.yugabyte.data.jdbc.repository.support.YsqlQueryLookupStrategy;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryFactory;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class YsqlRepositoryFactory
extends JdbcRepositoryFactory {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final ApplicationEventPublisher publisher;
    private final YsqlDataAccessStrategy ysqlDataAccessStrategy;
    private final NamedParameterJdbcOperations operations;
    private final Dialect dialect;
    @Nullable
    private BeanFactory beanFactory;
    private QueryMappingConfiguration queryMappingConfiguration = QueryMappingConfiguration.EMPTY;
    private EntityCallbacks entityCallbacks;

    public YsqlRepositoryFactory(YsqlDataAccessStrategy dataAccessStrategy, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, ApplicationEventPublisher publisher, NamedParameterJdbcOperations operations) {
        super((DataAccessStrategy)dataAccessStrategy, context, converter, dialect, publisher, operations);
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null!");
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
        this.ysqlDataAccessStrategy = dataAccessStrategy;
        this.operations = operations;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleYsqlRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        YsqlTemplate template = new YsqlTemplate(this.publisher, this.context, this.converter, this.ysqlDataAccessStrategy);
        if (this.entityCallbacks != null) {
            template.setEntityCallbacks(this.entityCallbacks);
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(repositoryInformation.getDomainType());
        return this.getTargetRepositoryViaReflection(repositoryInformation.getRepositoryBaseClass(), new Object[]{template, persistentEntity});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new YsqlQueryLookupStrategy(this.publisher, this.entityCallbacks, this.context, this.converter, this.dialect, this.queryMappingConfiguration, this.operations, this.beanFactory));
    }
}

