/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.data.jdbc.core;

import org.springframework.lang.Nullable;

public class QueryOptions {
    private static final QueryOptions EMPTY = QueryOptions.builder().build();
    @Nullable
    private final Boolean deferrable;
    @Nullable
    private final Boolean multiRowInsert;
    @Nullable
    private final Boolean followerRead;

    protected QueryOptions(@Nullable Boolean isolationLevel, @Nullable Boolean multiRowInsert, @Nullable Boolean follwerRead) {
        this.deferrable = isolationLevel;
        this.multiRowInsert = multiRowInsert;
        this.followerRead = follwerRead;
    }

    public static QueryOptionsBuilder builder() {
        return new QueryOptionsBuilder();
    }

    public static QueryOptions empty() {
        return EMPTY;
    }

    public Boolean isDeferrable() {
        return this.deferrable;
    }

    public Boolean getMutliRowInsert() {
        return this.multiRowInsert;
    }

    public Boolean getFollowerRead() {
        return this.followerRead;
    }

    public static class QueryOptionsBuilder {
        @Nullable
        protected Boolean deferrable;
        @Nullable
        protected Boolean multiRowInsert;
        @Nullable
        protected Boolean followerRead;

        QueryOptionsBuilder() {
        }

        QueryOptionsBuilder(QueryOptions queryOptions) {
            this.deferrable = queryOptions.deferrable;
            this.multiRowInsert = queryOptions.multiRowInsert;
            this.followerRead = queryOptions.followerRead;
        }

        public QueryOptionsBuilder deferrable(Boolean deferrable) {
            this.deferrable = deferrable;
            return this;
        }

        public QueryOptionsBuilder multiRowInsert(Boolean multiRowInsert) {
            this.multiRowInsert = multiRowInsert;
            return this;
        }

        public QueryOptionsBuilder followerRead(Boolean followerRead) {
            this.followerRead = followerRead;
            return this;
        }

        public QueryOptions build() {
            return new QueryOptions(this.deferrable, this.multiRowInsert, this.followerRead);
        }
    }
}

