/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.data.jdbc.repository.config;

import com.yugabyte.data.relational.core.dialect.YugabyteDialect;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.util.PSQLException;
import org.springframework.data.jdbc.repository.config.DialectResolver;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class YugabyteDialectResolver {

    public static class YugabyteDialectProvider
    extends DialectResolver.DefaultDialectProvider {
        private static final Log LOG = LogFactory.getLog(YugabyteDialectProvider.class);
        private static final String YUGABYTE_SERVERS_QUERY = "select * from yb_servers()";
        private static final String YB_SERVERS_FUNCTION_DOESNT_EXIST = "function yb_servers() does not exist";

        public Optional<Dialect> getDialect(JdbcOperations operations) {
            Optional<Object> yugabyteDialect = Optional.ofNullable(operations.execute(YugabyteDialectProvider::getDialect));
            if (yugabyteDialect.isPresent()) {
                return yugabyteDialect;
            }
            return super.getDialect(operations);
        }

        @Nullable
        private static Dialect getDialect(Connection connection) throws SQLException {
            YugabyteDialect dialect;
            block4: {
                Statement ybStatement = connection.createStatement();
                dialect = null;
                LOG.debug((Object)"Executing query against YB_SERVERS() system function.");
                try {
                    ResultSet rs = ybStatement.executeQuery(YUGABYTE_SERVERS_QUERY);
                    if (!rs.next()) {
                        LOG.debug((Object)"Query for YB_SERVERS() system function returned null. Falling back on DefaultDialectProvider.");
                        return null;
                    }
                    String hostName = rs.getString("host");
                    if (StringUtils.hasText((String)hostName)) {
                        dialect = YugabyteDialect.INSTANCE;
                    }
                }
                catch (PSQLException psqlException) {
                    Boolean functionNotExist = Pattern.compile(Pattern.quote(YB_SERVERS_FUNCTION_DOESNT_EXIST), 2).matcher(psqlException.getMessage()).find();
                    if (!functionNotExist.booleanValue()) break block4;
                    LOG.debug((Object)"YB_SERVERS() system function doesn't exist. Falling back on DefaultDialectProvider.");
                    return null;
                }
            }
            LOG.debug((Object)"Using YugabyteDB YSQL Dialect.");
            return dialect;
        }
    }
}

