/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.data.relational.core.dialect;

import java.util.Iterator;
import java.util.List;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.PostgresDialect;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;

public class YugabyteDialect
extends PostgresDialect {
    public static final YugabyteDialect INSTANCE = new YugabyteDialect();
    private final LockClause LOCK_CLAUSE = new YugabyteLockClause(this.getIdentifierProcessing());

    protected YugabyteDialect() {
    }

    public LockClause lock() {
        return this.LOCK_CLAUSE;
    }

    static class YugabyteLockClause
    implements LockClause {
        private final IdentifierProcessing identifierProcessing;

        YugabyteLockClause(IdentifierProcessing identifierProcessing) {
            this.identifierProcessing = identifierProcessing;
        }

        public String getLock(LockOptions lockOptions) {
            SqlIdentifier identifier;
            List tables = lockOptions.getFrom().getTables();
            if (tables.isEmpty()) {
                return "";
            }
            SqlIdentifier last = identifier = ((Table)tables.get(0)).getName();
            Iterator iterator = identifier.iterator();
            while (iterator.hasNext()) {
                SqlIdentifier sqlIdentifier;
                last = sqlIdentifier = (SqlIdentifier)iterator.next();
            }
            String tableName = last.toSql(this.identifierProcessing);
            switch (lockOptions.getLockMode()) {
                case PESSIMISTIC_WRITE: {
                    return "";
                }
                case PESSIMISTIC_READ: {
                    return "";
                }
            }
            return "";
        }

        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    }
}

