/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.spring;

import com.yugabyte.ysql.YBClusterAwareDataSource;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

@Configuration
public abstract class AbstractYugabyteConfiguration {
    @Value(value="${spring.yugabyte.initialHost:localhost}")
    private String initialHost;
    @Value(value="${spring.yugabyte.port:5433}")
    private int port;
    @Value(value="${spring.yugabyte.database:yugabyte}")
    private String database;
    @Value(value="${spring.yugabyte.user:yugabyte}")
    private String user;
    @Value(value="${spring.yugabyte.password:yugabyte}")
    private String password;
    @Value(value="${spring.yugabyte.maxPoolSizePerNode:8}")
    private int maxPoolSizePerNode;
    @Value(value="${spring.yugabyte.autoCommit:true}")
    private boolean autoCommit;
    @Value(value="${spring.yugabyte.connectionTimeoutMs:10000}")
    private int connectionTimeoutMs;
    @Value(value="${spring.yugabyte.generate-ddl:false}")
    private boolean generateDdl;
    @Value(value="${spring.yugabyte.packages-to-scan}")
    private String packagesToScan;

    @Bean
    public DataSource dataSource() {
        YBClusterAwareDataSource ds = new YBClusterAwareDataSource();
        ds.setInitialHost(this.initialHost);
        ds.setPort(this.port);
        ds.setDatabase(this.database);
        ds.setUser(this.user);
        ds.setPassword(this.password);
        ds.setMaxPoolSizePerNode(this.maxPoolSizePerNode);
        ds.setAutoCommit(this.autoCommit);
        ds.setConnectionTimeoutMs(this.connectionTimeoutMs);
        return ds;
    }

    @Bean
    public JpaTransactionManager transactionManager(EntityManagerFactory emf) {
        return new JpaTransactionManager(emf);
    }

    @Bean
    public HibernateJpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        adapter.setGenerateDdl(this.generateDdl);
        adapter.setDatabase(Database.POSTGRESQL);
        return adapter;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setPackagesToScan(new String[]{this.packagesToScan});
        em.setPersistenceProvider((PersistenceProvider)new HibernatePersistenceProvider());
        em.setDataSource(this.dataSource());
        em.setJpaVendorAdapter((JpaVendorAdapter)this.jpaVendorAdapter());
        return em;
    }
}

