/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.YugabyteContainerConstants;
import org.testcontainers.containers.delegate.YugabyteYCQLDelegate;
import org.testcontainers.containers.strategy.YugabyteYCQLWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.utility.DockerImageName;

public class YugabyteYCQLContainer
extends GenericContainer<YugabyteYCQLContainer> {
    private String keyspace;
    private String username;
    private String password;
    private String initScript;

    public YugabyteYCQLContainer(String imageName) {
        this(DockerImageName.parse((String)imageName));
    }

    public YugabyteYCQLContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{YugabyteContainerConstants.DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{YugabyteContainerConstants.YCQL_PORT, YugabyteContainerConstants.MASTER_DASHBOARD_PORT, YugabyteContainerConstants.TSERVER_DASHBOARD_PORT});
        this.waitingFor(new YugabyteYCQLWaitStrategy((WaitStrategyTarget)this).withStartupTimeout(Duration.ofSeconds(60L)));
        this.withCommand("bin/yugabyted start --daemon=false");
    }

    protected void configure() {
        this.addEnv("YCQL_KEYSPACE", this.keyspace);
        this.addEnv("YCQL_USER", this.username);
        this.addEnv("YCQL_PASSWORD", this.password);
    }

    public YugabyteYCQLContainer withInitScript(String initScript) {
        this.initScript = initScript;
        return this;
    }

    public YugabyteYCQLContainer withKeyspaceName(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public YugabyteYCQLContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public YugabyteYCQLContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.initScript != null) {
            ScriptUtils.runInitScript((DatabaseDelegate)new YugabyteYCQLDelegate(this.getSessionBuilder()), (String)this.initScript);
        }
    }

    public CqlSession getSession() {
        return (CqlSession)this.getSessionBuilder().build();
    }

    public CqlSessionBuilder getSessionBuilder() {
        return (CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withLocalDatacenter("datacenter1")).withKeyspace(this.getKeyspace())).withAuthCredentials(this.getUsername(), this.getPassword())).addContactPoint(new InetSocketAddress(this.getHost(), (int)this.getMappedPort(YugabyteContainerConstants.YCQL_PORT)));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyspace() {
        return this.keyspace;
    }
}

