/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.YugabyteContainerConstants;
import org.testcontainers.containers.strategy.YugabyteYSQLWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class YugabyteYSQLContainer
extends JdbcDatabaseContainer<YugabyteYSQLContainer> {
    private String database = "yugabyte";
    private String username = "yugabyte";
    private String password = "yugabyte";

    public YugabyteYSQLContainer(String imageName) {
        this(DockerImageName.parse((String)imageName));
    }

    public YugabyteYSQLContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{YugabyteContainerConstants.DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{YugabyteContainerConstants.YSQL_PORT, YugabyteContainerConstants.MASTER_DASHBOARD_PORT, YugabyteContainerConstants.TSERVER_DASHBOARD_PORT});
        this.waitingFor(new YugabyteYSQLWaitStrategy((WaitStrategyTarget)this).withStartupTimeout(Duration.ofSeconds(60L)));
        this.withCommand("bin/yugabyted start --daemon=false");
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Collections.singleton(this.getMappedPort(YugabyteContainerConstants.YSQL_PORT));
    }

    protected void configure() {
        this.addEnv("YSQL_DB", this.database);
        this.addEnv("YSQL_USER", this.username);
        this.addEnv("YSQL_PASSWORD", this.password);
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getMappedPort(YugabyteContainerConstants.YSQL_PORT) + "/" + this.database + this.constructUrlParameters("?", "&");
    }

    public String getDatabaseName() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public YugabyteYSQLContainer withDatabaseName(String database) {
        this.database = database;
        return this;
    }

    public YugabyteYSQLContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public YugabyteYSQLContainer withPassword(String password) {
        this.password = password;
        return this;
    }
}

