/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.strategy;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.YugabyteYCQLContainer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public final class YugabyteYCQLWaitStrategy
extends AbstractWaitStrategy {
    private final WaitStrategyTarget target;

    public void waitUntilReady(WaitStrategyTarget target) {
        YugabyteYCQLContainer container = (YugabyteYCQLContainer)target;
        Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            this.getRateLimiter().doWhenReady(() -> {
                try (CqlSession session = container.getSession();){
                    session.execute("SELECT release_version FROM system.local");
                }
            });
            return true;
        });
    }

    public void waitUntilReady() {
        this.waitUntilReady(this.target);
    }

    public YugabyteYCQLWaitStrategy(WaitStrategyTarget target) {
        this.target = target;
    }
}

