/**
 * +-------------------------------------------------------------------------
 * | Copyright (C) 2017 Yunify, Inc.
 * +-------------------------------------------------------------------------
 * | Licensed under the Apache License, Version 2.0 (the "License");
 * | you may not use this work except in compliance with the License.
 * | You may obtain a copy of the License in the LICENSE file, or at:
 * |
 * | http://www.apache.org/licenses/LICENSE-2.0
 * |
 * | Unless required by applicable law or agreed to in writing, software
 * | distributed under the License is distributed on an "AS IS" BASIS,
 * | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * | See the License for the specific language governing permissions and
 * | limitations under the License.
 * +-------------------------------------------------------------------------
 **/
package com.test;

import com.google.gson.Gson;
import com.qingstor.sdk.client.ImageProcessClient;
import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.BodyProgressListener;
import com.qingstor.sdk.request.CancellationHandler;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Bucket.DeleteMultipleObjectsOutput;
import com.qingstor.sdk.service.Bucket.DeleteObjectOutput;
import com.qingstor.sdk.service.Bucket.GetObjectOutput;
import com.qingstor.sdk.service.Bucket.InitiateMultipartUploadOutput;
import com.qingstor.sdk.service.Bucket.PutObjectOutput;
import com.qingstor.sdk.service.Bucket.UploadMultipartOutput;
import com.qingstor.sdk.service.QingStor;
import com.qingstor.sdk.service.Types;
import com.qingstor.sdk.service.Types.KeyModel;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class QingStorAsyncUnitTest {

    public static String QC_STOR_CONTENT_TEXT = "text/plain; charset=utf-8";
    public static String QC_STOR_CONTENT_JSON = "application/vnd.android.package-archive";
    public static String QC_STOR_CONTENT_MULTI = "multipart/form-data;";
    public static String config = "/Users/chengww/eclipse-workspace/qingstor-sdk-java/tests/";
    private boolean executeFlag = false;
    public static String sh1a = "sh1a";

    public void qcstorHeadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "test0222211");
        Bucket.HeadObjectInput input = new Bucket.HeadObjectInput();
        Bucket.HeadObjectOutput o = bucket.headObject("qingcloud-android-app.apk", input);
        System.out.println(o.getMessage());

    }

    boolean bEexcute = false;

    /*
     *
     *
     *
     */
    public void testPoolPutObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);

        for (int i = 0; i < 100; i++) {
            Bucket bucket = new Bucket(evn, sh1a, "test0222211");
            Bucket.HeadObjectInput input = new Bucket.HeadObjectInput();
            Bucket.HeadObjectOutput o = bucket.headObject("qingcloud-android-app.apk", input);
            System.out.println(o.getMessage());

            Bucket bucket2 = new Bucket(evn, sh1a, "test01");
            Bucket.PutObjectInput input2 = new Bucket.PutObjectInput();
            input2.setContentType(QC_STOR_CONTENT_TEXT);
            File f = new File("/tmp/config.yaml");
            input2.setContentLength(f.length());
            input2.setBodyInputFile(new File("/tmp/config.yaml"));

            Bucket.PutObjectOutput ooo = bucket2.putObject("ttt.txt", input2);
            System.out.println(ooo.getMessage());

            Bucket bucket3 = new Bucket(evn, sh1a, "test03");
            Bucket.GetBucketStatisticsOutput os = bucket3.getStatistics();
            System.out.println(os.getMessage());
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }
    }

    class PutObjectRunable implements Runnable {

        @Override
        public void run() {
            try {

                EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
                // evn.setLog_level(QSConstant.LOGGER_INFO);

                for (int i = 0; i < 100; i++) {
                    Bucket bucket2 = new Bucket(evn, sh1a, "test01");
                    Bucket.PutObjectInput input2 = new Bucket.PutObjectInput();
                    input2.setContentType(QC_STOR_CONTENT_TEXT);
                    File f = new File("/tmp/wifi-Bq5Lr5.log");
                    input2.setContentLength(f.length());
                    input2.setBodyInputFile(f);
                    Bucket.PutObjectOutput out = bucket2.putObject("kdkd大家都觉得就", input2);
                    System.out.println(out.getMessage());
                }
                while (!bEexcute) {
                    Thread.sleep(10000);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     *
     *
     *
     */
    public void getMultiThread() throws Exception {
        for (int i = 0; i < 100; i++) {
            PutObjectRunable tt = new PutObjectRunable();
            new Thread(tt).start();
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }
    }

    /*
     *
     *
     *
     */
    public void qcstorStatisObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "test909");
        Bucket.PutObjectInput input = new Bucket.PutObjectInput();
        Bucket.PutObjectOutput copyOutput = bucket.putObject("test/", input);
        // Bucket.GetBucketStatisticsOutput o = bucket.getStatistics();
        System.out.println(copyOutput.getMessage());

    }

    static String[] objectTestName = {"testddd/idi", "测试\"01+{*~}", ",./;'[]\\-=+", "찦차를 타고 온 펲시맨과 쑛다리 똠방각하+",
            "xia/屏幕快照 2017-05-05 上午10.54.02.png", "\uD83D\uDC7E \uD83D\uDE47 \uD83D\uDC81 /test端口"};

    public void testListBucket() throws QSException {
        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        // evn.setLog_level(QSConstant.LOGGER_INFO);
        QingStor storService = new QingStor(evn, sh1a);
        QingStor.ListBucketsInput input = new QingStor.ListBucketsInput();
        input.setLocation("sh1a");
        QingStor.ListBucketsOutput out = storService.listBuckets(input);
        System.out.println(out.getBuckets().size());
    }

    public static void main(String[] args) throws Exception {
        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");

        QingStor storService = new QingStor(evn, sh1a);
        Bucket bucket = storService.getBucket("chengww-test", "sh1a");
//        BodyProgressListener listener = new BodyProgressListener() {
//            @Override
//            public void onProgress(long len, long size) {
//                System.out.println("progress = " + (len * 100) / size);
//            }
//        };
//
//        boolean isCancelled = false;
//        CancellationHandler cancellationHandler = new CancellationHandler() {
//            @Override
//            public boolean isCancelled() {
//                return isCancelled;
//            }
//        };
//
//        UploadManagerCallback callback = new UploadManagerCallback() {
//            @Override
//            public String onSignature(String strToSign) {
//
//                return null;
//            }
//
//            @Override
//            public String onAccessKey() {
//                return null;
//            }
//
//            @Override
//            public void onAPIResponse(OutputModel output) throws QSException {
//                System.out.println("code = " + output.getCode());
//                System.out.println("statueCode = " + output.getStatueCode());
//                System.out.println("message = " + output.getMessage());
//                System.out.println("request ID = " + output.getRequestId());
//                System.out.println("url = " + output.getUrl());
//            }
//        };
//        UploadManager manager = new UploadManager(bucket, new FileRecorder("/Users/chengww/Downloads/records"), listener, cancellationHandler, callback);
//        new Thread(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    manager.put(new File("/Users/chengww/Downloads/紧急审讯室.kinkyu.torishirabeshitsu.s02e02.chi_jap.hdtvrip.1280x720-zhuixinfan.mp4"));
//                } catch (QSException e) {
//                    e.printStackTrace();
//                }
//            }
//        }).start();
        QingStorAsyncUnitTest test = new QingStorAsyncUnitTest();
        test.imageProgressClient();

//		test.跨区存储(bucket);
//        test.testChengww();
//		test.qcstorPutUploadObject();

//		evn.setSafeOkHttp(false);
        // test.md5testaaa();
//		 test.qcstorPutUploadObjectMd5(bucket);
        // test.qcstorPutDownObjectMd5();
//		test.objectTest(bucket);
//        test.mulitUploadMd5(bucket);
        //test.qsGetSignatureUrlObject(bucket);
//		test.qcstorGetDownObjectMulti();
        // test.deleteMultil(bucket);
        // for (String name : objectTestName) {
        // test.testSingnature(name + "signatureTest");
        // }
//		while (true) {
        // Thread.sleep(1000);
//		}
//		test.qcstorGetUploadObject();
    }


    public void testSingnature(String objectName) {

        try {
            EvnContext evn = new EvnContext("", "");
            Bucket bucket = new Bucket(evn, sh1a, "sh-test");

            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
            File fa = new File("/tmp/config.yaml");
            putObjectInput.setBodyInputFile(fa);
            putObjectInput.setContentLength(fa.length());

            // bucket.putObject(objectName, putObjectInput);

            // 获取请求对象，正常 bucket.putObject(objectName, putObjectInput); 就完成操作
            RequestHandler reqHandler = bucket.putObjectAsyncRequest(objectName, putObjectInput,
                    new ResponseCallBack<PutObjectOutput>() {
                        @Override
                        public void onAPIResponse(PutObjectOutput output) throws QSException {
                            System.out.println("-testSingnature--getMessage---" + output.getMessage());
                            System.out.println("-testSingnature-getRequµestId--" + output.getRequestId());
                            System.out.println("-testSingnature-getCode----" + output.getCode());
                            System.out.println("-testSingnature-getStatueCode----" + output.getStatueCode());
                        }
                    });

            // strToSignature 将这个发送到用户的server端
            String strToSignature = reqHandler.getStringToSignature();

            // serverAuthorization server端处理返回信息，这里本地模拟
            String serverAuthorization = QSSignatureUtil.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv",
                    strToSignature);

            // 将计算的签名设置到request中
            reqHandler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization);

            reqHandler.sendAsync();

        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    public void deleteMultil(Bucket bucket) throws QSException, Exception {
        Bucket.ListObjectsInput input = new Bucket.ListObjectsInput();
        Bucket.ListObjectsOutput listObjectsOutput = new Bucket.ListObjectsOutput();
        input.setLimit(10);
        try {
            listObjectsOutput = bucket.listObjects(input);
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

        Bucket.DeleteMultipleObjectsInput deleteInput = new Bucket.DeleteMultipleObjectsInput();

        List<KeyModel> lstKey = new ArrayList();
        KeyModel m;
        for (int i = 0; i < listObjectsOutput.getKeys().size(); i++) {
            Types.KeyModel key = listObjectsOutput.getKeys().get(i);
            // deleteKey newKey = new deleteKey();
            System.out.println(key.getKey());
            m = new KeyModel();
            m.setKey(key.getKey());
            long time = new Date().getTime() / 1000 + 1000;
            RequestHandler handler = bucket.GetObjectBySignatureUrlRequest(key.getKey(), null, time);
            String url = handler.getExpiresRequestUrl();

            String dff = bucket.GetObjectSignatureUrl(key.getKey(), time);
            String strToSignature = handler.getStringToSignature();
            // serverAuthorization server端处理返回信息
            String serverAuthorization = QSSignatureUtil.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv",
                    strToSignature);

            // 将计算的签名设置到request中
            handler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization + "1111111");
            String url2 = handler.getExpiresRequestUrl();

            System.out.println(dff);
            System.out.println(url);
            System.out.println(url2);
            bucket.GetObjectBySignatureUrlAsync(url, new ResponseCallBack<Bucket.GetObjectOutput>() {

                @Override
                public void onAPIResponse(GetObjectOutput out) throws QSException {
                    // TODO Auto-generated method stub
                    System.out.println(out.getStatueCode() + ":--aaa---" + out.getMessage());
                    try {
                        if (out.getBodyInputStream() != null) {
                            File ff = new File("/tmp/get_SignatureUrlAsync.txt");
                            OutputStream outa = new FileOutputStream(ff);
                            int bytesRead = 0;
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = out.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                                outa.write(buffer, 0, bytesRead);
                                // iLength += bytesRead;
                            }
                            outa.close();
                            out.getBodyInputStream().close();
                        }
                    } catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                }
            });
            ;

            lstKey.add(m);
            // newKey.key = key.getKey();
            // newInput.objects.add(newKey);
        }

        deleteInput.setObjects(lstKey);
        // String objectToJson = JSON.toJSONString(newInput);

        // deleteInput.setBodyInput(objectToJson);
        // deleteInput.setObjects(listObjectsOutput.getKeys());

        try {
            bucket.deleteMultipleObjectsAsync(deleteInput, new ResponseCallBack<Bucket.DeleteMultipleObjectsOutput>() {

                @Override
                public void onAPIResponse(DeleteMultipleObjectsOutput output) throws QSException {
                    // TODO Auto-generated method stub
                    System.out.println("deleteMultipleObjectsAsync--:" + output.getMessage());
                    System.out.println("deleteMultipleObjectsAsync--size:--" + output.getDeleted().size());
                }
            });

        } catch (

                Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void objectTest(Bucket bucket) throws Exception {
        QSSignatureUtil.generateSignature("secretKey", "strToSign");
        int index = 0;
        for (String name : objectTestName) {
            this.qsPutObjectByName(name, bucket);
            this.qsGetObject(name, bucket, index++);
            /*
             * this.qsPutObjectByName(name, bucket);
             * this.qsPutObjectByNameSetSignature(name + "signature", bucket);
             * this.qsDeleteObjectByName(name, bucket);
             * this.qsPutObjectByName(name, bucket); this.qsMoveObject(name,
             * bucket); this.qsDeleteObjectByName(name + "toMove", bucket);
             */

        }

        for (int i = 0; i < 1000; i++) {
            this.qsGetObject(objectTestName[0], bucket, i);

        }

    }

    public void qsGetSignatureUrlObject(Bucket bucket) throws QSException {
        GetObjectOutput out = bucket.GetObjectBySignatureUrl("https://movies.pek3a.qingstor.com/sherlock-s04e01.mp4");
        long begin = System.currentTimeMillis();
        try {
            File ff = new File("/tmp/bigdownload.mp4");
            OutputStream outStream = null;
            try {
                outStream = new FileOutputStream(ff);
                int bytesRead = 0;
                byte[] buffer = new byte[1024];
                while ((bytesRead = out.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                outStream.close();
                out.getBodyInputStream().close();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }

            long dd = begin - System.currentTimeMillis();
            // System.out.println("end:" + (System.currentTimeMillis()));
            System.err.println("end-----------------" + ":" + (dd));
            Thread.sleep(200);

            // out.getBodyInputStream().close();
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
    }


    public void qsGetObject(String objectName, Bucket bucket, int index) throws QSException {

        Bucket.GetObjectInput input = new Bucket.GetObjectInput();
        long begin = System.currentTimeMillis();
        // System.out.println("begin:" + begin);
        // GetBucketACLOutput out = bucket.getACL();
        GetObjectOutput out = bucket.getObject(objectName, input);
        // Bucket.GetObjectOutput output =
        // bucket.getObject("test/test-ac", input);

        System.out.println(out.getMessage());
        System.out.println(out.getStatueCode());
        try {
            File ff = new File("/tmp/loadtest.txt");
            OutputStream outStream = null;
            try {
                outStream = new FileOutputStream(ff);
                int bytesRead = 0;
                byte[] buffer = new byte[1024];
                while ((bytesRead = out.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                outStream.close();
                out.getBodyInputStream().close();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }

            long dd = begin - System.currentTimeMillis();
            // System.out.println("end:" + (System.currentTimeMillis()));
            System.err.println("end-----------------" + index + ":" + (dd));
            Thread.sleep(200);

            // out.getBodyInputStream().close();
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }

    }

    public void qsPutObjectByName(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
            File fa = new File(
                    "/Users/karooli/qingcloud/app/Qingstor-SDK/app/src/test/java/com/qingstor/sdk/QingStorUnitTest.java");
            putObjectInput.setBodyInputFile(fa);
            putObjectInput.setContentType("text/plain");
            putObjectInput.setContentLength(fa.length());
            System.out.println(fa.length());

            // bucket.putObject(objectName, putObjectInput);
            bucket.putObjectAsync(objectName, putObjectInput, new ResponseCallBack<Bucket.PutObjectOutput>() {

                @Override
                public void onAPIResponse(PutObjectOutput output) throws QSException {
                    // TODO Auto-generated method stu

                    System.out.println("---getMessage---" + output.getMessage());
                    System.out.println("--getRequestId--" + output.getRequestId());
                    System.out.println("--getCode----" + output.getCode());
                    System.out.println("--getStatueCode----" + output.getStatueCode());
                }

            });

        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    public void qsPutObjectByNameSetSignature(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
            File fa = new File(
                    "/Users/karooli/qingcloud/app/Qingstor-SDK/app/src/test/java/com/qingstor/sdk/QingStorUnitTest.java");
            putObjectInput.setBodyInputFile(fa);
            putObjectInput.setContentType("video/mp4; charset=utf8");
            putObjectInput.setContentLength(fa.length());

            // bucket.putObject(objectName, putObjectInput);

            // 获取请求对象，正常 bucket.putObject(objectName, putObjectInput); 就完成操作
            RequestHandler reqHandler = bucket.putObjectAsyncRequest(objectName, putObjectInput,
                    new ResponseCallBack<Bucket.PutObjectOutput>() {

                        @Override
                        public void onAPIResponse(PutObjectOutput output) throws QSException {
                            // TODO Auto-generated method stub
                            System.out.println("-reqHandler--getMessage---" + output.getMessage());
                            System.out.println("-reqHandler-getRequµestId--" + output.getRequestId());
                            System.out.println("-reqHandler-getCode----" + output.getCode());
                            System.out.println("-reqHandler-getStatueCode----" + output.getStatueCode());
                        }
                    });

            // strToSignature 将这个发送到用户的server端
            String strToSignature = reqHandler.getStringToSignature();

            // serverAuthorization server端处理返回信息
            String serverAuthorization = QSSignatureUtil.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv",
                    strToSignature);

            // 将计算的签名设置到request中
            reqHandler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization);

            reqHandler.sendAsync();

        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    public void qsDeleteObjectByName(String objectName, Bucket bucket) throws Exception {

        try {

            bucket.deleteObjectAsync(objectName, new ResponseCallBack<Bucket.DeleteObjectOutput>() {

                @Override
                public void onAPIResponse(DeleteObjectOutput output) throws QSException {
                    // TODO Auto-generated method stub
                    System.out.println("-deleteObjectAsync--getMessage---" + output.getMessage());
                    System.out.println("-deleteObjectAsync-getRequµestId--" + output.getRequestId());
                    System.out.println("-deleteObjectAsync-getCode----" + output.getCode());
                    System.out.println("-deleteObjectAsync-getStatueCode----" + output.getStatueCode());
                }
            });

        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    public void qsMoveObject(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            input.setXQSMoveSource("/sh-test/" + objectName);

            bucket.putObjectAsync(objectName + "toMove", input, new ResponseCallBack<Bucket.PutObjectOutput>() {

                @Override
                public void onAPIResponse(PutObjectOutput output) throws QSException {
                    System.out.println("-qsMoveObject--getMessage---" + output.getMessage());
                    System.out.println("-qsMoveObject-getRequµestId--" + output.getRequestId());
                    System.out.println("-qsMoveObject-getCode----" + output.getCode());
                    System.out.println("-qsMoveObject-getStatueCode----" + output.getStatueCode());
                }
            });

        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    public void qsDeleteObjectaaa(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.DeleteObjectOutput out = bucket.deleteObject(objectName);

            System.out.println("d--d" + out.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcCopyObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        QingStor storService = new QingStor(evn, sh1a);
        try {
            Bucket bucket = storService.getBucket("test-ac", "pek3a");

            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            input.setXQSCopySource("/test-ac/test-acaaf");

            Bucket.PutObjectOutput copyOutput = bucket.putObject("test/test-ac", input);

            /*
             * Bucket.PutObjectInput input = new Bucket.PutObjectInput(); File f
             * = new File("/tmp/oobelib.log"); input.setBodyInputFile(f);
             * input.setContentType("text/plain"); input.setContentLength((int)
             * f.length()); bucket.putObjectAsync("test-acaaf", input, new
             * ResponseCallBack<Bucket.PutObjectOutput>() {
             *
             * @Override public void onAPIResponse(Bucket.PutObjectOutput
             * output) throws QSException {
             * System.out.println("d--d"+output.getMessage()); } });
             */
            // Bucket.PutObjectOutput putObjectOutput =
            // bucket.putObject("private-img", input);
            System.out.println(copyOutput.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }

    }

    /*
     *
     *
     *
     */
    public void qcPutObjecteee() throws Exception {

        EvnContext evn = new EvnContext("CYQCHVBDUSZSBBBKEXDX", "tRlGgRG7Hp7S93byC22XOIINWhytJcaYEgTEE3FX");
        QingStor storService = new QingStor(evn, sh1a);
        try {
            Bucket bucket = storService.getBucket("private-img", "pek3a");
            Bucket.PutBucketOutput putBucketOutput = bucket.put();

            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            File f = new File("/tmp/oobelib.log");
            input.setBodyInputFile(f);
            input.setContentType("text/plain");
            input.setContentLength(f.length());
            bucket.putObjectAsync("private-test", input, new ResponseCallBack<Bucket.PutObjectOutput>() {
                @Override
                public void onAPIResponse(Bucket.PutObjectOutput putObjectOutput) throws QSException {
                    System.out.println(putObjectOutput.getMessage());
                }
            });
        } catch (QSException e) {
            e.printStackTrace();
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }

    }

    public static void traverseFolder(Bucket bucket, String path) {

        try {

            File file = new File(path);
            if (file.exists()) {
                File[] files = file.listFiles();
                if (files.length == 0) {
                    return;
                } else {
                    for (File file2 : files) {
                        if (file2.isDirectory()) {
                            traverseFolder(bucket, file2.getAbsolutePath());
                        } else {
                            // System.out.println("文件:" +
                            // file2.getAbsolutePath());
                            String fileName = file2.getName();
                            Bucket.PutObjectInput ii = new Bucket.PutObjectInput();
                            ii.setBodyInputFile(file2);
                            bucket.putObjectAsync(fileName, ii, new ResponseCallBack<Bucket.PutObjectOutput>() {
                                @Override
                                public void onAPIResponse(Bucket.PutObjectOutput output) throws QSException {
                                    System.out.println(output.getMessage() + "----" + output.getCode());
                                }
                            });
                        }
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     *
     *
     *
     */
    public void getAcl() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        Bucket bucket = new Bucket(evn, sh1a, "test0222211");
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        int id = 0;
        while (!executeFlag) {
            Thread.sleep(15000);
        }
    }

    /*
     *
     *
     *
     */
    public void delete_multiple_objects() throws Throwable {
        // Write code here that turns the phrase above into concrete actions

        Bucket.DeleteMultipleObjectsInput input = new Bucket.DeleteMultipleObjectsInput();

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "test-ac");
        // arg1.raw().get(1)
        // input.setBodyInput("{\"quiet\":false,\"objects\":[{\"key\":\"object_0\"},{\"key\":\"object_1\"},{\"key\":\"object_2\"}]}");
        input.setQuiet(false);
        List<Types.KeyModel> objects = new ArrayList<Types.KeyModel>();
        Types.KeyModel mm1 = new Types.KeyModel();
        mm1.setKey("object_0");
        Types.KeyModel mm2 = new Types.KeyModel();
        mm2.setKey("object_0");
        Types.KeyModel mm3 = new Types.KeyModel();
        mm3.setKey("object_0");
        objects.add(mm1);
        objects.add(mm2);
        objects.add(mm3);
        input.setObjects(objects);
        // input.setContentMD5("1UK03AxvZpSNLmYR2oz4qg==");
        Bucket.DeleteMultipleObjectsOutput deleteMultipleObjectsOutput = bucket.deleteMultipleObjects(input);

        System.out.println(deleteMultipleObjectsOutput.getMessage());
        // throw new PendingException();
    }

    /*
     *
     *
     *
     */
    public void qcstorGetUploadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "chengww-test");

        // https://test-ac.pek3a.qingst.com:443/%E5%B0%8F%E7%B1%B3%2Fchart.jpg

        try {

            try {
                Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
//				putObjectInput.setContentDisposition(URLEncoder.encode("测试中文文件名.py", "utf-8"));
                putObjectInput.setBodyInputFile(new File("/Users/chengww/Downloads/test.pdf"));
                Bucket.PutObjectOutput output = bucket.putObject("test.pdf", putObjectInput);
                // Bucket.GetObjectOutput output =
                // bucket.getObject("test/test-ac", input);

                System.out.println(output.getMessage());

            } catch (Exception e) {
                e.printStackTrace();
            }

            /*
             * String dd =
             * bucket.GetObjectSignatureUrl("中文测试/test_object/中+文test",2000);
             * Bucket.GetObjectOutput outpucct =
             * bucket.GetObjectBySignatureUrl(dd);
             * Bucket.GetBucketStatisticsOutput doo = bucket.getStatistics();
             */

            Bucket.GetObjectInput input = new Bucket.GetObjectInput();
            // Bucket.GetObjectOutput output = bucket.getObject("小米/chart.jpg",
            // input);
            Bucket.GetObjectOutput output = bucket.getObject("test.pdf", input);


            System.out.println(output.getStatueCode());
            if (output.getBodyInputStream() != null && output.getStatueCode() == 200) {
                File ff = new File("/Users/chengww/" + URLDecoder.decode(output.getContentDisposition(), "utf-8"));
                OutputStream out = null;
                try {
                    out = new FileOutputStream(ff);
                    int bytesRead = 0;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = output.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    out.close();
                    output.getBodyInputStream().close();
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }

            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstoraaPutUploadObject() throws Exception {

        String uncode = URLEncoder.encode("te%+ *st.htm", QSConstant.ENCODING_UTF8);
        System.out.println(uncode);

    }

    public void testChengww() {
        EvnContext evn = null;
        try {
            evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        } catch (QSException e) {
            e.printStackTrace();
        }
        Bucket bucket = new Bucket(evn, sh1a, "chengww-test");
        try {
//			MyPutObjectInput putObjectInput = new MyPutObjectInput();
//			String fileName = QSStringUtil.percentEncode("测试文件名(1).png", "utf-8");
//			putObjectInput.setContentDisposition(String.format("attachment; filename=\"%s\"; filename*=utf-8''%s", fileName, fileName));
//			putObjectInput.setBodyInputFile(new File("/Users/chengww/Downloads/huaban.png"));
//			//first param is the original name(key) of the object when download.
//			bucket.putObject("huaban.png", putObjectInput);

//			RequestHandler requestHandler = bucket.GetObjectBySignatureUrlRequest("huaban.png", null, System.currentTimeMillis()/1000 + 60*60);
//			System.out.println(requestHandler.getExpiresRequestUrl());
            Bucket.GetObjectOutput output2 = bucket.getObject("huaban.png", null);
            System.out.println("ETag2 = " + output2.getUrl());
            if (output2.getBodyInputStream() != null && output2.getStatueCode() == 200) {
                //自行判断是否空字符串并处理前缀"attachment; filename=..."
                File file = new File("/Users/chengww/Desktop/" + URLDecoder.decode(output2.getContentDisposition(), "utf-8"));
                OutputStream out = null;
                out = new FileOutputStream(file);
                int bytesRead = 0;
                byte[] buffer = new byte[1024];
                while ((bytesRead = output2.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.close();
                output2.getBodyInputStream().close();
            }
            Bucket.HeadObjectOutput output = bucket.headObject("huaban.png", null);
            System.out.println("status_code = " + output.getStatueCode());
            System.out.println("ETag = " + output.getETag());
            System.out.println("XQSEncryptionCustomerAlgorithm = " + output.getXQSEncryptionCustomerAlgorithm());
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    private void imageProgressClient() throws QSException {
        EvnContext evn = new EvnContext("key", "secret");
//        EvnContext evn = null;
//        try {
//            evn = EvnContext.loadFromFile(config + "config_stor.yaml");
//        } catch (QSException e) {
//            e.printStackTrace();
//        }
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(
                evn, sh1a, "chengww-test");
        ImageProcessClient client = new ImageProcessClient("head.jpg", bucket);

        // Get image info
        Bucket.ImageProcessOutput imageProcessOutput = client.info().imageProcess();
        String result = inputStream2Json(imageProcessOutput.getBodyInputStream());
        if (imageProcessOutput.getStatueCode() >= 200 && imageProcessOutput.getStatueCode() < 300) {
            // Success
            ImageInfoBean imageInfo = new Gson().fromJson(result, ImageInfoBean.class);

            System.out.println("Width = " + imageInfo.getWidth() + " px");
            System.out.println("Height = " + imageInfo.getHeight() + " px");
            System.out.println("Orientation = " + imageInfo.getOrientation());
            System.out.println("isAlpha = " + imageInfo.isAlpha());
            System.out.println("Type = " + imageInfo.getType());
            System.out.println("Space = " + imageInfo.getSpace());
        } else { // Failed
            OutputModel outputModel = new Gson().fromJson(result, OutputModel.class);
            outputModel.setStatueCode(imageProcessOutput.getStatueCode());

            System.out.println("Get image info request failed.");
            System.out.println("StatueCode = " + outputModel.getStatueCode());
            System.out.println("Code = " + outputModel.getCode());
            System.out.println("RequestId = " + outputModel.getRequestId());
            System.out.println("Message = " + outputModel.getMessage());
            System.out.println("Url = " + outputModel.getUrl());
        }

        ImageProcessClient actionClient = new ImageProcessClient("head.jpg", bucket);
        actionClient.crop(new ImageProcessClient.CropParam.Builder() // Image crop
                .width(100)
                .height(100)
                .gravity(0) // 0 = center; 1 = north; 2 = east; 3 = south; 4 = west; 5 = north west;
                // 6 = north east;7 = south west; 8 = south east;; 9 = auto; default = 0.
                .build())
                .rotate(new ImageProcessClient.RotateParam(90)) // Rotate
                .resize(new ImageProcessClient.ResizeParam.Builder() // Resize
                        .width(200)
                        .height(200)
                        .mode(0) // 0 表示固定宽高，缩略填充；1 表示根据宽高自动调节；2 表示按照宽高比为 4:4 进行缩略，若 width 和 height 只设置了其中一个，则按照宽度或者高度等比缩放。默认为 0。
                        .build())
                .waterMark(new ImageProcessClient.WaterMarkParam.Builder("text")
                        .color("#FFFFFF")
                        .dpi(400)
                        .opacity(0.8)
                        .build())
                .waterMarkImage(new ImageProcessClient.WaterMarkImageParam.Builder("https://www.qingcloud.com/static/assets/images/icons/common/footer_logo.svg")
                        .left(400)
                        .top(400)
                        .opacity(1)
                        .build())
                .format(new ImageProcessClient.FormatParam("png")); // Available: jpeg, png, webp, tiff

        // Download image with a expired request url
        RequestHandler requestHandler = actionClient.getImageProgressExpiredUrlRequest(System.currentTimeMillis() / 1000 + 1000);
        System.out.println("Image download url = " + requestHandler.getExpiresRequestUrl());
        // Download image with a network connection
        Bucket.ImageProcessOutput output = actionClient.imageProcess();
        try {
            InputStream bodyInputStream = output.getBodyInputStream();
            if (output.getStatueCode() >= 200 && output.getStatueCode() < 300) {
                // Success, save image
                File ff = new File("Your file kept path");
                OutputStream out = null;

                out = new FileOutputStream(ff);
                int bytesRead = 0;
                byte[] buffer = new byte[1024];
                while ((bytesRead = bodyInputStream.read(buffer, 0, 1024)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
                out.close();
            } else {
                // Handler error
                String jsonResult = inputStream2Json(bodyInputStream);
                OutputModel outputModel = new Gson().fromJson(jsonResult, OutputModel.class);
                outputModel.setStatueCode(imageProcessOutput.getStatueCode());

                System.out.println("StatueCode = " + outputModel.getStatueCode());
                System.out.println("Code = " + outputModel.getCode());
                System.out.println("RequestId = " + outputModel.getRequestId());
                System.out.println("Message = " + outputModel.getMessage());
                System.out.println("Url = " + outputModel.getUrl());

            }

            if (bodyInputStream != null) {
                bodyInputStream.close();
            }

            RequestHandler requestHandler1 = new ImageProcessClient("head.jpg", bucket)
                    .rotate(new ImageProcessClient.RotateParam(90))
                    .imageProgressRequest();// Rotate;
            String stringToSignature = requestHandler1.getStringToSignature();
            // ServerAuthorization. Get response from server. We just sign in local here.
            String serverAuthorization = QSSignatureUtil.generateSignature("secretKey",
                    stringToSignature);
            requestHandler1.setSignature("your_access_key", serverAuthorization);
            requestHandler1.send();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    private String inputStream2Json(InputStream bodyInputStream) {
        StringBuilder result = new StringBuilder();
        try {
            if (bodyInputStream != null) {
                String readContent;
                BufferedReader reader = new BufferedReader(new InputStreamReader(bodyInputStream));
                while ((readContent = reader.readLine()) != null) {
                    result.append(readContent);
                    result.append(System.getProperty("line.separator"));
                }
                bodyInputStream.close();
                reader.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return result.toString();

    }

    class ImageInfoBean {

        /**
         * width : 1134
         * height : 1844
         * orientation : 0
         * alpha : true
         * type : png
         * space : srgb
         */

        private int width;
        private int height;
        private int orientation;
        private boolean alpha;
        private String type;
        private String space;

        public int getWidth() {
            return width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getOrientation() {
            return orientation;
        }

        public void setOrientation(int orientation) {
            this.orientation = orientation;
        }

        public boolean isAlpha() {
            return alpha;
        }

        public void setAlpha(boolean alpha) {
            this.alpha = alpha;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSpace() {
            return space;
        }

        public void setSpace(String space) {
            this.space = space;
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorPutUploadObject() throws Exception {

        //init url style
//		QSInitUtil.getInstance().setRequestUrlStyle(QSConstant.BUCKET_NAME_BEHIND_DOMAIN_NAME);
        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(
                evn, sh1a, "chengww-test");
        try {
            /** Below Codes Is Not Required */
            Bucket.ListObjectsInput input = new Bucket.ListObjectsInput();
            String folderName = "test/";
            // Only show objects name start with 'folderName', that is list objects in a folder named "test"
            input.setPrefix(folderName);
            input.setLimit(1000); // Default 200, max 1000
            input.setMarker(folderName); // Sort by name after a object named folderName: "test/"
            /** Above Codes Is Not Required */

            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
            putObjectInput.setContentType("text/pain");
            putObjectInput.setBodyInputFile(new File("/Users/chengww/Downloads/test.txt"));
            RequestHandler requestHandler = bucket.putObjectRequest("test/test.txt", putObjectInput);
            String stringToSignature = requestHandler.getStringToSignature();
            OutputModel output = requestHandler.send();
//            if (output.getStatueCode() == 200) {
//                List<KeyModel> objectKeys = listObjectsOutput.getKeys();
//                if (objectKeys != null && objectKeys.size() > 0) {
//                    for (KeyModel key : objectKeys) {
//                        System.out.println("objectKey = " + key.getKey());
//                        System.out.println("created = " + key.getCreated());
//                        // While mimeType.equals("application/x-directory"), the object is a directory.
//                        System.out.println("mimeType = " + key.getMimeType());
//                        System.out.println("isEncrypted = " + key.getEncrypted());
//                    }
//                } else {
//                    System.out.println("Current bucket: " + listObjectsOutput.getName() + " is empty.");
//                }
//            } else {
            // Handler error
            if (output.getStatueCode() == 401) {
                System.out.println("statueCode = " + output.getStatueCode());
                System.out.println("code = " + output.getCode());
                System.out.println("message = " + output.getMessage());
                System.out.println("requestId = " + output.getRequestId());
                System.out.println("stringToSignature = " + stringToSignature);
            }
//                System.out.println("statueCode = " + listObjectsOutput.getStatueCode());
//                System.out.println("code = " + listObjectsOutput.getCode());
//                System.out.println("message = " + listObjectsOutput.getMessage());
//                System.out.println("requestId = " + listObjectsOutput.getRequestId());
//            }

//
//			Bucket.GetObjectInput input = new Bucket.GetObjectInput();
//			bucket.putObject("test/1234.txt", putObjectInput);
            // Bucket.GetObjectOutput output = bucket.getObject("test/test-ac",
            // input);
//
//			System.out.println(output.getMessage() + output.getStatueCode());
            // Bucket.GetObjectOutput output = bucket.getObject("小米/chart.jpg",
//			// input);
//            Bucket.GetObjectOutput output2 = bucket.getObject("1234.pdf", null);

//            Bucket.GetObjectInput input = new Bucket.GetObjectInput();
//            input.setResponseContentDisposition(output2.getContentDisposition());
//            RequestHandler requestHandler = bucket.GetObjectBySignatureUrlRequest("12344.csv", input, System.currentTimeMillis() + 10000);
//			System.out.println(requestHandler.getExpiresRequestUrl());
//
//            Bucket.GetObjectInput inputs = new Bucket.GetObjectInput();
//            String fileName = "test.pdf";
//            String urlName = QSStringUtil.percentEncode(fileName, "utf-8");
//            inputs.setResponseContentDisposition(String.format("attachment; filename=\"%s\"; filename*=utf-8''%s", urlName, urlName));
//            RequestHandler handle = bucket.GetObjectBySignatureUrlRequest("1234.pdf", inputs, System.currentTimeMillis() / 1000 + 10000);
//            String tempUrl = handle.getExpiresRequestUrl();
//			int index = tempUrl.indexOf("chengww-test");
//			if (index > 0){
//				tempUrl = tempUrl.replaceFirst("chengww-test" + ".","");
//			}
//            System.out.println("tempUr: " + tempUrl);

//            long length = output2.getContentLength();
//            System.out.println("length=" + length);
//            long curLength = 0;
//			if (output2.getBodyInputStream() != null && output2.getStatueCode() == 200) {
//				File ff = new File("/Users/chengww/Desktop/hahaha.dmg");
//				OutputStream out = null;
//
//					out = new FileOutputStream(ff);
//					int bytesRead = 0;
//					byte[] buffer = new byte[1024];
//					while ((bytesRead = output2.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
//						out.write(buffer, 0, bytesRead);
//                        curLength += bytesRead;
//                        System.out.println("progress = " + curLength * 100/length);
//					}
//
//					if (length > 0){
//					    if (curLength == length) System.out.println("download success");
//					    else System.out.println("download failed");
//                    }
//
//					out.close();
//					output2.getBodyInputStream().close();
//
//			}
//
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorCopyUploadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        evn.setRequestUrlStyle(QSConstant.PATH_STYLE);
        Bucket bucket = new Bucket(evn, sh1a, "test-ac2a");

        try {
            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            input.setXQSCopySource("/test-ac2a/中文测试/,./;'[]\\-=/中 文test");
            Bucket.PutObjectOutput copyOutput = bucket.putObject(",./;'[]\\-=test", input);
            System.out.println(copyOutput.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorFloadUploadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "test-ac2a");

        try {

            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            Bucket.PutObjectOutput creatFolderOutput = bucket.putObject("testFolder/", input);
            System.out.println(creatFolderOutput.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorBucket() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        String bucketName = System.currentTimeMillis() + "test";
        Bucket bucket = new Bucket(evn, sh1a, "sh-test");

        try {
            Bucket.ListObjectsInput objectsInput = new Bucket.ListObjectsInput();
            objectsInput.setPrefix("");
            objectsInput.setDelimiter("/");

            Bucket.ListObjectsOutput oo = bucket.listObjects(objectsInput);

            System.out.println(oo.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorUserAgentBucket() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        evn.setAdditionalUserAgent("test/xidksld");
        String bucketName = System.currentTimeMillis() + "test";
        Bucket bucket = new Bucket(evn, sh1a, "sh-test");

        try {
            Bucket.ListObjectsInput objectsInput = new Bucket.ListObjectsInput();
            objectsInput.setPrefix("");
            objectsInput.setDelimiter("/");

            Bucket.ListObjectsOutput oo = bucket.listObjects(objectsInput);

            System.out.println();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorString() throws Exception {

        System.out.println(QSStringUtil.asciiCharactersEncoding(
                "/&:ddks= ssfff中文-test\uD841\uDF0E\uD841\uDF31\uD841\uDF79\uD843\uDC53\uD843\uDC78\uD843\uDC96\uD843\uDCCF"));
        System.out.println(QSStringUtil.asciiCharactersEncoding(
                "!@#$%^&*()`~中文-test\uD841\uDF0E\uD841\uDF31\uD841\uDF79\uD843\uDC53\uD843\uDC78\uD843\uDC96\uD843\uDCCF"));
        System.out.println(100l);
        System.out.println(100);

    }

    /*
     *
     *
     *
     */
    public void qcstorPutaaUploadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "android");

        try {
            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();

            File f = new File("/Users/karooli/Downloads/11aaaa.jpg");
            URLConnection connection = new URL("https://pek3a.qingstor.com/android/11aaaa.jpg").openConnection();
            InputStream inputStream = connection.getInputStream();

            int len = connection.getContentLength();

            // InputStream inputStream = new FileInputStream(f);
            // putObjectInput.setBodyInputFile(f);
            putObjectInput.setBodyInputStream(inputStream);
            putObjectInput.setContentType("image/jpeg");
            putObjectInput.setContentLength(f.length());

            Bucket.GetObjectInput input = new Bucket.GetObjectInput();
            Bucket.PutObjectOutput output = bucket.putObject("测试01/test22.jpg", putObjectInput);

            System.out.println(output.getMessage());

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void mulitUploadMd5(Bucket bucket) throws QSException, FileNotFoundException {

        String objectKey = "chengwwwwwwww.zip";
        Bucket.InitiateMultipartUploadInput inputInit = new Bucket.InitiateMultipartUploadInput();
        /**
         * You can encryption here like the codes below when upload.<br>
         * <br>
         * <code>//Encryption algorithm of the object</code><br>
         * <code>inputInit.setXQSEncryptionCustomerAlgorithm("AES256");</code><br>
         * <code>//Encryption key of the object<br></code>
         * <code>inputInit.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");</code><br>
         * <code><//MD5sum of encryption key</code><br>
         * <code>inputInit.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");</code><br>
         *
         * Get more information:
         * <a href='https://docs.qingcloud.com/qingstor/api/common/encryption.html#object-storage-encryption-headers'>
         *     https://docs.qingcloud.com/qingstor/api/common/encryption.html#object-storage-encryption-headers</a>
         */
        InitiateMultipartUploadOutput initOutput = bucket.initiateMultipartUpload(objectKey, inputInit);
        String multipart_upload_id = initOutput.getUploadID();
        System.out.println("-multipart_upload_id----" + initOutput.getUploadID());

//        File file = new File("/Users/chengww/Downloads/pub-qingstor-sdk-java.zip");
//        FileInputStream fis = new FileInputStream(file);
//        long contentLength = file.length();
//        long partSize = 4 * 1024 * 1024; // Set part size to 4 MB.
//
//
//        // Step 2: Upload parts.
//        StringBuilder uploadJson = new StringBuilder("{\"object_parts\":[");
//        long filePosition = 0;
//        for (int i = 0; filePosition < contentLength; i++) {
//            // Last part can be less than 4 MB. Adjust part size.
//            uploadJson.append("{\"part_number\":").append(i).append("}").append(",");
//            partSize = Math.min(partSize, (contentLength - filePosition));
//            Bucket.UploadMultipartInput input = new Bucket.UploadMultipartInput();
//            input.setBodyInputStream(fis);
//            input.setFileOffset(filePosition);
//            input.setContentLength(partSize);
//            input.setPartNumber(i);
//            input.setUploadID(multipart_upload_id);
//
//            input.setXQSEncryptionCustomerKey(objectKey + i);
////            input.setXQSEncryptionCustomerAlgorithm("AES256");
////            input.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");
////            input.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");
//
//            // Create request to upload a part.
//            bucket.uploadMultipart(objectKey, input);
//
//            filePosition += partSize;
//        }
//        //Delete last char ',' and add ']}' to complete json string.
//        uploadJson.deleteCharAt(uploadJson.length() - 1).append("]}");
//        System.out.println("uploadJson = " + uploadJson);
//
//        // Step 3: Complete.
//        // Write code here that turns the phrase above into concrete actions
//        Bucket.CompleteMultipartUploadInput completeMultipartUploadInput = new Bucket.CompleteMultipartUploadInput();
//        completeMultipartUploadInput.setUploadID(multipart_upload_id);
//        completeMultipartUploadInput.setBodyInput(uploadJson.toString());
//        bucket.completeMultipartUpload(objectKey, completeMultipartUploadInput);

        File f = new File("/Users/chengww/Downloads/pub-qingstor-sdk-java.zip");
        long length = 4 * 1024 * 1024L;// 4MB/part
        if (f.length() < length) length = f.length();
        System.out.println("f.length() = " + f.length());

        FileInputStream fis = new FileInputStream(f);
        byte[] buf = new byte[(int) length];
        System.out.println("buf.length = " + buf.length);
        int len = 0;
        int count = 0;
        try {
            while ((len = fis.read(buf)) != -1) {
                // Step 2: Upload parts.
                Bucket.UploadMultipartInput input = new Bucket.UploadMultipartInput();
                input.setBodyInputStream(new ByteArrayInputStream(buf.clone(), 0, len));
                input.setFileOffset(0L);
                input.setContentLength((long) len);
                input.setPartNumber(count);
                input.setUploadID(multipart_upload_id);
//                input.setXQSEncryptionCustomerKey(objectKey + count);
//            input.setXQSEncryptionCustomerAlgorithm("AES256");
//            input.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");
//            input.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");

                // Create request to upload a part.
                bucket.uploadMultipart(objectKey, input);

                count++;
            }
            fis.close();
            //Delete last char ',' and add ']}' to complete json string.
            String uploadJson = getCompleteMultipartUploadContent(count, 0);
            System.out.println("uploadJson = " + uploadJson);

            // Step 3: Complete.
            // Write code here that turns the phrase above into concrete actions
            Bucket.CompleteMultipartUploadInput completeMultipartUploadInput = new Bucket.CompleteMultipartUploadInput(multipart_upload_id, count, 0);
            //You can set the Md5 info to the object.
            completeMultipartUploadInput.setETag("object-MD5");
//            completeMultipartUploadInput.setUploadID(multipart_upload_id);
//            completeMultipartUploadInput.setBodyInput(uploadJson);
            bucket.completeMultipartUpload(objectKey, completeMultipartUploadInput);
        } catch (IOException e) {
            e.printStackTrace();
        }

//        List<File> files = new ArrayList<>();
//        for (int i = 0; i < count; i++) {
//            files.add(new File("/Users/chengww/Downloads/" + objectKey + i));
//        }
//        multipartUpload(bucket, files, objectKey);
    }

    /**
     * If the file's size out of the size you set(partSize),
     * the file will be uploaded in multi parts. <br>
     * Else it will be uploaded normally(put object).
     *
     * @param partSize the length of every part
     * @param file     the complete file you will upload.
     */
    private void autoUpdate(File file, long partSize) {

    }

    private void multipartUpload(Bucket bucket, List<File> files, String objectKey) throws
            QSException {
        if (files == null || files.size() < 1)
            throw new QSException("Files' counts can not be less than one!!");

        String multipart_upload_id = "";

        Bucket.InitiateMultipartUploadInput inputInit = new Bucket.InitiateMultipartUploadInput();
        /**
         * You can encryption here like the codes below when upload.<br>
         * <br>
         * <code>//Encryption algorithm of the object</code><br>
         * <code>inputInit.setXQSEncryptionCustomerAlgorithm("AES256");</code><br>
         * <code>//Encryption key of the object<br></code>
         * <code>inputInit.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");</code><br>
         * <code><//MD5sum of encryption key</code><br>
         * <code>inputInit.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");</code><br>
         *
         * Get more information:
         * <a href='https://docs.qingcloud.com/qingstor/api/common/encryption.html#object-storage-encryption-headers'>
         *     https://docs.qingcloud.com/qingstor/api/common/encryption.html#object-storage-encryption-headers</a>
         */
        InitiateMultipartUploadOutput initOutput = bucket.initiateMultipartUpload(objectKey, inputInit);
        multipart_upload_id = initOutput.getUploadID();
        System.out.println("-multipart_upload_id----" + initOutput.getUploadID());

        for (int i = 0; i < files.size(); i++) {
            Bucket.UploadMultipartInput input = new Bucket.UploadMultipartInput();
            input.setBodyInputFilePart(files.get(i));
            input.setFileOffset(0L);
            input.setContentLength(files.get(i).length());
            input.setPartNumber(i);
            input.setUploadID(multipart_upload_id);

//            input.setXQSEncryptionCustomerKey(objectKey + i);
//            input.setXQSEncryptionCustomerAlgorithm("AES256");
//            input.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");
//            input.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");

            UploadMultipartOutput bm = bucket.uploadMultipart(objectKey, input);
            System.out.println("-UploadMultipartOutput----" + bm.getMessage());
        }

        StringBuilder uploadJson = new StringBuilder("{\"object_parts\":[");
        for (int i = 0; i < files.size(); i++) {
            uploadJson.append("{\"part_number\":").append(i).append("}");
            if (i < files.size() - 1) uploadJson.append(",");
            else uploadJson.append("]}");
        }
        // Write code here that turns the phrase above into concrete actions
        Bucket.CompleteMultipartUploadInput completeMultipartUploadInput = new Bucket.CompleteMultipartUploadInput();
        completeMultipartUploadInput.setUploadID(multipart_upload_id);
        completeMultipartUploadInput.setBodyInput(uploadJson.toString());
        System.out.println("uploadJson = " + uploadJson);
        bucket.completeMultipartUpload(objectKey, completeMultipartUploadInput);
    }

    /**
     * You can get the json content to complete multipart uploading. <br>
     *
     * @param partsCount count of all the uploaded parts
     * @param startIndex start of part number's index
     * @return content to complete multipart uploading
     */
    private String getCompleteMultipartUploadContent(int partsCount, int startIndex) {
        if (partsCount < 1 || startIndex < 0) return null;

        StringBuilder uploadJson = new StringBuilder("{\"object_parts\":[");
        for (int i = 0; i < partsCount; i++) {
            uploadJson.append("{\"part_number\":").append(startIndex++).append("}");
            if (i < partsCount - 1) uploadJson.append(",");
            else uploadJson.append("]}");
        }

        return uploadJson.toString();
    }

    boolean isCancelled = false;

    /*
     *
     *
     * MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=
     * 77+977+977+9Dicc77+977+977+9BO+/vTI577+977+9DQ== iZOTDiccmYWzBNgyOdDHDQ==
     * aVpPVERpY2NtWVd6Qk5neU9kREhEUT09 12345678123456781234567812345678
     */
    public void qcstorPutUploadObjectMd5(Bucket bucket) throws Exception {

//        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
//        evn.setLog_level(QSConstant.LOGGER_INFO);
//        Bucket bucket = new Bucket(evn, sh1a, "sh-test1");

        try {

            long time = System.currentTimeMillis();

            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();

//            putObjectInput.setXQSEncryptionCustomerAlgorithm("AES256");
//            putObjectInput.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");
//            putObjectInput.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");
            putObjectInput.setBodyInputFile(new File("/Users/chengww/Downloads/紧急审讯室.kinkyu.torishirabeshitsu.s02e04.chi_jap.hdtvrip.1280x720-zhuixinfan.mp4"));


            RequestHandler requestHandler = bucket.putObjectAsyncRequest("紧急审讯室.kinkyu.torishirabeshitsu.s02e04.chi_jap.hdtvrip.1280x720-zhuixinfan.mp4", putObjectInput, new ResponseCallBack<PutObjectOutput>() {
                @Override
                public void onAPIResponse(PutObjectOutput output) throws QSException {
                    System.out.println("out-msg = " + output.getMessage());
                    System.out.println("out-code = " + output.getStatueCode());
                }
            });

            requestHandler.setProgressListener(new BodyProgressListener() {
                @Override
                public void onProgress(long len, long size) {
                    System.out.println("progress = " + (len * 100 / size) + " %");
                }
            });

            requestHandler.setCancellationHandler(new CancellationHandler() {
                @Override
                public boolean isCancelled() {
                    return isCancelled;
                }
            });

            requestHandler.sendAsync();

//            new Thread(new Runnable() {
//                @Override
//                public void run() {
//                    try {
//                        Thread.sleep(2000);
//                        isCancelled = true;
//                    } catch (InterruptedException e) {
//                        e.printStackTrace();
//                    }
//                }
//            }).start();


//            Bucket.GetObjectInput input = new Bucket.GetObjectInput();
//            String fileName = "喔喔(123).csv";
//            String urlName = URLEncoder.encode(fileName, "utf-8");
//            input.setResponseContentDisposition("attachment; filename=" + urlName);
//            RequestHandler handle = bucket.GetObjectBySignatureUrlRequest("checked.png", input, Integer.MAX_VALUE);
//            String tempUrl = handle.getExpiresRequestUrl();
//            System.out.println(tempUrl);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     * MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=
     * 77+977+977+9Dicc77+977+977+9BO+/vTI577+977+9DQ== iZOTDiccmYWzBNgyOdDHDQ==
     * aVpPVERpY2NtWVd6Qk5neU9kREhEUT09 12345678123456781234567812345678
     */
    public void qcstorGetDownObjectMulti() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "chengww-test");
        OutputStream outa = null;

        //每一分段的大小
        long partSize = 5000000L;

        int index = 0;
        try {
            while (true) {
                Bucket.GetObjectInput putObjectInput = new Bucket.GetObjectInput();

                long start = partSize * index;

                long end = ((index + 1) * partSize - 1);
                putObjectInput.setRange("bytes=" + start + "-" + end);

                Bucket.GetObjectOutput output = bucket.getObject("testMultiMd5MM.zip", putObjectInput);

                int iLength = 0;
                File ff = new File("/Users/chengww/Downloads/testMultiDownload.zip");

                if (output != null && output.getBodyInputStream() != null && output.getStatueCode() == 206) {

                    outa = new FileOutputStream(ff, true);

                    int bytesRead = 0;

                    byte[] buffer = new byte[1024];

                    while ((bytesRead = output.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                        outa.write(buffer, 0, bytesRead);
                        iLength += bytesRead;
                    }
                    outa.flush();

                    output.getBodyInputStream().close();

                }

                if (iLength < partSize) {
                    System.out.println("ff.length = " + ff.length());
                    break;
                }

                index++;
            }
        } catch (Exception ex) {
            System.out.println(ex.getMessage());

        } finally {
            if (null != outa) {
                try {
                    outa.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }

        System.out.println("======================下载完成");

    }

    /*
     *
     *
     * MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=
     * 77+977+977+9Dicc77+977+977+9BO+/vTI577+977+9DQ== iZOTDiccmYWzBNgyOdDHDQ==
     * aVpPVERpY2NtWVd6Qk5neU9kREhEUT09 12345678123456781234567812345678
     */
    public void qcstorPutDownObjectMd5() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn, sh1a, "sh-test2");

        try {

            Bucket.GetObjectInput putObjectInput = new Bucket.GetObjectInput();

            putObjectInput.setXQSEncryptionCustomerAlgorithm("AES256");
            putObjectInput.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");
            putObjectInput.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");

            Bucket.GetObjectOutput output = bucket.getObject("fsdfsadf", putObjectInput);
            // Bucket.GetObjectOutput output = bucket.getObject("test/test-ac",
            // input);

            OutputStream outa = null;

            int iLength = 0;

            try {
                output = bucket.getObject("fsdfsadf", putObjectInput);

                if (output != null && output.getBodyInputStream() != null) {

                    File ff = new File("/Users/karooli/Downloads/eee_SignatureUrlAsync22.pdf");

                    outa = new FileOutputStream(ff);

                    int bytesRead = 0;

                    // byte[] buffer = new
                    // byte[output.getBodyInputStream().available()];
                    byte[] buffer = new byte[1024];

                    while ((bytesRead = output.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
                        outa.write(buffer, 0, bytesRead);
                    }

                }
            } catch (Exception ex) {
                System.out.println(ex.getMessage());

            } finally {
                if (null != outa) {
                    try {
                        outa.close();
                    } catch (IOException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }

                if (null != output) {
                    try {
                        output.getBodyInputStream().close();
                    } catch (IOException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
            }

            System.out.println("======================下载完成");

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void qcstorGetbucketUploadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        QingStor stor = new QingStor(evn, sh1a);

        try {
            QingStor.ListBucketsOutput output = stor.listBuckets(null);

            System.out.println(output.getStatueCode() + "---");

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void md5test() throws Exception {

        String password = "MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg";
        String content = "helloworld";
        try {
            // "AES"：请求的密钥算法的标准名称
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            // 256：密钥生成参数；securerandom：密钥生成器的随机源
            SecureRandom securerandom = new SecureRandom(tohash256Deal(password));
            kgen.init(256, securerandom);
            // 生成秘密（对称）密钥
            SecretKey secretKey = kgen.generateKey();
            // 返回基本编码格式的密钥
            byte[] enCodeFormat = secretKey.getEncoded();
            // 根据给定的字节数组构造一个密钥。enCodeFormat：密钥内容；"AES"：与给定的密钥内容相关联的密钥算法的名称
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            // 将提供程序添加到下一个可用位置
            // Security.addProvider(new BouncyCastleProvider());
            // 创建一个实现指定转换的 Cipher对象，该转换由指定的提供程序提供。
            // "AES/ECB/PKCS7Padding"：转换的名称；"BC"：提供程序的名称
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");

            cipher.init(Cipher.ENCRYPT_MODE, key);
            byte[] byteContent = content.getBytes("utf-8");
            byte[] cryptograph = cipher.doFinal(byteContent);
            System.out.println(Base64.encode(cryptograph));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*
     *
     *
     *
     */
    public void md5testaaa() throws Exception {

        String password = "12345678123456781234567812345678";
        try {
            MessageDigest instance = null;
            try {
                instance = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {
                throw new QSException("MessageDigest MD5 error", e);
            }

            // ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ
            // ODk5MzkzMEUyNzFDOTk4NUIzMDREODMyMzlEMEM3MEQ
            String contentMD5 = new String(instance.digest(password.toString().getBytes()));
            String contentMD52 = new String(Base64.encode(instance.digest(password.toString().getBytes())));

            System.out.println(Base64.encode(password.getBytes()));
            System.out.println(Base64.encode(contentMD5.getBytes()));
            System.out.println(contentMD52);
            System.out.println(Base64.encode(contentMD52.getBytes()));
            String md532 = MD5(password);
            System.out.println(md532);
            System.out.println(Base64.encode(md532.getBytes()));
            System.out.println(new String(Base64.decode("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=")));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private static String MD5(String sourceStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sourceStr.getBytes());
            byte b[] = md.digest();
            int i;
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0)
                    i += 256;
                if (i < 16)
                    buf.append("0");
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString();
            System.out.println("MD5(" + sourceStr + ",32) = " + result);
            System.out.println("MD5(" + sourceStr + ",16) = " + buf.toString().substring(8, 24));
        } catch (NoSuchAlgorithmException e) {
            System.out.println(e);
        }
        return result;
    }

    private static byte[] tohash256Deal(String datastr) {
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-256");
            digester.update(datastr.getBytes());
            byte[] hex = digester.digest();
            return hex;
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void 跨区存储(Bucket bucket) {
        Bucket.PutObjectInput input = new Bucket.PutObjectInput();
        input.setXQSCopySource("/bj3a-test-bucket/test.jpg");

        PutObjectOutput copyOutput = null;
        try {
            copyOutput = bucket.putObject("objectName-test-copy.jpg", input);
            System.out.println(copyOutput.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }
    }
}
