/****
 +-------------------------------------------------------------------------
 | Copyright (C) 2017 Yunify, Inc.
 +-------------------------------------------------------------------------
 | Licensed under the Apache License, Version 2.0 (the "License");
 | you may not use this work except in compliance with the License.
 | You may obtain a copy of the License in the LICENSE file, or at:
 |
 | http://www.apache.org/licenses/LICENSE-2.0
 |
 | Unless required by applicable law or agreed to in writing, software
 | distributed under the License is distributed on an "AS IS" BASIS,
 | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 | See the License for the specific language governing permissions and
 | limitations under the License.
 +-------------------------------------------------------------------------
*****/
package com.test;

import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Bucket.CompleteMultipartUploadOutput;
import com.qingstor.sdk.service.Bucket.DeleteBucketOutput;
import com.qingstor.sdk.service.Bucket.DeleteMultipleObjectsOutput;
import com.qingstor.sdk.service.Bucket.GetObjectOutput;
import com.qingstor.sdk.service.Bucket.HeadObjectOutput;
import com.qingstor.sdk.service.Bucket.InitiateMultipartUploadOutput;
import com.qingstor.sdk.service.Bucket.ListMultipartOutput;
import com.qingstor.sdk.service.Bucket.ListMultipartUploadsInput;
import com.qingstor.sdk.service.Bucket.ListMultipartUploadsOutput;
import com.qingstor.sdk.service.Bucket.PutObjectOutput;
import com.qingstor.sdk.service.Bucket.UploadMultipartOutput;
import com.qingstor.sdk.service.QingStor.ListBucketsInput;
import com.qingstor.sdk.service.QingStor.ListBucketsOutput;
import com.qingstor.sdk.service.QingStor;
import com.qingstor.sdk.service.Types;
import com.qingstor.sdk.service.Types.BucketModel;
import com.qingstor.sdk.service.Types.KeyModel;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSServerSignatureUtil;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class QingStorEncryptionUnitTest {

	public static String QC_STOR_CONTENT_TEXT = "text/plain; charset=utf-8";
	public static String QC_STOR_CONTENT_JSON = "application/vnd.android.package-archive";
	public static String QC_STOR_CONTENT_MULTI = "multipart/form-data;";
	public static String config = "/Users/karooli/Documents/qingcloud_cli/";
	public static String testZone = "sh1a";
	private boolean executeFlag = false;

	public static void main(String[] args){
		try {
			qcstorPutUploadObjectEncryption();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/*
	 *
	 *
	 * MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=
	 * 77+977+977+9Dicc77+977+977+9BO+/vTI577+977+9DQ== iZOTDiccmYWzBNgyOdDHDQ==
	 * aVpPVERpY2NtWVd6Qk5neU9kREhEUT09 12345678123456781234567812345678
	 */
	public static void qcstorPutUploadObjectEncryption() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "sh-test1");

		try {

			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();

			String encryption_algorithm = "AES256";
			String encryption_key = "MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=";
			String encryption_key_md5 = "ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=";
			putObjectInput.setXQSEncryptionCustomerAlgorithm(encryption_algorithm);
			putObjectInput.setXQSEncryptionCustomerKey(encryption_key);
			putObjectInput.setXQSEncryptionCustomerKeyMD5(encryption_key_md5);
			
			String bucketName = "sh-test1";
			String objectName = "fsdfsadftest";
			
		
			putObjectInput.setBodyInputFile(new File("/tmp/test.txt"));

			Bucket.PutObjectOutput output = bucket.putObject(objectName, putObjectInput);
			
			System.out.println(output.getMessage());
			
			
			// Write code here that turns the phrase above into concrete actions
			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			input.setXQSCopySource("/" + bucketName + "/" + objectName);
			input.setXQSCopySourceEncryptionCustomerAlgorithm(encryption_algorithm);
			input.setXQSCopySourceEncryptionCustomerKey(encryption_key);
			input.setXQSCopySourceEncryptionCustomerKeyMD5(encryption_key_md5);
			Bucket.PutObjectOutput copyObjectOutput = bucket.putObject("copy" + objectName, input);
			
			System.out.println(copyObjectOutput.getMessage());
			
			
			Bucket.PutObjectInput inputMove = new Bucket.PutObjectInput();
			inputMove.setXQSMoveSource("/" + bucketName + "/" + objectName);
			
			Bucket.PutObjectOutput moveOutput = bucket.putObject(objectName + "move", inputMove);
			
			System.out.println(moveOutput.getMessage());
			// Bucket.GetObjectOutput output = bucket.getObject("小米/chart.jpg",
			// input);

			System.out.println(output.getStatueCode());

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorGetbucketUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		QingStor stor = new QingStor(evn,testZone);

		try {
			QingStor.ListBucketsOutput output = stor.listBuckets(null);

			System.out.println(output.getStatueCode() + "---");

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

}
