/****
 +-------------------------------------------------------------------------
 | Copyright (C) 2017 Yunify, Inc.
 +-------------------------------------------------------------------------
 | Licensed under the Apache License, Version 2.0 (the "License");
 | you may not use this work except in compliance with the License.
 | You may obtain a copy of the License in the LICENSE file, or at:
 |
 | http://www.apache.org/licenses/LICENSE-2.0
 |
 | Unless required by applicable law or agreed to in writing, software
 | distributed under the License is distributed on an "AS IS" BASIS,
 | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 | See the License for the specific language governing permissions and
 | limitations under the License.
 +-------------------------------------------------------------------------
*****/
package com.test;

import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Bucket.GetObjectOutput;
import com.qingstor.sdk.service.Bucket.HeadObjectOutput;
import com.qingstor.sdk.service.Bucket.PutObjectOutput;
import com.qingstor.sdk.service.QingStor;
import com.qingstor.sdk.service.Types;
import com.qingstor.sdk.service.Types.KeyModel;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;


import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class QingStorMultiThreadUnitTest {

    public static String QC_STOR_CONTENT_TEXT = "text/plain; charset=utf-8";
    public static String QC_STOR_CONTENT_JSON = "application/vnd.android.package-archive";
    public static String QC_STOR_CONTENT_MULTI = "multipart/form-data;";
    public static String config = "/Users/karooli/Documents/qingcloud_cli/";
    private boolean executeFlag = false;
    public static String testZone = "sh1a";

    
    public void qcstorHeadObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn,testZone, "sh-test2");
        Bucket.HeadObjectInput input = new Bucket.HeadObjectInput();
        Bucket.HeadObjectOutput o = bucket.headObject("qingcloud-android-app.apk", input);
        System.out.println(o.getMessage());

    }

    boolean bEexcute = false;

    
    /*
            *
            *
            *
            */
    public void testPoolPutObject() throws Exception {


        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);

        for (int i = 0; i < 100; i++) {
            Bucket bucket = new Bucket(evn,testZone, "sh-test2");
            Bucket.HeadObjectInput input = new Bucket.HeadObjectInput();
            Bucket.HeadObjectOutput o = bucket.headObject("qingcloud-android-app.apk", input);
            System.out.println(o.getMessage());

            Bucket bucket2 = new Bucket(evn,testZone, "test01");
            Bucket.PutObjectInput input2 = new Bucket.PutObjectInput();
            input2.setContentType(QC_STOR_CONTENT_TEXT);
            File f = new File("/tmp/config.yaml");
            input2.setContentLength(f.length());
            input2.setBodyInputFile(new File("/tmp/config.yaml"));

            Bucket.PutObjectOutput ooo = bucket2.putObject("ttt.txt", input2);
            System.out.println(ooo.getMessage());

            Bucket bucket3 = new Bucket(evn,testZone, "test03");
            Bucket.GetBucketStatisticsOutput os = bucket3.getStatistics();
            System.out.println(os.getMessage());
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }
    }

    class PutObjectRunable implements Runnable {
    	
    	private int threadIndex = 0;
    	
    	public PutObjectRunable(int threadIndex){
    		this.threadIndex = threadIndex;
    	}

        @Override
        public void run() {
            try {

            	EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
            	evn.setProtocol("http");
                //evn.setLog_level(QSConstant.LOGGER_INFO);
                
                QingStor storService = new QingStor(evn,testZone);
                
               
                QingStorMultiThreadUnitTest test = new QingStorMultiThreadUnitTest();
                /*for(int i = 0 ; i< 10 ; i++){
                	Bucket bucket = storService.getBucket("sh-test2", "sh1a");
                	test.objectTest(bucket,i);
                	
                }
                Bucket bucket = storService.getBucket("sh-test2", "sh1a");
                test.qsGetSignatureUrlObject(bucket,(2+1)*(this.threadIndex+1));*/
                
        		evn.setProtocol("http");
        		evn.setPort("80");
        		//evn.setLog_level(QSConstant.LOGGER_INFO);
        		QSConstant.HTTPCLIENT_CONNECTION_TIME_OUT = 20;
        		QSConstant.HTTPCLIENT_READ_TIME_OUT = 20;
        		Bucket bucket = new Bucket(evn, testZone, "sh-test2");
        		String objectName1 = "测试\"01+{*~}0";
        		String objectName2 = "WebStorm-2016.2.3.dmg";
        		if(this.threadIndex % 2 == 0){
        			test.qcstorGetDownObjectMulti(objectName1,bucket,this.threadIndex,0);
        			test.qcstorGetDownObjectMulti(objectName2,bucket,this.threadIndex,0);
        		}else{
        			test.qcstorGetDownObjectMulti(objectName2,bucket,this.threadIndex,0);
        			test.qcstorGetDownObjectMulti(objectName1,bucket,this.threadIndex,0);
        			
        		}
                
                //test.deleteMultil(bucket);
                
                
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    
    int retryCount = 0;
    int fileSuffix = 0;
    /*
	 *
	 *
	 * MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=
	 * 77+977+977+9Dicc77+977+977+9BO+/vTI577+977+9DQ== iZOTDiccmYWzBNgyOdDHDQ==
	 * aVpPVERpY2NtWVd6Qk5neU9kREhEUT09 12345678123456781234567812345678
	 */
	public void qcstorGetDownObjectMulti(String objectName,Bucket bucket,int suffix, int index) throws Exception {

		this.fileSuffix = suffix;
		
		OutputStream outa = null;

		int size = 65536;
		
		Bucket.GetObjectOutput output = null;
		try {
			while (true) {
				Bucket.GetObjectInput putObjectInput = new Bucket.GetObjectInput();

				long start = size * index;
				
				long end = ((index + 1) * size -1);
				putObjectInput.setRange("bytes="+ start + "-" + end);
				
				//Bucket.GetObjectOutput output = bucket.getObject(objectTestName[0], putObjectInput);
				output = bucket.getObject(objectName, putObjectInput);
				// Bucket.GetObjectOutput output =
				// bucket.getObject("test/test-ac",
				// input);

				int iLength = 0;
				
				if(output.getStatueCode() != 206){
					System.err.println("StatueCode----:"+output.getStatueCode());	
				}
				System.out.println(suffix+"====="+objectName+"===下载中===="+index);
				
				if (output != null && output.getBodyInputStream() != null) {

					File ff = new File("/tmp/testMulti"+suffix);

					outa = new FileOutputStream(ff, true);

					int bytesRead = 0;

					// byte[] buffer = new
					// byte[output.getBodyInputStream().available()];
					byte[] buffer = new byte[1024];

					while ((bytesRead = output.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
						outa.write(buffer, 0, bytesRead);
						iLength += bytesRead;
					}
					
					output.getBodyInputStream().close();
					outa.close();
				}
				
				if (iLength < size) {
					break;
				}
				index++;
			}
		} catch (Exception ex) {
			if(output != null && output.getBodyInputStream() !=null){
				output.getBodyInputStream().close();
			}
			if (null != outa) {
				try {
					outa.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			ex.printStackTrace();
			System.err.println(suffix+"===="+objectName+"====重试处理===="+index);
			if(this.retryCount < 3){
				this.retryCount++;
				this.qcstorGetDownObjectMulti(objectName,bucket,this.fileSuffix,index);
			}
			
			System.out.println(ex.getMessage());

		} finally {
			if (null != outa) {
				try {
					outa.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}

		}

		System.out.println(suffix+"======================下载完成");

	}
    
    public void qsGetSignatureUrlObject(Bucket bucket,int index) throws QSException {
		GetObjectOutput out = bucket.GetObjectBySignatureUrl("https://movies.pek3a.qingstor.com/sherlock-s04e01.mp4");
		long begin = System.currentTimeMillis();
		try {
			File ff = new File("/tmp/bigdownload.mp4"+index);
			OutputStream outStream = null;
			try {
				outStream = new FileOutputStream(ff);
				int bytesRead = 0;
				byte[] buffer = new byte[1024];
				while ((bytesRead = out.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
					outStream.write(buffer, 0, bytesRead);
				}
				outStream.close();
				out.getBodyInputStream().close();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}

			long dd = begin - System.currentTimeMillis();
			// System.out.println("end:" + (System.currentTimeMillis()));
			System.err.println("end-----------------" + ":" + (dd));
			Thread.sleep(200);

			// out.getBodyInputStream().close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
	}

    
    /*
            *
            *
            *
            */
    public void getMultiThread() throws Exception {
        for (int i = 0; i < 100; i++) {
            PutObjectRunable tt = new PutObjectRunable(i);
            new Thread(tt).start();
        }
        
    }


    
    /*
            *
            *
            *
            */
    public void qcstorStatisObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        Bucket bucket = new Bucket(evn,testZone, "test909");
        Bucket.PutObjectInput input = new Bucket.PutObjectInput();
        Bucket.PutObjectOutput copyOutput = bucket.putObject("test/", input);
        //Bucket.GetBucketStatisticsOutput o = bucket.getStatistics();
        System.out.println(copyOutput.getMessage());

    }


    static String[] objectTestName = {"testddd/idi", "测试\"01+{*~}", ",./;'[]\\-=+",
            "찦차를 타고 온 펲시맨과 쑛다리 똠방각하+", "xia/屏幕快照 2017-05-05 上午10.54.02.png",
            "\uD83D\uDC7E \uD83D\uDE47 \uD83D\uDC81 /test端口"};

    public void testListBucket() throws QSException{
    	EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        //evn.setLog_level(QSConstant.LOGGER_INFO);
        QingStor storService = new QingStor(evn,testZone);
        QingStor.ListBucketsInput input = new QingStor.ListBucketsInput();
        input.setLocation("sh1a");
        QingStor.ListBucketsOutput out = storService.listBuckets(input);
        System.out.println(out.getBuckets().size());
    }
    
    public static void main(String[] args) throws Exception {
    	QingStorMultiThreadUnitTest test = new QingStorMultiThreadUnitTest();
    	test.getMultiThread();
    }
    
    
    public void deleteMultil(Bucket bucket) throws QSException, Exception{
    	Bucket.ListObjectsInput input = new Bucket.ListObjectsInput();
        Bucket.ListObjectsOutput listObjectsOutput = new Bucket.ListObjectsOutput();
        input.setLimit(10);
        try {
            listObjectsOutput = bucket.listObjects(input);
        }catch (Exception ex){
            System.out.println(ex.getMessage());
        }

        Bucket.DeleteMultipleObjectsInput deleteInput = new Bucket.DeleteMultipleObjectsInput();

        List<KeyModel> lstKey =  new ArrayList();
        KeyModel m ;
        for(int i=0; i< listObjectsOutput.getKeys().size();i++){
            Types.KeyModel key = listObjectsOutput.getKeys().get(i);
            //deleteKey newKey = new deleteKey();
            System.out.println(key.getKey());
            m = new KeyModel();
            m.setKey(key.getKey());
            long time = new Date().getTime()/1000 + 1000;
            RequestHandler handler = bucket.GetObjectBySignatureUrlRequest(key.getKey(),null, time);
            String url = handler.getExpiresRequestUrl();
            
            String dff = bucket.GetObjectSignatureUrl(key.getKey(), (int)time);
            String strToSignature = handler.getStringToSignature();
            //serverAuthorization  server端处理返回信息
            String serverAuthorization = QSSignatureUtil.generateSignature(
            		"lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv", strToSignature);
            
            //将计算的签名设置到request中
            handler.setSignature("HMZADZVBMNECJLSNKYRO",serverAuthorization+"1111111");
            String url2 = handler.getExpiresRequestUrl();
            
            System.out.println(dff);
            System.out.println(url);
            System.out.println(url2);
            GetObjectOutput out = bucket.GetObjectBySignatureUrl(url);
            System.out.println(out.getStatueCode()+":--aaa---"+out.getMessage());
            if( out.getBodyInputStream() != null){
                File ff = new File("/tmp/get_sign_objectfffff"+i+".txt");
                OutputStream outa = new FileOutputStream(ff);
                int bytesRead = 0;
                byte[] buffer = new byte[1024];
                while ((bytesRead = out.getBodyInputStream().read(buffer,0,1024)) != -1){
                	outa.write(buffer,0,bytesRead);
                    //iLength += bytesRead;
                }
                outa.close();
                out.getBodyInputStream().close();
            }
            lstKey.add(m);
            //newKey.key = key.getKey();
            //newInput.objects.add(newKey);
        }
        
        
        
        deleteInput.setObjects(lstKey);
        //String objectToJson = JSON.toJSONString(newInput);

        //deleteInput.setBodyInput(objectToJson);
        //deleteInput.setObjects(listObjectsOutput.getKeys());

        try {
            Bucket.DeleteMultipleObjectsOutput output = bucket.deleteMultipleObjects(deleteInput);
            System.out.println("Success:"+output.getMessage());
            System.out.println(output.getDeleted().size());
        }catch (Exception ex){
            System.out.println(ex.getMessage());
        }
    }
    
    public void objectTest(Bucket bucket ,int index) throws Exception{
    	
    	for (String name : objectTestName) {
            this.qsPutObjectByName(name, bucket,index);
            /*this.qsPutObjectByNameSetSignature(name+"signature", bucket);
            this.qsDeleteObjectByName(name, bucket);
            this.qsPutObjectByName(name, bucket,index);
            this.qsMoveObject(name, bucket);*/
            //this.qsDeleteObjectByName(name + "toMove", bucket);
        }
    }

    public void qsPutObjectByName(String objectName, Bucket bucket, int index) throws Exception {

        try {
        	HeadObjectOutput hhd = bucket.headObject(objectName, null);
        	System.out.println(objectName+"---HeadObjectOutput---" + hhd.getMessage());
            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
            File fa = null;
            if(index % 2 == 0) {
            	fa = new File("/Users/karooli/Downloads/Web网盘需求文档v1.docx");
            	putObjectInput.setContentType("video/mp4; charset=utf8");
            }  else {
            	fa = new File("/Users/karooli/Downloads/qingcloud-vi-book-前端.pdf");
            	putObjectInput.setContentType("application/pdf");
            }
            putObjectInput.setBodyInputFile(fa);
            
            putObjectInput.setContentLength(fa.length());
            
            //bucket.putObject(objectName, putObjectInput);
            
            OutputModel output = bucket.putObject(objectName+index, putObjectInput);
            
            System.out.println(objectName+"---getMessage---" + output.getMessage());
            System.out.println(objectName+"--getRequestId--" + output.getRequestId());
            System.out.println(objectName+"--getCode----" + output.getCode());
            System.out.println(objectName+"--getStatueCode----" + output.getStatueCode());

        } catch (QSException e) {
            e.printStackTrace();
        }

    }
    
    public void qsPutObjectByNameSetSignature(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
            File fa = new File("/Users/karooli/qingcloud/app/Qingstor-SDK/app/src/test/java/com/qingstor/sdk/QingStorUnitTest.java");
            putObjectInput.setBodyInputFile(fa);
            putObjectInput.setContentType("video/mp4; charset=utf8");
            putObjectInput.setContentLength(fa.length());
            
            //bucket.putObject(objectName, putObjectInput);
            
            // 获取请求对象，正常 bucket.putObject(objectName, putObjectInput); 就完成操作
            RequestHandler reqHandler = bucket.putObjectRequest(objectName, putObjectInput);
            
            // strToSignature 将这个发送到用户的server端
            String strToSignature = reqHandler.getStringToSignature();
           
            //serverAuthorization  server端处理返回信息
            String serverAuthorization = QSSignatureUtil.generateSignature(
            		"lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv", strToSignature);
            
            //将计算的签名设置到request中
            reqHandler.setSignature("HMZADZVBMNECJLSNKYRO",serverAuthorization);
            
            OutputModel output = (PutObjectOutput) reqHandler.send();
            
            System.out.println(objectName+"---getMessage---" + output.getMessage());
            System.out.println(objectName+"--getRequestId--" + output.getRequestId());
            System.out.println(objectName+"--getCode----" + output.getCode());
            System.out.println(objectName+"--getStatueCode----" + output.getStatueCode());

        } catch (QSException e) {
            e.printStackTrace();
        }

    }

    public void qsDeleteObjectByName(String objectName, Bucket bucket) throws Exception {

        try {

            Bucket.DeleteObjectOutput out = bucket.deleteObject(objectName);
            System.out.println("d--d" + out.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }


    }

    public void qsMoveObject(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            input.setXQSMoveSource("/sh-test/" + objectName);

            Bucket.PutObjectOutput copyOutput = bucket.putObject(objectName + "toMove", input);

            System.out.println(objectName+"qsMoveObject" + copyOutput.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }

    }


    public void qsDeleteObjectaaa(String objectName, Bucket bucket) throws Exception {

        try {
            Bucket.DeleteObjectOutput out = bucket.deleteObject(objectName);

            System.out.println("d--d" + out.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }


    }


    
    /*
            *
            *
            *
            */
    public void qcCopyObject() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        evn.setLog_level(QSConstant.LOGGER_INFO);
        QingStor storService = new QingStor(evn,testZone);
        try {
            Bucket bucket = storService.getBucket("test-ac", "pek3a");

            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            input.setXQSCopySource("/test-ac/test-acaaf");

            Bucket.PutObjectOutput copyOutput = bucket.putObject("test/test-ac", input);

			/*Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            File f = new File("/tmp/oobelib.log");
			input.setBodyInputFile(f);
			input.setContentType("text/plain");
			input.setContentLength((int) f.length());
			bucket.putObjectAsync("test-acaaf", input, new ResponseCallBack<Bucket.PutObjectOutput>() {
				@Override
				public void onAPIResponse(Bucket.PutObjectOutput output) throws QSException {
					System.out.println("d--d"+output.getMessage());
				}
			});*/
            //Bucket.PutObjectOutput putObjectOutput = bucket.putObject("private-img", input);
            System.out.println(copyOutput.getMessage());
        } catch (QSException e) {
            e.printStackTrace();
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }

    }

    /*
            *
            *
            *
            */
    public void qcPutObjecteee() throws Exception {

        EvnContext evn = new EvnContext("CYQCHVBDUSZSBBBKEXDX", "tRlGgRG7Hp7S93byC22XOIINWhytJcaYEgTEE3FX");
        QingStor storService = new QingStor(evn,testZone);
        try {
            Bucket bucket = storService.getBucket("private-img", "pek3a");
            Bucket.PutBucketOutput putBucketOutput = bucket.put();

            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            File f = new File("/tmp/oobelib.log");
            input.setBodyInputFile(f);
            input.setContentType("text/plain");
            input.setContentLength(f.length());
            bucket.putObjectAsync("private-test", input, new ResponseCallBack<Bucket.PutObjectOutput>() {
                @Override
                public void onAPIResponse(Bucket.PutObjectOutput putObjectOutput) throws QSException {
                    System.out.println(putObjectOutput.getMessage());
                }
            });
        } catch (QSException e) {
            e.printStackTrace();
        }
        while (!bEexcute) {
            Thread.sleep(10000);
        }

    }

    public static void traverseFolder(Bucket bucket, String path) {

        try {

            File file = new File(path);
            if (file.exists()) {
                File[] files = file.listFiles();
                if (files.length == 0) {
                    return;
                } else {
                    for (File file2 : files) {
                        if (file2.isDirectory()) {
                            traverseFolder(bucket, file2.getAbsolutePath());
                        } else {
                            //System.out.println("文件:" + file2.getAbsolutePath());
                            String fileName = file2.getName();
                            Bucket.PutObjectInput ii = new Bucket.PutObjectInput();
                            ii.setBodyInputFile(file2);
                            bucket.putObjectAsync(fileName, ii, new ResponseCallBack<Bucket.PutObjectOutput>() {
                                @Override
                                public void onAPIResponse(Bucket.PutObjectOutput output) throws QSException {
                                    System.out.println(output.getMessage() + "----" + output.getCode());
                                }
                            });
                        }
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    
    /*
            *
            *
            *
            */
    public void getAcl() throws Exception {

        EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
        Bucket bucket = new Bucket(evn,testZone, "sh-test2");
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
            @Override
            public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
                System.out.println(output.getACL());
            }
        });
        int id = 0;
        while (!executeFlag) {
            Thread.sleep(15000);
        }
    }



}
