/****
 +-------------------------------------------------------------------------
 | Copyright (C) 2017 Yunify, Inc.
 +-------------------------------------------------------------------------
 | Licensed under the Apache License, Version 2.0 (the "License");
 | you may not use this work except in compliance with the License.
 | You may obtain a copy of the License in the LICENSE file, or at:
 |
 | http://www.apache.org/licenses/LICENSE-2.0
 |
 | Unless required by applicable law or agreed to in writing, software
 | distributed under the License is distributed on an "AS IS" BASIS,
 | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 | See the License for the specific language governing permissions and
 | limitations under the License.
 +-------------------------------------------------------------------------
*****/
package com.test;

import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.BodyProgressListener;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Bucket.CompleteMultipartUploadOutput;
import com.qingstor.sdk.service.Bucket.DeleteBucketOutput;
import com.qingstor.sdk.service.Bucket.DeleteMultipleObjectsOutput;
import com.qingstor.sdk.service.Bucket.GetObjectInput;
import com.qingstor.sdk.service.Bucket.GetObjectOutput;
import com.qingstor.sdk.service.Bucket.HeadObjectOutput;
import com.qingstor.sdk.service.Bucket.InitiateMultipartUploadOutput;
import com.qingstor.sdk.service.Bucket.ListMultipartOutput;
import com.qingstor.sdk.service.Bucket.ListMultipartUploadsInput;
import com.qingstor.sdk.service.Bucket.ListMultipartUploadsOutput;
import com.qingstor.sdk.service.Bucket.PutObjectOutput;
import com.qingstor.sdk.service.Bucket.UploadMultipartOutput;
import com.qingstor.sdk.service.QingStor.ListBucketsInput;
import com.qingstor.sdk.service.QingStor.ListBucketsOutput;
import com.qingstor.sdk.service.QingStor;
import com.qingstor.sdk.service.Types;
import com.qingstor.sdk.service.Types.BucketModel;
import com.qingstor.sdk.service.Types.KeyModel;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSServerSignatureUtil;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class QingStorUnitTest {

	public static String QC_STOR_CONTENT_TEXT = "text/plain; charset=utf-8";
	public static String QC_STOR_CONTENT_JSON = "application/vnd.android.package-archive";
	public static String QC_STOR_CONTENT_MULTI = "multipart/form-data;";
	public static String config = "/Users/karooli/Documents/qingcloud_cli/";
	public static String testZone = "sh1a";
	private boolean executeFlag = false;

	public void qcstorHeadObject() throws Exception {
		
		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone,"test0222211");
		Bucket.HeadObjectInput input = new Bucket.HeadObjectInput();
		Bucket.HeadObjectOutput o = bucket.headObject("qingcloud-android-app.apk", input);
		System.out.println(o.getMessage());

	}

	boolean bEexcute = false;

	/*
	        *
	        *
	        *
	        */
	public void testPoolPutObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);

		for (int i = 0; i < 100; i++) {
			Bucket bucket = new Bucket(evn,testZone, "test0222211");
			Bucket.HeadObjectInput input = new Bucket.HeadObjectInput();
			Bucket.HeadObjectOutput o = bucket.headObject("qingcloud-android-app.apk", input);
			System.out.println(o.getMessage());

			Bucket bucket2 = new Bucket(evn,testZone, "test01");
			Bucket.PutObjectInput input2 = new Bucket.PutObjectInput();
			input2.setContentType(QC_STOR_CONTENT_TEXT);
			File f = new File("/tmp/config.yaml");
			input2.setContentLength(f.length());
			input2.setBodyInputFile(new File("/tmp/config.yaml"));

			Bucket.PutObjectOutput ooo = bucket2.putObject("ttt.txt", input2);
			System.out.println(ooo.getMessage());

			Bucket bucket3 = new Bucket(evn,testZone, "test03");
			Bucket.GetBucketStatisticsOutput os = bucket3.getStatistics();
			System.out.println(os.getMessage());
		}
		while (!bEexcute) {
			Thread.sleep(10000);
		}
	}

	class PutObjectRunable implements Runnable {

		@Override
		public void run() {
			try {

				EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
				// evn.setLog_level(QSConstant.LOGGER_INFO);
				
				for (int i = 0; i < 100; i++) {
					Bucket bucket2 = new Bucket(evn,testZone, "test01");
					Bucket.PutObjectInput input = new Bucket.PutObjectInput();
					input.setContentType("text/plain; charset=utf-8");
					File f = new File("/tmp/wifi-Bq5Lr5.log");
					input.setContentLength(f.length());
					input.setBodyInputFile(f);
					Bucket.PutObjectOutput out = bucket2.putObject("testPutObject", input);
					System.out.println(out.getMessage());
					
					
				}
				while (!bEexcute) {
					Thread.sleep(10000);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/*
	        *
	        *
	        *
	        */
	public void getMultiThread() throws Exception {
		for (int i = 0; i < 100; i++) {
			PutObjectRunable tt = new PutObjectRunable();
			new Thread(tt).start();
		}
		while (!bEexcute) {
			Thread.sleep(10000);
		}
	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorStatisObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "test909");
		Bucket.PutObjectInput input = new Bucket.PutObjectInput();
		Bucket.PutObjectOutput copyOutput = bucket.putObject("test/", input);
		// Bucket.GetBucketStatisticsOutput o = bucket.getStatistics();
		System.out.println(copyOutput.getMessage());

	}

	static String[] objectTestName = { "[051206019004%_.fbx_1607292891","testddd/idi", "测试\"01+{*~}", ",./;'[]\\-=+", "찦차를 타고 온 펲시맨과 쑛다리 똠방각하+",
			"xia/屏幕快照 2017-05-05 上午10.54.02.png", "\uD83D\uDC7E \uD83D\uDE47 \uD83D\uDC81 /test端口" };

	public void testListBucket() throws QSException {
		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		// evn.setLog_level(QSConstant.LOGGER_INFO);
		QingStor storService = new QingStor(evn,testZone);
		QingStor.ListBucketsInput input = new QingStor.ListBucketsInput();
		input.setLocation("sh1a");
		QingStor.ListBucketsOutput out = storService.listBuckets(input);
		System.out.println(out.getBuckets().size());
	}

	public static void main(String[] args) throws Exception {
		
		//bucket.delete();
		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		
		evn.setLog_level("debug");
		QingStorUnitTest test = new QingStorUnitTest();
		
		//test.mulitUpload(null);
		QingStor storService = new QingStor(evn, "sh1a");
		Bucket bucket = storService.getBucket("sh-test1", "sh1a");
		//test.qsPutObjectByName("testaaddd",bucket);
		//test.putObject(bucket, "tes001010t.txt");
		//test.mulitUpload(bucket);
		GetObjectInput inputd = new GetObjectInput();
		//inputd.setResponseContentDisposition("attachement");
		long fff = System.currentTimeMillis()+200000;
		String dd = bucket.GetObjectSignatureUrl("test2(单次购买)第1期/checked.png", fff);
		RequestHandler handler = bucket.GetObjectBySignatureUrlRequest("test2(单次购买)第1期/checked.png",inputd, fff);
		String url = handler.getExpiresRequestUrl();
		System.out.println(dd);
		System.out.println(url);
		//test.testUrl(bucket,evn);
		//test.qsPutObjectByName("testa-f-stream",bucket);
		//test.deleteMultil(bucket);
		
		// evn.setLog_level(QSConstant.LOGGER_INFO);
		//  https://sh1a.qingstor.com/sh-test1/test.jpg
		
		//https://sh-test1.sh1a.qingstor.com:443/test.jpg
		
		//		http://static.521ke.com/college/10001_1.jpeg
		//QingStor storService = new QingStor(evn, sh1a);
		//Bucket bucket = storService.getBucket("sh-test2", "sh1a");
		//test.mulitUpload(bucket);
		
	}
	
	public void putObject(Bucket bucket,String objectName){
		Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
		File fa = new File("/tmp/test.txt");
		putObjectInput.setBodyInputFile(fa);
		putObjectInput.setContentType("text/plain; charset=utf-8");
		putObjectInput.setContentLength(fa.length());

		// bucket.putObject(objectName, putObjectInput);

		// 获取请求对象，正常 bucket.putObject(objectName, putObjectInput); 就完成操作
		try {
			PutObjectOutput output = bucket.putObject(objectName, putObjectInput);
			System.out.println(output.getStatueCode() +"---UploadMultipartOutput----" + output.getMessage());
		} catch (QSException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}


	}
	
	public void testUrl(Bucket bucket,EvnContext evnContext) throws Exception{
		
		GetObjectOutput out = bucket.GetObjectBySignatureUrl("https://sh1a.qingstor.com/qc-mobile/ad/communication_activity_20170627_20170728.jpg");
		if (out.getBodyInputStream() != null) {
			File ff = new File("/Users/karooli/Downloads/dingnigefei.jpg");
			OutputStream outa = new FileOutputStream(ff);
			int bytesRead = 0;
			byte[] buffer = new byte[1024];
			while ((bytesRead = out.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
				outa.write(buffer, 0, bytesRead);
				// iLength += bytesRead;
			}
			outa.close();
			out.getBodyInputStream().close();
		}
		
		
	}

	
	
	
	private void mulitUpload(Bucket bucket) throws QSException, FileNotFoundException {
		
		String objectKey = "testMulit";
		
		Bucket.InitiateMultipartUploadInput inputInit = new Bucket.InitiateMultipartUploadInput();
		inputInit.setContentType("contentType");
        InitiateMultipartUploadOutput initOutput = bucket.initiateMultipartUpload(objectKey, inputInit);

        String multipart_upload_name = objectKey;
        // 获取初始化id
        String multipart_upload_id = initOutput.getUploadID();
        System.out.println("-multipart_upload_id----" + initOutput.getUploadID());
        
        //大文件，进行分段上传
        File f = new File("/Users/karooli/Downloads/QKAqipai_yxdown.com.apk");
        long length = f.length() / 3 + 100;
		for(int i = 0 ; i < 3 ; i++) { //分段数量
			
			int part_number = i;
	        Bucket.UploadMultipartInput input = new Bucket.UploadMultipartInput();
	        //input.setXQSEncryptionCustomerKey(objectKey+i);
	        input.setContentLength(length);
	        input.setBodyInputFile(f);
	        input.setPartNumber(part_number);
	        input.setUploadID(multipart_upload_id);
	        RequestHandler handler = bucket.uploadMultipartRequest(multipart_upload_name, input);
	        handler.setProgressListener(new BodyProgressListener() {
				
				@Override
				public void onProgress(long len, long size) {
					// TODO Auto-generated method stub
					System.out.println(len+"------"+size);
					
				}
			});
	        UploadMultipartOutput bm = (UploadMultipartOutput) handler.send();
	        System.out.println("-UploadMultipartOutput----" + bm.getMessage());
	        
		}
		
		// Write code here that turns the phrase above into concrete actions
        Bucket.CompleteMultipartUploadInput input = new Bucket.CompleteMultipartUploadInput();        
        input.setUploadID(initOutput.getUploadID());
        String content = "{\n" +
                "    \"object_parts\": [\n" +
                "        {\"part_number\": 0},\n" +
                "        {\"part_number\": 1},\n" +
                "        {\"part_number\": 2}\n" +
                "    ]\n" +
                "}";
        input.setBodyInput(content);
        CompleteMultipartUploadOutput completeMultipartUploadOutput = bucket.completeMultipartUpload(objectKey, input);
        System.out.println("-completeMultipartUploadOutput----" + completeMultipartUploadOutput.getMessage());
	}

	
	public void deleteMultil(Bucket bucket) throws QSException, Exception {
		Bucket.ListObjectsInput input = new Bucket.ListObjectsInput();
		Bucket.ListObjectsOutput listObjectsOutput = new Bucket.ListObjectsOutput();
		input.setLimit(200);
		try {
			listObjectsOutput = bucket.listObjects(input);
		} catch (Exception ex) {
			System.out.println(ex.getMessage());
		}

		Bucket.DeleteMultipleObjectsInput deleteInput = new Bucket.DeleteMultipleObjectsInput();

		List<KeyModel> lstKey = new ArrayList();
		KeyModel m;
		for (int i = 0; i < listObjectsOutput.getKeys().size(); i++) {
			Types.KeyModel key = listObjectsOutput.getKeys().get(i);
			// deleteKey newKey = new deleteKey();
			System.out.println(key.getKey());
			m = new KeyModel();
			m.setKey(key.getKey());
			long expiresTime = new Date().getTime() / 1000 + 1000;
			GetObjectInput inputd = new GetObjectInput();
			RequestHandler handler = bucket.GetObjectBySignatureUrlRequest(key.getKey(),inputd, expiresTime);
			String url = handler.getExpiresRequestUrl();
			bucket.GetObjectBySignatureUrl(url);
			String dff = bucket.GetObjectSignatureUrl(key.getKey(), expiresTime);
			String strToSignature = handler.getStringToSignature();
			// serverAuthorization server端处理返回信息
			String serverAuthorization = QSSignatureUtil.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv",
					strToSignature);

			// 将计算的签名设置到request中
			handler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization + "1111111");
			String url2 = handler.getExpiresRequestUrl();

			System.out.println(dff);
			System.out.println(url);
			System.out.println(url2);
			GetObjectOutput out = bucket.GetObjectBySignatureUrl(url);
			System.out.println(out.getStatueCode() + ":--aaa---" + out.getMessage());
			if (out.getBodyInputStream() != null) {
				File ff = new File("/tmp/get_sign_objectfffff" + i + ".txt");
				OutputStream outa = new FileOutputStream(ff);
				int bytesRead = 0;
				byte[] buffer = new byte[1024];
				while ((bytesRead = out.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
					outa.write(buffer, 0, bytesRead);
					// iLength += bytesRead;
				}
				outa.close();
				out.getBodyInputStream().close();
			}
			lstKey.add(m);
			// newKey.key = key.getKey();
			// newInput.objects.add(newKey);
		}

		deleteInput.setObjects(lstKey);
		
		// String objectToJson = JSON.toJSONString(newInput);

		// deleteInput.setBodyInput(objectToJson);
		// deleteInput.setObjects(listObjectsOutput.getKeys());

		try {
			
			bucket.deleteMultipleObjects(deleteInput);
			
			RequestHandler reqHandler = bucket.deleteMultipleObjectsRequest(deleteInput);

			// strToSignature 将这个发送到用户的server端
			String strToSignature = reqHandler.getStringToSignature();

			// serverAuthorization server端处理返回信息
			String serverAuthorization = QSSignatureUtil.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv",
					strToSignature);

			// 将计算的签名设置到request中
			reqHandler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization);

			Bucket.DeleteMultipleObjectsOutput output = (DeleteMultipleObjectsOutput) reqHandler.send();
			System.out.println("DeleteMultipleObjectsOutput--:" + output.getMessage());
			System.out.println(output.getDeleted().size());
		} catch (Exception ex) {
			System.out.println(ex.getMessage());
		}
	}

	public void testSingnature(String objectName) {

		try {
			EvnContext evn = new EvnContext("", "");
			Bucket bucket = new Bucket(evn,testZone, "sh-test2");

			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
			File fa = new File("/tmp/config.yaml");
			putObjectInput.setBodyInputFile(fa);
			putObjectInput.setContentLength(fa.length());
			

			// bucket.putObject(objectName, putObjectInput);

			// 获取请求对象，正常 bucket.putObject(objectName, putObjectInput); 就完成操作
			RequestHandler reqHandler = bucket.putObjectRequest(objectName, putObjectInput);

			// strToSignature 将这个发送到用户的server端
			String strToSignature = reqHandler.getStringToSignature();

			// serverAuthorization server端处理返回信息
			String serverAuthorization = QSSignatureUtil.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv",
					strToSignature);

			// 将计算的签名设置到request中
			reqHandler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization);

			OutputModel output = reqHandler.send();

			System.out.println("-testSingnature--getMessage---" + output.getMessage());
			System.out.println("-testSingnature-getRequµestId--" + output.getRequestId());
			System.out.println("-testSingnature-getCode----" + output.getCode());
			System.out.println("-testSingnature-getStatueCode----" + output.getStatueCode());

		} catch (QSException e) {
			e.printStackTrace();
		}

	}

	public void objectTest(Bucket bucket) throws Exception {

		for( int i = 0 ; i< 100 ; i++){
			EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
			// evn.setLog_level(QSConstant.LOGGER_INFO);

			QingStor storService = new QingStor(evn,testZone);
			/*ListBucketsOutput listOutput = storService.listBuckets(new ListBucketsInput());
			for(BucketModel bm : listOutput.getBuckets()){
				if(bm.getName().length() > "1497413294380".length()){
					Bucket aa = storService.getBucket(bm.getName(), bm.getLocation());
					DeleteBucketOutput output = aa.delete();
					System.out.println(bm.getName()+"-DeleteBucketOutput----" + output.getStatueCode());
				}
				
			}*/
			Bucket bucketa = storService.getBucket("sh-test1", "sh1a");
			for (String name : objectTestName) {
				this.qsPutObjectByName(name, bucketa);
				//this.qsPutObjectByNameSetSignature(name + "signature", bucket);
				//this.qsDeleteObjectByName(name, bucket);
				//this.qsPutObjectByName(name, bucket);
				//this.qsMoveObject(name, bucket);
				// this.qsDeleteObjectByName(name + "toMove", bucket);
			}
		}
		
	}

	public void qsPutObjectByName(String objectName, Bucket bucket) throws Exception {

		try {
			HeadObjectOutput hhd = bucket.headObject(objectName, null);
			System.out.println(objectName + "---HeadObjectOutput---" + hhd.getMessage());
			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
			File fa = new File(
					"/Users/karooli/Downloads/提现-2.png");
			putObjectInput.setBodyInputStream(new FileInputStream(fa));
			putObjectInput.setContentLength(fa.length());
			putObjectInput.setContentType("image/png");
			

			// bucket.putObject(objectName, putObjectInput);

			OutputModel output = bucket.putObject(objectName, putObjectInput);

			System.out.println(objectName + "---getMessage---" + output.getMessage());
			System.out.println(objectName + "--getRequestId--" + output.getRequestId());
			System.out.println(objectName + "--getCode----" + output.getCode());
			System.out.println(objectName + "--getStatueCode----" + output.getStatueCode());
			//String url = bucket.GetObjectSignatureUrl(objectName, 2000);
			GetObjectInput inputd = new GetObjectInput();
			inputd.setResponseContentDisposition("attachement");
			RequestHandler rquestHandler = bucket.GetObjectBySignatureUrlRequest(objectName, inputd, System.currentTimeMillis()/1000 + 2000);
			String url2 = rquestHandler.getExpiresRequestUrl();//bucket.GetObjectSignatureUrl(objectName, System.currentTimeMillis()/1000 + 2000);
			System.out.println(url2);
			//System.out.println(url);
		} catch (QSException e) {
			e.printStackTrace();
		}

	}

	public void qsPutObjectByNameSetSignature(String objectName, Bucket bucket) throws Exception {

		try {
			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
			File fa = new File(
					"/Users/karooli/qingcloud/app/Qingstor-SDK/app/src/test/java/com/qingstor/sdk/QingStorUnitTest.java");
			putObjectInput.setBodyInputFile(fa);
			putObjectInput.setContentType("video/mp4; charset=utf8");
			putObjectInput.setContentLength(fa.length());

			// bucket.putObject(objectName, putObjectInput);

			// 获取请求对象，正常 bucket.putObject(objectName, putObjectInput); 就完成操作
			RequestHandler reqHandler = bucket.putObjectRequest(objectName, putObjectInput);

			// strToSignature 将这个发送到用户的server端
			String strToSignature = reqHandler.getStringToSignature();

			// serverAuthorization server端处理返回信息
			String serverAuthorization = QSServerSignatureUtil
					.generateSignature("lzV2bJ00RdlNUAiLqTf0i8EUwYL5KGmS1am2pjqv", strToSignature);

			// 将计算的签名设置到request中
			reqHandler.setSignature("HMZADZVBMNECJLSNKYRO", serverAuthorization);

			OutputModel output = (PutObjectOutput) reqHandler.send();

			System.out.println(objectName + "---qsPutObjectByNameSetSignaturegetMessage---" + output.getMessage());
			System.out.println(objectName + "--qsPutObjectByNameSetSignaturegetRequestId--" + output.getRequestId());
			System.out.println(objectName + "--qsPutObjectByNameSetSignaturegetCode----" + output.getCode());
			System.out
					.println(objectName + "--qsPutObjectByNameSetSignaturegetStatueCode----" + output.getStatueCode());

		} catch (QSException e) {
			e.printStackTrace();
		}

	}

	public void qsDeleteObjectByName(String objectName, Bucket bucket) throws Exception {

		try {

			Bucket.DeleteObjectOutput out = bucket.deleteObject(objectName);
			System.out.println("d--d" + out.getMessage());
			
			
		} catch (QSException e) {
			e.printStackTrace();
		}

	}

	public void qsMoveObject(String objectName, Bucket bucket) throws Exception {

		try {
			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			input.setXQSMoveSource("/sh-test/" + objectName);

			Bucket.PutObjectOutput copyOutput = bucket.putObject(objectName + "toMove", input);

			System.out.println(objectName + "qsMoveObject" + copyOutput.getMessage());
		} catch (QSException e) {
			e.printStackTrace();
		}

	}
	
	public void qsMoveObjectTest(String objectName, Bucket bucket) throws Exception {

		try {
			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			input.setXQSMoveSource("/sh-test/sourceObject");
			Bucket.PutObjectOutput copyOutput = bucket.putObject(objectName + "toMove", input);

			System.out.println(objectName + "qsMoveObject" + copyOutput.getMessage());
		} catch (QSException e) {
			e.printStackTrace();
		}

	}

	public void qsDeleteObjectaaa(String objectName, Bucket bucket) throws Exception {

		try {
			Bucket.DeleteObjectOutput out = bucket.deleteObject(objectName);

			System.out.println("d--d" + out.getMessage());
		} catch (QSException e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcCopyObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		QingStor storService = new QingStor(evn,testZone);
		try {
			Bucket bucket = storService.getBucket("test-ac", "pek3a");

			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			input.setXQSCopySource("/test-ac/test-acaaf");

			Bucket.PutObjectOutput copyOutput = bucket.putObject("test/test-ac", input);

			/*
			 * Bucket.PutObjectInput input = new Bucket.PutObjectInput(); File f
			 * = new File("/tmp/oobelib.log"); input.setBodyInputFile(f);
			 * input.setContentType("text/plain"); input.setContentLength((int)
			 * f.length()); bucket.putObjectAsync("test-acaaf", input, new
			 * ResponseCallBack<Bucket.PutObjectOutput>() {
			 * 
			 * @Override public void onAPIResponse(Bucket.PutObjectOutput
			 * output) throws QSException {
			 * System.out.println("d--d"+output.getMessage()); } });
			 */
			// Bucket.PutObjectOutput putObjectOutput =
			// bucket.putObject("private-img", input);
			System.out.println(copyOutput.getMessage());
		} catch (QSException e) {
			e.printStackTrace();
		}
		while (!bEexcute) {
			Thread.sleep(10000);
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcPutObjecteee() throws Exception {

		EvnContext evn = new EvnContext("CYQCHVBDUSZSBBBKEXDX", "tRlGgRG7Hp7S93byC22XOIINWhytJcaYEgTEE3FX");
		QingStor storService = new QingStor(evn,testZone);
		try {
			Bucket bucket = storService.getBucket("private-img", "pek3a");
			Bucket.PutBucketOutput putBucketOutput = bucket.put();

			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			File f = new File("/tmp/oobelib.log");
			input.setBodyInputFile(f);
			input.setContentType("text/plain");
			input.setContentLength(f.length());
			bucket.putObjectAsync("private-test", input, new ResponseCallBack<Bucket.PutObjectOutput>() {
				@Override
				public void onAPIResponse(Bucket.PutObjectOutput putObjectOutput) throws QSException {
					System.out.println(putObjectOutput.getMessage());
				}
			});
		} catch (QSException e) {
			e.printStackTrace();
		}
		while (!bEexcute) {
			Thread.sleep(10000);
		}

	}

	public static void traverseFolder(Bucket bucket, String path) {

		try {

			File file = new File(path);
			if (file.exists()) {
				File[] files = file.listFiles();
				if (files.length == 0) {
					return;
				} else {
					for (File file2 : files) {
						if (file2.isDirectory()) {
							traverseFolder(bucket, file2.getAbsolutePath());
						} else {
							// System.out.println("文件:" +
							// file2.getAbsolutePath());
							String fileName = file2.getName();
							Bucket.PutObjectInput ii = new Bucket.PutObjectInput();
							ii.setBodyInputFile(file2);
							bucket.putObjectAsync(fileName, ii, new ResponseCallBack<Bucket.PutObjectOutput>() {
								@Override
								public void onAPIResponse(Bucket.PutObjectOutput output) throws QSException {
									System.out.println(output.getMessage() + "----" + output.getCode());
								}
							});
						}
					}
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	        *
	        *
	        *
	        */
	public void getAcl() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		Bucket bucket = new Bucket(evn,testZone, "test0222211");
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		bucket.getACLAsync(new ResponseCallBack<Bucket.GetBucketACLOutput>() {
			@Override
			public void onAPIResponse(Bucket.GetBucketACLOutput output) throws QSException {
				System.out.println(output.getACL());
			}
		});
		int id = 0;
		while (!executeFlag) {
			Thread.sleep(15000);
		}
	}

	/*
	        *
	        *
	        *
	        */
	public void delete_multiple_objects() throws Throwable {
		// Write code here that turns the phrase above into concrete actions

		Bucket.DeleteMultipleObjectsInput input = new Bucket.DeleteMultipleObjectsInput();

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "test-ac");
		// arg1.raw().get(1)
		// input.setBodyInput("{\"quiet\":false,\"objects\":[{\"key\":\"object_0\"},{\"key\":\"object_1\"},{\"key\":\"object_2\"}]}");
		input.setQuiet(false);
		List<Types.KeyModel> objects = new ArrayList<Types.KeyModel>();
		Types.KeyModel mm1 = new Types.KeyModel();
		mm1.setKey("object_0");
		Types.KeyModel mm2 = new Types.KeyModel();
		mm2.setKey("object_0");
		Types.KeyModel mm3 = new Types.KeyModel();
		mm3.setKey("object_0");
		objects.add(mm1);
		objects.add(mm2);
		objects.add(mm3);
		input.setObjects(objects);
		// input.setContentMD5("1UK03AxvZpSNLmYR2oz4qg==");
		Bucket.DeleteMultipleObjectsOutput deleteMultipleObjectsOutput = bucket.deleteMultipleObjects(input);

		System.out.println(deleteMultipleObjectsOutput.getMessage());
		// throw new PendingException();
	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorGetUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "test-ac2");

		// https://test-ac.pek3a.qingst.com:443/%E5%B0%8F%E7%B1%B3%2Fchart.jpg

		try {

			try {
				Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
				putObjectInput.setBodyInputFile(new File("/tmp/testaa.jpg"));
				Bucket.GetObjectInput input = new Bucket.GetObjectInput();
				Bucket.PutObjectOutput output = bucket.putObject("来自 百度相册2/test_object/te&+st.htm", putObjectInput);
				// Bucket.GetObjectOutput output =
				// bucket.getObject("test/test-ac", input);

				System.out.println(output.getMessage());

			} catch (Exception e) {
				e.printStackTrace();
			}

			/*
			 * String dd =
			 * bucket.GetObjectSignatureUrl("中文测试/test_object/中+文test",2000);
			 * Bucket.GetObjectOutput outpucct =
			 * bucket.GetObjectBySignatureUrl(dd);
			 * Bucket.GetBucketStatisticsOutput doo = bucket.getStatistics();
			 */

			Bucket.GetObjectInput input = new Bucket.GetObjectInput();
			// Bucket.GetObjectOutput output = bucket.getObject("小米/chart.jpg",
			// input);
			Bucket.GetObjectOutput output = bucket.getObject("来自 百度相册2/test_object/te&+st.htm", input);

			System.out.println(output.getStatueCode());
			if (output.getBodyInputStream() != null && output.getStatueCode() == 200) {
				File ff = new File("/Users/karooli/testaa22.jpg");
				OutputStream out = null;
				try {
					out = new FileOutputStream(ff);
					int bytesRead = 0;
					byte[] buffer = new byte[1024];
					while ((bytesRead = output.getBodyInputStream().read(buffer, 0, 1024)) != -1) {
						out.write(buffer, 0, bytesRead);
					}
					out.close();
					output.getBodyInputStream().close();
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				}

			}

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstoraaPutUploadObject() throws Exception {

		String uncode = URLEncoder.encode("te%+ *st.htm", QSConstant.ENCODING_UTF8);
		System.out.println(uncode);

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorPutUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "sh-test");

		try {
			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();
			putObjectInput.setBodyInputFile(new File("/tmp/oobelib.log"));
			Bucket.GetObjectInput input = new Bucket.GetObjectInput();
			Bucket.PutObjectOutput output = bucket.putObject("中文测试/,./;'[]\\-=/中 文test", putObjectInput);
			// Bucket.GetObjectOutput output = bucket.getObject("test/test-ac",
			// input);

			System.out.println(output.getMessage() + output.getStatueCode());
			// Bucket.GetObjectOutput output = bucket.getObject("小米/chart.jpg",
			// input);
			Bucket.GetObjectOutput output2 = bucket.getObject("中文测试/,./;'[]\\-=/中 文test", input);

			System.out.println(output2.getMessage() + output2.getStatueCode());

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorCopyUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "test-ac2a");

		try {
			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			input.setXQSCopySource("/test-ac2a/中文测试/,./;'[]\\-=/中 文test");
			Bucket.PutObjectOutput copyOutput = bucket.putObject(",./;'[]\\-=test", input);
			System.out.println(copyOutput.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorFloadUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "test-ac2a");

		try {

			Bucket.PutObjectInput input = new Bucket.PutObjectInput();
			Bucket.PutObjectOutput creatFolderOutput = bucket.putObject("testFolder/", input);
			System.out.println(creatFolderOutput.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorBucket() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		String bucketName = System.currentTimeMillis() + "test";
		Bucket bucket = new Bucket(evn,testZone,"sh-test");

		try {
			Bucket.ListObjectsInput objectsInput = new Bucket.ListObjectsInput();
			objectsInput.setPrefix("");
			objectsInput.setDelimiter("/");

			Bucket.ListObjectsOutput oo = bucket.listObjects(objectsInput);

			System.out.println(oo.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorUserAgentBucket() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		evn.setAdditionalUserAgent("test/xidksld");
		String bucketName = System.currentTimeMillis() + "test";
		Bucket bucket = new Bucket(evn,testZone, "sh-test");

		try {
			Bucket.ListObjectsInput objectsInput = new Bucket.ListObjectsInput();
			objectsInput.setPrefix("");
			objectsInput.setDelimiter("/");

			Bucket.ListObjectsOutput oo = bucket.listObjects(objectsInput);

			System.out.println();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorString() throws Exception {

		System.out.println(QSStringUtil.asciiCharactersEncoding(
				"/&:ddks= ssfff中文-test\uD841\uDF0E\uD841\uDF31\uD841\uDF79\uD843\uDC53\uD843\uDC78\uD843\uDC96\uD843\uDCCF"));
		System.out.println(QSStringUtil.asciiCharactersEncoding(
				"!@#$%^&*()`~中文-test\uD841\uDF0E\uD841\uDF31\uD841\uDF79\uD843\uDC53\uD843\uDC78\uD843\uDC96\uD843\uDCCF"));
		System.out.println(100l);
		System.out.println(100);
		

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorPutaaUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "android");

		try {
			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();

			File f = new File("/Users/karooli/Downloads/11aaaa.jpg");
			URLConnection connection = new URL("https://pek3a.qingstor.com/android/11aaaa.jpg").openConnection();
			InputStream inputStream = connection.getInputStream();

			int len = connection.getContentLength();

			// InputStream inputStream = new FileInputStream(f);
			// putObjectInput.setBodyInputFile(f);
			putObjectInput.setBodyInputStream(inputStream);
			putObjectInput.setContentType("image/jpeg");
			putObjectInput.setContentLength(f.length());

			Bucket.GetObjectInput input = new Bucket.GetObjectInput();
			Bucket.PutObjectOutput output = bucket.putObject("测试01/test22.jpg", putObjectInput);

			System.out.println(output.getMessage());

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	 *
	 *
	 * MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=
	 * 77+977+977+9Dicc77+977+977+9BO+/vTI577+977+9DQ== iZOTDiccmYWzBNgyOdDHDQ==
	 * aVpPVERpY2NtWVd6Qk5neU9kREhEUT09 12345678123456781234567812345678
	 */
	public void qcstorPutUploadObjectaa() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		Bucket bucket = new Bucket(evn,testZone, "android");

		try {

			Bucket.PutObjectInput putObjectInput = new Bucket.PutObjectInput();

			putObjectInput.setXQSEncryptionCustomerAlgorithm("AES256");
			putObjectInput.setXQSEncryptionCustomerKey("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=");
			putObjectInput.setXQSEncryptionCustomerKeyMD5("ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ=");
			InputStream inputStream = new ByteArrayInputStream("helloworld".getBytes());
			putObjectInput.setBodyInputFile(new File("/tmp/test.txt"));

			Bucket.PutObjectOutput output = bucket.putObject("fsdfsadf", putObjectInput);
			// Bucket.GetObjectOutput output = bucket.getObject("test/test-ac",
			// input);

			System.out.println(output.getMessage());
			// Bucket.GetObjectOutput output = bucket.getObject("小米/chart.jpg",
			// input);

			System.out.println(output.getStatueCode());

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void qcstorGetbucketUploadObject() throws Exception {

		EvnContext evn = EvnContext.loadFromFile(config + "config_stor.yaml");
		evn.setLog_level(QSConstant.LOGGER_INFO);
		QingStor stor = new QingStor(evn,testZone);

		try {
			QingStor.ListBucketsOutput output = stor.listBuckets(null);

			System.out.println(output.getStatueCode() + "---");

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void md5test() throws Exception {

		String password = "MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg";
		String content = "helloworld";
		try {
			// "AES"：请求的密钥算法的标准名称
			KeyGenerator kgen = KeyGenerator.getInstance("AES");
			// 256：密钥生成参数；securerandom：密钥生成器的随机源
			SecureRandom securerandom = new SecureRandom(tohash256Deal(password));
			kgen.init(256, securerandom);
			// 生成秘密（对称）密钥
			SecretKey secretKey = kgen.generateKey();
			// 返回基本编码格式的密钥
			byte[] enCodeFormat = secretKey.getEncoded();
			// 根据给定的字节数组构造一个密钥。enCodeFormat：密钥内容；"AES"：与给定的密钥内容相关联的密钥算法的名称
			SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
			// 将提供程序添加到下一个可用位置
			// Security.addProvider(new BouncyCastleProvider());
			// 创建一个实现指定转换的 Cipher对象，该转换由指定的提供程序提供。
			// "AES/ECB/PKCS7Padding"：转换的名称；"BC"：提供程序的名称
			Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");

			cipher.init(Cipher.ENCRYPT_MODE, key);
			byte[] byteContent = content.getBytes("utf-8");
			byte[] cryptograph = cipher.doFinal(byteContent);
			System.out.println(Base64.encode(cryptograph));
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	        *
	        *
	        *
	        */
	public void md5testaaa() throws Exception {

		String password = "12345678123456781234567812345678";
		try {
			MessageDigest instance = null;
			try {
				instance = MessageDigest.getInstance("MD5");
			} catch (NoSuchAlgorithmException e) {
				throw new QSException("MessageDigest MD5 error", e);
			}

			// ODk5MzkzMGUyNzFjOTk4NWIzMDRkODMyMzlkMGM3MGQ
			// ODk5MzkzMEUyNzFDOTk4NUIzMDREODMyMzlEMEM3MEQ
			String contentMD5 = new String(instance.digest(password.toString().getBytes()));
			String contentMD52 = new String(Base64.encode(instance.digest(password.toString().getBytes())));

			System.out.println(Base64.encode(password.getBytes()));
			System.out.println(Base64.encode(contentMD5.getBytes()));
			System.out.println(contentMD52);
			System.out.println(Base64.encode(contentMD52.getBytes()));
			String md532 = MD5(password);
			System.out.println(md532);
			System.out.println(Base64.encode(md532.getBytes()));
			System.out.println(new String(Base64.decode("MTIzNDU2NzgxMjM0NTY3ODEyMzQ1Njc4MTIzNDU2Nzg=")));
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	private static String MD5(String sourceStr) {
		String result = "";
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(sourceStr.getBytes());
			byte b[] = md.digest();
			int i;
			StringBuffer buf = new StringBuffer("");
			for (int offset = 0; offset < b.length; offset++) {
				i = b[offset];
				if (i < 0)
					i += 256;
				if (i < 16)
					buf.append("0");
				buf.append(Integer.toHexString(i));
			}
			result = buf.toString();
			System.out.println("MD5(" + sourceStr + ",32) = " + result);
			System.out.println("MD5(" + sourceStr + ",16) = " + buf.toString().substring(8, 24));
		} catch (NoSuchAlgorithmException e) {
			System.out.println(e);
		}
		return result;
	}

	private static byte[] tohash256Deal(String datastr) {
		try {
			MessageDigest digester = MessageDigest.getInstance("SHA-256");
			digester.update(datastr.getBytes());
			byte[] hex = digester.digest();
			return hex;
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException(e.getMessage());
		}
	}
}
