/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.CancellationHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSJSONUtil;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.json.JSONObject;

public class QSOkHttpRequestClient {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSOkHttpRequestClient.class.getName());
    private OkHttpClient client = null;
    private OkHttpClient unsafeClient = null;
    private static volatile QSOkHttpRequestClient ins;

    protected QSOkHttpRequestClient() {
        this.intiOkHttpClient();
    }

    public void intiOkHttpClient() {
        this.client = new OkHttpClient.Builder().connectTimeout((long)QSConstant.HTTPCLIENT_CONNECTION_TIME_OUT, TimeUnit.SECONDS).readTimeout((long)QSConstant.HTTPCLIENT_READ_TIME_OUT, TimeUnit.SECONDS).writeTimeout((long)QSConstant.HTTPCLIENT_WRITE_TIME_OUT, TimeUnit.SECONDS).build();
        this.unsafeClient = QSOkHttpRequestClient.getUnsafeOkHttpClient();
    }

    @Deprecated
    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)QSConstant.HTTPCLIENT_CONNECTION_TIME_OUT, TimeUnit.SECONDS).readTimeout((long)QSConstant.HTTPCLIENT_READ_TIME_OUT, TimeUnit.SECONDS).writeTimeout((long)QSConstant.HTTPCLIENT_WRITE_TIME_OUT, TimeUnit.SECONDS);
            builder.sslSocketFactory(sslSocketFactory);
            builder.hostnameVerifier(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            OkHttpClient okHttpClient = builder.build();
            return okHttpClient;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QSOkHttpRequestClient getInstance() {
        if (ins != null) return ins;
        Class<QSOkHttpRequestClient> clazz = QSOkHttpRequestClient.class;
        synchronized (QSOkHttpRequestClient.class) {
            if (ins != null) return ins;
            ins = new QSOkHttpRequestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    private Call getRequestCall(boolean bSafe, Request request) {
        if (bSafe) {
            return this.client.newCall(request);
        }
        return this.unsafeClient.newCall(request);
    }

    public OutputModel requestAction(Request request, boolean bSafe, Class outputClass) throws QSException {
        Call okhttpCall = this.getRequestCall(bSafe, request);
        Response response = null;
        OutputModel model = (OutputModel)QSParamInvokeUtil.getOutputModel(outputClass);
        try {
            response = okhttpCall.execute();
            this.fillResponseValue2Object(response, model);
            return model;
        }
        catch (Exception e) {
            if (e instanceof CancellationHandler.CancellationException) {
                QSOkHttpRequestClient.fillResponseCallbackModel(20000, e.getMessage(), model);
                return model;
            }
            e.printStackTrace();
            logger.log(Level.SEVERE, e.getMessage());
            throw new QSException(e.getMessage());
        }
    }

    public Request buildUrlRequest(String singedUrl) {
        Request request = new Request.Builder().url(singedUrl).build();
        return request;
    }

    public OutputModel requestActionAsync(Request request, boolean bSafe, final ResponseCallBack callBack) throws QSException {
        Call okhttpCall = this.getRequestCall(bSafe, request);
        okhttpCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                QSOkHttpRequestClient.this.onOkhttpFailure(e, callBack);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    if (callBack != null) {
                        OutputModel m = QSParamInvokeUtil.getOutputModel(callBack);
                        QSOkHttpRequestClient.this.fillResponseValue2Object(response, m);
                        callBack.onAPIResponse(m);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage());
                    QSOkHttpRequestClient.this.onOkhttpFailure(e, callBack);
                }
                finally {
                    if (response != null) {
                        Util.closeQuietly((Closeable)response.body().source());
                    }
                }
            }
        });
        return null;
    }

    private void onOkhttpFailure(Exception e, ResponseCallBack callBack) {
        try {
            if (callBack != null) {
                int errorCode = 10000;
                if (e instanceof CancellationHandler.CancellationException) {
                    errorCode = 20000;
                }
                OutputModel m = QSParamInvokeUtil.getOutputModel(callBack);
                QSOkHttpRequestClient.fillResponseCallbackModel(errorCode, e.getMessage(), m);
                callBack.onAPIResponse(m);
            }
        }
        catch (Exception ee) {
            logger.log(Level.SEVERE, ee.getMessage());
        }
    }

    private void fillResponseValue2Object(Response response, OutputModel target) throws IOException {
        int code = response.code();
        ResponseBody body = response.body();
        JSONObject o = QSJSONUtil.toJSONObject("{}");
        QSJSONUtil.putJsonData(o, "BodyInputStream", (Object)body.source().inputStream());
        if (target != null) {
            if (!QSJSONUtil.jsonObjFillValue2Object(o, target)) {
                try {
                    String responseInfo = body.string();
                    if (!QSStringUtil.isEmpty(responseInfo)) {
                        QSJSONUtil.jsonFillValue2Object(responseInfo, target);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Headers responceHeaders = response.headers();
            int iHeads = responceHeaders.size();
            JSONObject headJson = QSJSONUtil.toJSONObject("{}");
            QSJSONUtil.putJsonData(headJson, QSConstant.QC_CODE_FIELD_NAME, (Object)code);
            for (int i = 0; i < iHeads; ++i) {
                QSJSONUtil.putJsonData(headJson, responceHeaders.name(i), (Object)responceHeaders.value(i));
            }
            QSJSONUtil.jsonObjFillValue2Object(headJson, target);
        }
    }

    public Request buildRequest(String method, String signedUrl, RequestBody requestBody, Map headParams) {
        String[] sortedHeadersKeys;
        Request.Builder builder = new Request.Builder();
        for (String key : sortedHeadersKeys = headParams.keySet().toArray(new String[0])) {
            builder.addHeader(key, String.valueOf(headParams.get(key)));
        }
        if (!headParams.containsKey("User-Agent")) {
            builder.addHeader("User-Agent", QSStringUtil.getUserAgent());
        }
        return builder.url(signedUrl).method(method, requestBody).build();
    }

    public static void fillResponseCallbackModel(int code, Object content, OutputModel model) {
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put(QSConstant.QC_CODE_FIELD_NAME, code);
        errorMap.put(QSConstant.QC_MESSAGE_FIELD_NAME, content);
        QSJSONUtil.jsonFillValue2Object(QSStringUtil.getObjectToJson(errorMap), model);
    }
}

