/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.common.OperationContext;
import com.qingstor.sdk.common.auth.Credentials;
import com.qingstor.sdk.constants.ParamType;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.QSFormRequestBody;
import com.qingstor.sdk.request.impl.QSMultiPartUploadRequestBody;
import com.qingstor.sdk.request.impl.QSNormalRequestBody;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import com.qingstor.sdk.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSBuilder {
    private static final Logger log = LoggerFactory.getLogger(QSBuilder.class);
    private OperationContext opCtx;
    private RequestInputModel paramsModel;
    private String httpMethod = "GET";
    private Map paramsQuery;
    private Map paramsBody;
    private Map paramsHeaders;
    private Map paramsFormData;
    private HttpUrl urlWithoutQueries;
    private boolean pathMode;

    @Deprecated
    public QSBuilder(Map opCtx, RequestInputModel params) throws QSException {
        this(OperationContext.from(opCtx), params);
    }

    public QSBuilder(OperationContext ctx, RequestInputModel params) throws QSException {
        this.opCtx = ctx;
        this.paramsModel = params;
        this.initHeadersAndBody();
        this.initUrlWithQueries();
    }

    private void initHeadersAndBody() throws QSException {
        String customUA;
        this.httpMethod = this.opCtx.reqMethod();
        this.paramsHeaders = QSParamInvokeUtil.getRequestParams(this.paramsModel, ParamType.HEADER);
        String metaPrefix = "x-qs-meta-";
        if (this.paramsHeaders.containsKey("x-qs-metadata")) {
            Object o = this.paramsHeaders.get("x-qs-metadata");
            if (o != null) {
                Map map = (Map)o;
                for (Map.Entry entry : map.entrySet()) {
                    this.paramsHeaders.put("x-qs-meta-" + (String)entry.getKey(), entry.getValue());
                }
            }
            this.paramsHeaders.remove("x-qs-metadata");
        }
        customUA = (customUA = this.opCtx.clientCfg().userAgent()) == null ? QSStringUtil.getUserAgent() : customUA;
        this.paramsHeaders.put("User-Agent", customUA);
        if (this.checkExpiresParam()) {
            this.paramsHeaders.clear();
            this.paramsHeaders.put("Expires", this.opCtx.expires());
        }
        this.paramsBody = QSParamInvokeUtil.getRequestParams(this.paramsModel, ParamType.BODY_ELEMENT);
        if (this.paramsBody.size() != 0) {
            this.paramsHeaders.put("content-type", "application/json");
        } else {
            this.paramsBody = QSParamInvokeUtil.getRequestParams(this.paramsModel, ParamType.BODY);
        }
        this.initHeadContentMd5(this.paramsBody, this.paramsHeaders);
        this.paramsFormData = QSParamInvokeUtil.getRequestParams(this.paramsModel, ParamType.FORM_DATA);
    }

    private void initUrlWithQueries() throws QSException {
        String zone = this.opCtx.zone();
        String bucketName = this.opCtx.bucketName();
        String objectName = this.opCtx.objKey();
        HttpUrl endpoint = UrlUtils.calcFinalEndpoint(this.opCtx.clientCfg().endpoint(), zone, bucketName, this.opCtx.clientCfg());
        if (endpoint == null) {
            throw new QSException("url parsing failed");
        }
        this.pathMode = !this.opCtx.clientCfg().isVirtualHostEnabled();
        String resourcePath = UrlUtils.calcResourcePath(bucketName, objectName, this.pathMode);
        this.urlWithoutQueries = endpoint.newBuilder().addEncodedPathSegments(resourcePath).build();
        HttpUrl.Builder urlBuilder = this.urlWithoutQueries.newBuilder();
        String requestPath = this.opCtx.subSourcePath();
        int i = requestPath.indexOf(63);
        if (i != -1) {
            String extraQueries = requestPath.substring(i + 1);
            urlBuilder.query(extraQueries);
        }
        this.paramsQuery = QSParamInvokeUtil.getRequestParams(this.paramsModel, ParamType.QUERY);
        this.paramsQuery.forEach((k, v) -> urlBuilder.addQueryParameter(k.toString(), v == null ? null : v.toString()));
        HttpUrl url = urlBuilder.build();
        HashMap queries = new HashMap();
        for (String k2 : url.queryParameterNames()) {
            List values = url.queryParameterValues(k2);
            queries.put(k2, values.get(0));
        }
        this.paramsQuery = queries;
        log.debug("== resource Url ==\n" + this.urlWithoutQueries + "\n");
    }

    private Map headParamEncoding(Map headParams) {
        int maxAscii = 127;
        HashMap<String, String> head = new HashMap<String, String>();
        Iterator iterator = headParams.entrySet().iterator();
        while (iterator.hasNext()) {
            int codePoint;
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = (String)entry.getKey();
            String value = entry.getValue().toString();
            int nChars = value.length();
            for (int charIndex = 0; charIndex < nChars; charIndex += Character.charCount(codePoint)) {
                codePoint = value.codePointAt(charIndex);
                if (codePoint <= 127) continue;
                value = QSStringUtil.asciiCharactersEncoding(value);
                break;
            }
            head.put(key, value);
        }
        return head;
    }

    private void initHeadContentMd5(Map paramsBody, Map headerParams) throws QSException {
        String requestApi = this.opCtx.apiName();
        if ("DeleteMultipleObjects".equals(requestApi) && paramsBody.size() > 0) {
            Object bodyContent = QSNormalRequestBody.getBodyContent(paramsBody);
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                String contentMD5 = Base64.getEncoder().encodeToString(md5.digest(bodyContent.toString().getBytes()));
                headerParams.put("content-md5", contentMD5);
            }
            catch (NoSuchAlgorithmException e) {
                throw new QSException(e.getMessage(), e);
            }
        }
    }

    private QSRequestBody determineBody() {
        if (this.paramsFormData != null && this.paramsFormData.size() > 0) {
            return new QSFormRequestBody();
        }
        String requestApi = this.opCtx.apiName();
        if ("UploadMultipart".equals(requestApi)) {
            return new QSMultiPartUploadRequestBody();
        }
        return new QSNormalRequestBody();
    }

    public RequestBody getRequestBody() throws QSException {
        String contentType = String.valueOf(this.paramsHeaders.get("content-type"));
        long contentLength = 0L;
        if (this.paramsHeaders.containsKey("content-length")) {
            contentLength = Long.parseLong(this.paramsHeaders.get("content-length") + "");
        }
        Map bodyParams = this.paramsFormData != null && this.paramsFormData.size() > 0 ? this.paramsFormData : this.paramsBody;
        this.paramsHeaders = this.headParamEncoding(this.paramsHeaders);
        this.getSignature();
        QSRequestBody reqBody = this.determineBody();
        return reqBody.getRequestBody(contentType, contentLength, this.httpMethod, bodyParams, this.paramsQuery);
    }

    public Request getRequest(RequestBody reqBody) throws QSException {
        String[] sortedHeadersKeys;
        if (this.checkExpiresParam()) {
            throw new QSException("You need to 'getExpiresRequestUrl' do request!");
        }
        Request.Builder builder = new Request.Builder();
        for (String key : sortedHeadersKeys = this.paramsHeaders.keySet().toArray(new String[0])) {
            builder.addHeader(key, String.valueOf(this.paramsHeaders.get(key)));
        }
        return builder.url(this.mergeFullUrl()).method(this.httpMethod, reqBody).build();
    }

    private String mergeFullUrl() {
        HttpUrl.Builder builder = this.urlWithoutQueries.newBuilder();
        this.paramsQuery.forEach((k, v) -> builder.addQueryParameter(k.toString(), v == null ? null : v.toString()));
        return builder.build().toString();
    }

    public String getExpiresRequestUrl() throws QSException {
        HttpUrl.Builder builder = this.urlWithoutQueries.newBuilder();
        this.paramsQuery.forEach((k, v) -> builder.addQueryParameter(k.toString(), v == null ? null : v.toString()));
        String expiresTime = this.opCtx.expires();
        Credentials credentials = this.opCtx.credentials();
        if (expiresTime != null && !QSStringUtil.isEmpty(credentials.getAccessKeyId()) && !QSStringUtil.isEmpty(credentials.getSecretAccessKey())) {
            String expireAuth = this.getSignature();
            String ak = credentials.getAccessKeyId();
            builder.addQueryParameter("access_key_id", ak).addQueryParameter("expires", expiresTime).addQueryParameter("signature", expireAuth);
        }
        return builder.build().toString();
    }

    private String resourcePathForSign() {
        String encodedPath = this.urlWithoutQueries.encodedPath();
        if (this.pathMode) {
            return encodedPath;
        }
        String bucketName = this.opCtx.bucketName();
        return "/" + (bucketName != null ? bucketName + encodedPath : "");
    }

    public void setHeader(String name, String value) {
        this.paramsHeaders.put(name, value);
    }

    private boolean checkExpiresParam() {
        String expiresTime = this.opCtx.expires();
        return expiresTime != null;
    }

    public void setSignature(String accessKey, String signature) throws QSException {
        try {
            signature = this.checkExpiresParam() ? URLEncoder.encode(signature, "UTF-8") : String.format("QS %s:%s", accessKey, signature);
            this.paramsHeaders.put("Authorization", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("Auth signature error", e);
        }
    }

    public String getStringToSignature() {
        return QSSignatureUtil.getStringToSignature(this.httpMethod, this.resourcePathForSign(), this.paramsQuery, this.paramsHeaders);
    }

    private String getSignature() throws QSException {
        String authSign;
        String signature = String.valueOf(this.paramsHeaders.get("Authorization"));
        if (!QSStringUtil.isEmpty(signature)) {
            return signature;
        }
        Credentials credentials = this.opCtx.credentials();
        if (QSStringUtil.isEmpty(credentials.getAccessKeyId()) || QSStringUtil.isEmpty(credentials.getSecretAccessKey())) {
            return null;
        }
        try {
            authSign = this.checkExpiresParam() ? QSSignatureUtil.generateSignature(credentials.getSecretAccessKey(), this.getStringToSignature()) : QSSignatureUtil.generateAuthorization(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), this.getStringToSignature());
        }
        catch (Exception e) {
            throw new QSException("Auth signature error", e);
        }
        log.debug("== authSign ==\n" + authSign + "\n");
        this.paramsHeaders.put("Authorization", authSign);
        return authSign;
    }

    @Deprecated
    public RequestBody getRequestBody(QSRequestBody qsBody) throws QSException {
        String contentType = String.valueOf(this.paramsHeaders.get("content-type"));
        long contentLength = 0L;
        if (this.paramsHeaders.containsKey("content-length")) {
            contentLength = Long.parseLong(this.paramsHeaders.get("content-length") + "");
        }
        RequestBody requestBody = qsBody != null ? qsBody.getRequestBody(contentType, contentLength, this.httpMethod, this.paramsBody, this.paramsQuery) : this.getRequestBody();
        this.paramsHeaders = this.headParamEncoding(this.paramsHeaders);
        this.getSignature();
        return requestBody;
    }
}

