/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.common.OperationContext;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import okhttp3.Request;

public class QSRequest {
    public static <T extends OutputModel> void sendApiRequestAsync(String requestUrl, OperationContext opCtx, ResponseCallBack<T> callback, Class<T> outputClass) {
        EnvContext envContext = (EnvContext)opCtx.credentials();
        Request request = new Request.Builder().url(requestUrl).build();
        QSOkHttpRequestClient.getInstance(envContext).requestActionAsync(request, envContext.isSafeOkHttp(), callback, outputClass);
    }

    public static OutputModel sendApiRequest(String requestUrl, OperationContext opCtx, Class<? extends OutputModel> outputClass) throws QSException {
        EnvContext envContext = (EnvContext)opCtx.credentials();
        Request request = new Request.Builder().url(requestUrl).build();
        return QSOkHttpRequestClient.getInstance(envContext).requestAction(request, envContext.isSafeOkHttp(), outputClass);
    }

    public static <T extends OutputModel> RequestHandler<T> getRequestAsync(OperationContext opCtx, RequestInputModel paramBean, ResponseCallBack<? extends OutputModel> callback, Class<T> outputClass) throws QSException {
        return new RequestHandler<OutputModel>(opCtx, paramBean, callback, outputClass);
    }

    public static <T extends OutputModel> RequestHandler<T> getRequest(OperationContext opCtx, RequestInputModel paramBean, Class<T> outputClass) throws QSException {
        return new RequestHandler<T>(opCtx, paramBean, outputClass);
    }
}

