/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.common.OperationContext;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.BodyProgressListener;
import com.qingstor.sdk.request.CancellationHandler;
import com.qingstor.sdk.request.QSBuilder;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.request.impl.ProgressRequestBody;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler<T extends OutputModel> {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private final OperationContext opCtx;
    private final RequestInputModel paramBean;
    private Class<T> outputClass;
    private ResponseCallBack<T> asyncCallback;
    private QSBuilder builder;
    private BodyProgressListener progressListener;
    private CancellationHandler cancellationHandler;
    @Deprecated
    private QSRequestBody qsRequestBody;

    @Deprecated
    public RequestHandler(Map<String, Object> operationCtx, RequestInputModel paramBean, Class<T> outputClass) throws QSException {
        this(OperationContext.from(operationCtx), paramBean, outputClass);
    }

    public RequestHandler(OperationContext opCtx, RequestInputModel paramBean, Class<T> outputClass) throws QSException {
        this.opCtx = opCtx;
        this.paramBean = paramBean;
        this.outputClass = outputClass;
        this.builder = new QSBuilder(opCtx, paramBean);
    }

    @Deprecated
    public RequestHandler(Map<String, Object> context, RequestInputModel paramBean, ResponseCallBack<T> asyncCallback, Class<T> outputClass) throws QSException {
        this(OperationContext.from(context), paramBean, asyncCallback, outputClass);
    }

    public RequestHandler(OperationContext context, RequestInputModel paramBean, ResponseCallBack<T> asyncCallback, Class<T> outputClass) throws QSException {
        this.opCtx = context;
        this.paramBean = paramBean;
        this.asyncCallback = asyncCallback;
        this.outputClass = outputClass;
        this.builder = new QSBuilder(context, paramBean);
    }

    public void sendAsync() throws QSException {
        String validate = this.check();
        if (!QSStringUtil.isEmpty(validate)) {
            this.fillClientErr(validate);
        } else {
            EnvContext envContext = (EnvContext)this.opCtx.credentials();
            Request request = this.getRequest();
            QSOkHttpRequestClient.getInstance(envContext).requestActionAsync(request, this.opCtx.clientCfg().isSafeOkHttp(), this.asyncCallback, this.outputClass);
        }
    }

    private void fillClientErr(String msg) throws QSException {
        T out = QSParamInvokeUtil.getOutputModel(this.outputClass);
        QSOkHttpRequestClient.fillResponseCallbackModel(10000, msg, out);
        this.asyncCallback.onAPIResponse(out);
    }

    public T send() throws QSException {
        String validate = this.check();
        if (!QSStringUtil.isEmpty(validate)) {
            try {
                T model = QSParamInvokeUtil.getOutputModel(this.outputClass);
                QSOkHttpRequestClient.fillResponseCallbackModel(10000, validate, model);
                return model;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new QSException(e.getMessage());
            }
        }
        EnvContext envContext = (EnvContext)this.opCtx.credentials();
        Request request = this.getRequest();
        return QSOkHttpRequestClient.getInstance(envContext).requestAction(request, this.opCtx.clientCfg().isSafeOkHttp(), this.outputClass);
    }

    private Request getRequest() throws QSException {
        this.checkDownloadRequest();
        RequestBody body = this.builder.getRequestBody();
        if (this.getProgressListener() != null) {
            return this.builder.getRequest(new ProgressRequestBody(body, this.progressListener, this.getCancellationHandler()));
        }
        return this.builder.getRequest(body);
    }

    private void checkDownloadRequest() {
        Field[] declaredField;
        if (this.outputClass == null) {
            return;
        }
        boolean isDownloadRequest = false;
        block0: for (Field field : declaredField = this.outputClass.getDeclaredFields()) {
            Method[] methods;
            String methodName = "get" + QSStringUtil.capitalize(field.getName());
            for (Method m : methods = this.outputClass.getDeclaredMethods()) {
                ParamAnnotation annotation;
                if (!m.getName().equalsIgnoreCase(methodName) || (annotation = m.getAnnotation(ParamAnnotation.class)) == null || !"BodyInputStream".equals(annotation.paramName())) continue;
                isDownloadRequest = true;
                continue block0;
            }
        }
        if (isDownloadRequest) {
            this.getBuilder().setHeader("Accept-Encoding", "identity");
        }
    }

    public String getStringToSignature() {
        return this.builder.getStringToSignature();
    }

    public void setSignature(String accessKey, String signature) throws QSException {
        this.builder.setSignature(accessKey, signature);
    }

    public void setSignature(String accessKey, String signature, String gmtTime) throws QSException {
        this.builder.setHeader("Date", gmtTime);
        this.setSignature(accessKey, signature);
    }

    public String getExpiresRequestUrl() throws QSException {
        return this.builder.getExpiresRequestUrl();
    }

    private String check() {
        return this.paramBean != null ? this.paramBean.validateParam() : "";
    }

    public QSBuilder getBuilder() {
        return this.builder;
    }

    public BodyProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(BodyProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Deprecated
    public QSRequestBody getQsRequestBody() {
        return this.qsRequestBody;
    }

    @Deprecated
    public void setQsRequestBody(QSRequestBody qsRequestBody) {
        this.qsRequestBody = qsRequestBody;
    }

    public CancellationHandler getCancellationHandler() {
        return this.cancellationHandler;
    }

    public void setCancellationHandler(CancellationHandler cancellationHandler) {
        this.cancellationHandler = cancellationHandler;
    }
}

