/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.request.BodyProgressListener;
import com.qingstor.sdk.request.CancellationHandler;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

public class ProgressRequestBody
extends RequestBody {
    private RequestBody requestBody;
    private BodyProgressListener listener;
    private CancellationHandler cancellationHandler;

    public ProgressRequestBody(RequestBody requestBody, BodyProgressListener listener, CancellationHandler cancellationHandler) {
        this.requestBody = requestBody;
        this.listener = listener;
        this.cancellationHandler = cancellationHandler;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (this.listener != null) {
            Buffer buffer = new Buffer();
            this.requestBody.writeTo((BufferedSink)buffer);
            long size = buffer.size();
            if (size == -1L) {
                return;
            }
            int blockSize = 2048;
            long writeSize = 0L;
            while (writeSize + (long)blockSize < size) {
                if (this.cancellationHandler != null && this.cancellationHandler.isCancelled()) {
                    throw new CancellationHandler.CancellationException();
                }
                buffer.copyTo(bufferedSink.buffer(), writeSize, (long)blockSize);
                bufferedSink.flush();
                this.listener.onProgress(writeSize += (long)blockSize, size);
            }
            if (this.cancellationHandler != null && this.cancellationHandler.isCancelled()) {
                throw new CancellationHandler.CancellationException();
            }
            buffer.copyTo(bufferedSink.buffer(), writeSize, size - writeSize);
            bufferedSink.flush();
            this.listener.onProgress(writeSize, size);
            buffer.clear();
        } else {
            this.requestBody.writeTo(bufferedSink);
            bufferedSink.flush();
        }
    }
}

