/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.EmptyRequestBody;
import com.qingstor.sdk.request.impl.InputStreamUploadBody;
import com.qingstor.sdk.request.impl.MultiFileuploadRequestBody;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSMultiPartUploadRequestBody
implements QSRequestBody {
    private static final Logger log = LoggerFactory.getLogger(QSMultiPartUploadRequestBody.class);

    @Override
    public RequestBody getRequestBody(String contentType, long contentLength, String method, Map<String, Object> bodyParams, Map<String, Object> queryParams) throws QSException {
        log.debug("----QSMultiPartUploadRequestBody---");
        MediaType mediaType = MediaType.parse((String)contentType);
        if (bodyParams != null && bodyParams.size() > 0) {
            RequestBody requestBody = null;
            Iterator<Map.Entry<String, Object>> iterator = bodyParams.entrySet().iterator();
            int partNumber = Integer.parseInt(queryParams.get("part_number") + "");
            long offset = Long.parseLong(queryParams.get("file_offset") + "");
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object bodyObj = bodyParams.get(key);
                if (bodyObj instanceof String) {
                    requestBody = RequestBody.create((MediaType)mediaType, (String)bodyObj.toString());
                    continue;
                }
                if (bodyObj instanceof File) {
                    if (contentLength == 0L) {
                        contentLength = ((File)bodyObj).length();
                    }
                    if (offset < 0L) {
                        offset = contentLength * (long)partNumber;
                    }
                    requestBody = this.getSeekFileRequestBody(contentType, contentLength, offset, (File)bodyObj);
                    continue;
                }
                if (bodyObj instanceof InputStream) {
                    requestBody = new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength, offset);
                    continue;
                }
                String jsonStr = QSStringUtil.objectToJson(key, bodyObj);
                requestBody = RequestBody.create((MediaType)mediaType, (String)jsonStr);
            }
            return requestBody;
        }
        if (HttpMethod.permitsRequestBody((String)method)) {
            return new EmptyRequestBody(contentType);
        }
        return null;
    }

    private RequestBody getSeekFileRequestBody(String contentType, long contentLength, long offset, File bodyObj) throws QSException {
        MultiFileuploadRequestBody requestBody;
        RandomAccessFile rFile = null;
        try {
            rFile = new RandomAccessFile(bodyObj, "r");
            rFile.seek(offset);
            long contentLeft = bodyObj.length() - offset;
            long readContentLength = contentLength;
            if (contentLeft < 0L) {
                readContentLength = (readContentLength += contentLeft) > 0L ? readContentLength : 0L;
            }
            requestBody = new MultiFileuploadRequestBody(contentType, rFile, readContentLength);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QSException(e.getMessage());
        }
        return requestBody;
    }

    public Object getBodyContent(Map bodyContent) throws QSException {
        for (Map.Entry entry : bodyContent.entrySet()) {
            String key = (String)entry.getKey();
            Object bodyObj = bodyContent.get(key);
            if (!"BodyInputFile".equals(key) && !"BodyInputStream".equals(key) && !"BodyInput".equals(key)) continue;
            return bodyObj;
        }
        return QSStringUtil.getMapToJson(bodyContent).toString();
    }
}

