/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.EmptyRequestBody;
import com.qingstor.sdk.request.impl.InputStreamUploadBody;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSNormalRequestBody
implements QSRequestBody {
    private static final Logger log = LoggerFactory.getLogger(QSNormalRequestBody.class);

    @Override
    public RequestBody getRequestBody(String contentType, long contentLength, String method, Map<String, Object> bodyParams, Map<String, Object> queryParams) throws QSException {
        log.debug("----QSNormalRequestBody----");
        MediaType mediaType = MediaType.parse((String)contentType);
        if (bodyParams != null && bodyParams.size() > 0) {
            RequestBody body = null;
            Object bodyObj = QSNormalRequestBody.getBodyContent(bodyParams);
            if (bodyObj instanceof String) {
                body = RequestBody.create((MediaType)mediaType, (byte[])((String)bodyObj).getBytes(StandardCharsets.UTF_8));
            } else if (bodyObj instanceof File) {
                body = RequestBody.create((MediaType)mediaType, (File)((File)bodyObj));
            } else if (bodyObj instanceof InputStream) {
                body = new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength);
            }
            return body;
        }
        if (HttpMethod.permitsRequestBody((String)method)) {
            return new EmptyRequestBody(contentType);
        }
        return null;
    }

    public static Object getBodyContent(Map<String, Object> bodyContent) throws QSException {
        Optional<String> matched = bodyContent.keySet().stream().filter(k -> k.equals("BodyInputFile") || k.equals("BodyInputStream") || k.equals("BodyInput")).findFirst();
        if (matched.isPresent()) {
            return bodyContent.get(matched.get());
        }
        return QSStringUtil.getMapToJson(bodyContent).toString();
    }
}

