/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.service;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.common.OperationContext;
import com.qingstor.sdk.common.auth.Credentials;
import com.qingstor.sdk.config.ClientConfiguration;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSRequest;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Types;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class Bucket {
    private String zone;
    private String bucketName;
    private Credentials cred;
    private ClientConfiguration clientCfg;

    public Bucket(EnvContext envContext, String zone, String bucketName) {
        this.cred = envContext;
        this.clientCfg = ClientConfiguration.from(envContext);
        this.zone = zone;
        this.bucketName = bucketName;
    }

    Bucket(Credentials cred, ClientConfiguration clientCfg, String zone, String bucketName) {
        this.cred = cred;
        this.clientCfg = clientCfg;
        this.zone = zone;
        this.bucketName = bucketName;
    }

    public DeleteBucketOutput delete() throws QSException {
        RequestHandler<DeleteBucketOutput> requestHandler = this.deleteRequest();
        DeleteBucketOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketOutput> deleteRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucket").apiName("DeleteBucket").serviceName("DELETE Bucket").reqMethod("DELETE").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketOutput.class);
        return requestHandler;
    }

    public void deleteAsync(ResponseCallBack<DeleteBucketOutput> callback) throws QSException {
        RequestHandler<DeleteBucketOutput> requestHandler = this.deleteAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketOutput> deleteAsyncRequest(ResponseCallBack<DeleteBucketOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucket").apiName("DeleteBucket").serviceName("DELETE Bucket").reqMethod("DELETE").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketOutput.class);
        return requestHandler;
    }

    public DeleteBucketCNAMEOutput deleteCNAME(DeleteBucketCNAMEInput input) throws QSException {
        RequestHandler<DeleteBucketCNAMEOutput> requestHandler;
        DeleteBucketCNAMEOutput backModel;
        if (input == null) {
            input = new DeleteBucketCNAMEInput();
        }
        if ((backModel = (requestHandler = this.deleteCNAMERequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketCNAMEOutput> deleteCNAMERequest(DeleteBucketCNAMEInput input) throws QSException {
        if (input == null) {
            input = new DeleteBucketCNAMEInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketCNAME").apiName("DeleteBucketCNAME").serviceName("DELETE Bucket CNAME").reqMethod("DELETE").subSourcePath("/<bucket-name>?cname");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketCNAMEOutput> requestHandler = QSRequest.getRequest(builder.build(), input, DeleteBucketCNAMEOutput.class);
        return requestHandler;
    }

    public void deleteCNAMEAsync(DeleteBucketCNAMEInput input, ResponseCallBack<DeleteBucketCNAMEOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteBucketCNAMEInput();
        }
        RequestHandler<DeleteBucketCNAMEOutput> requestHandler = this.deleteCNAMEAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketCNAMEOutput> deleteCNAMEAsyncRequest(DeleteBucketCNAMEInput input, ResponseCallBack<DeleteBucketCNAMEOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteBucketCNAMEInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketCNAME").apiName("DeleteBucketCNAME").serviceName("DELETE Bucket CNAME").reqMethod("DELETE").subSourcePath("/<bucket-name>?cname");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketCNAMEOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, DeleteBucketCNAMEOutput.class);
        return requestHandler;
    }

    public DeleteBucketCORSOutput deleteCORS() throws QSException {
        RequestHandler<DeleteBucketCORSOutput> requestHandler = this.deleteCORSRequest();
        DeleteBucketCORSOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketCORSOutput> deleteCORSRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketCORS").apiName("DeleteBucketCORS").serviceName("DELETE Bucket CORS").reqMethod("DELETE").subSourcePath("/<bucket-name>?cors");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketCORSOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketCORSOutput.class);
        return requestHandler;
    }

    public void deleteCORSAsync(ResponseCallBack<DeleteBucketCORSOutput> callback) throws QSException {
        RequestHandler<DeleteBucketCORSOutput> requestHandler = this.deleteCORSAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketCORSOutput> deleteCORSAsyncRequest(ResponseCallBack<DeleteBucketCORSOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketCORS").apiName("DeleteBucketCORS").serviceName("DELETE Bucket CORS").reqMethod("DELETE").subSourcePath("/<bucket-name>?cors");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketCORSOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketCORSOutput.class);
        return requestHandler;
    }

    public DeleteBucketExternalMirrorOutput deleteExternalMirror() throws QSException {
        RequestHandler<DeleteBucketExternalMirrorOutput> requestHandler = this.deleteExternalMirrorRequest();
        DeleteBucketExternalMirrorOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketExternalMirrorOutput> deleteExternalMirrorRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketExternalMirror").apiName("DeleteBucketExternalMirror").serviceName("DELETE Bucket External Mirror").reqMethod("DELETE").subSourcePath("/<bucket-name>?mirror");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketExternalMirrorOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public void deleteExternalMirrorAsync(ResponseCallBack<DeleteBucketExternalMirrorOutput> callback) throws QSException {
        RequestHandler<DeleteBucketExternalMirrorOutput> requestHandler = this.deleteExternalMirrorAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketExternalMirrorOutput> deleteExternalMirrorAsyncRequest(ResponseCallBack<DeleteBucketExternalMirrorOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketExternalMirror").apiName("DeleteBucketExternalMirror").serviceName("DELETE Bucket External Mirror").reqMethod("DELETE").subSourcePath("/<bucket-name>?mirror");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketExternalMirrorOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public DeleteBucketLifecycleOutput deleteLifecycle() throws QSException {
        RequestHandler<DeleteBucketLifecycleOutput> requestHandler = this.deleteLifecycleRequest();
        DeleteBucketLifecycleOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketLifecycleOutput> deleteLifecycleRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketLifecycle").apiName("DeleteBucketLifecycle").serviceName("DELETE Bucket Lifecycle").reqMethod("DELETE").subSourcePath("/<bucket-name>?lifecycle");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketLifecycleOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketLifecycleOutput.class);
        return requestHandler;
    }

    public void deleteLifecycleAsync(ResponseCallBack<DeleteBucketLifecycleOutput> callback) throws QSException {
        RequestHandler<DeleteBucketLifecycleOutput> requestHandler = this.deleteLifecycleAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketLifecycleOutput> deleteLifecycleAsyncRequest(ResponseCallBack<DeleteBucketLifecycleOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketLifecycle").apiName("DeleteBucketLifecycle").serviceName("DELETE Bucket Lifecycle").reqMethod("DELETE").subSourcePath("/<bucket-name>?lifecycle");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketLifecycleOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketLifecycleOutput.class);
        return requestHandler;
    }

    public DeleteBucketLoggingOutput deleteLogging() throws QSException {
        RequestHandler<DeleteBucketLoggingOutput> requestHandler = this.deleteLoggingRequest();
        DeleteBucketLoggingOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketLoggingOutput> deleteLoggingRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketLogging").apiName("DeleteBucketLogging").serviceName("DELETE Bucket Logging").reqMethod("DELETE").subSourcePath("/<bucket-name>?logging");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketLoggingOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketLoggingOutput.class);
        return requestHandler;
    }

    public void deleteLoggingAsync(ResponseCallBack<DeleteBucketLoggingOutput> callback) throws QSException {
        RequestHandler<DeleteBucketLoggingOutput> requestHandler = this.deleteLoggingAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketLoggingOutput> deleteLoggingAsyncRequest(ResponseCallBack<DeleteBucketLoggingOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketLogging").apiName("DeleteBucketLogging").serviceName("DELETE Bucket Logging").reqMethod("DELETE").subSourcePath("/<bucket-name>?logging");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketLoggingOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketLoggingOutput.class);
        return requestHandler;
    }

    public DeleteBucketNotificationOutput deleteNotification() throws QSException {
        RequestHandler<DeleteBucketNotificationOutput> requestHandler = this.deleteNotificationRequest();
        DeleteBucketNotificationOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketNotificationOutput> deleteNotificationRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketNotification").apiName("DeleteBucketNotification").serviceName("DELETE Bucket Notification").reqMethod("DELETE").subSourcePath("/<bucket-name>?notification");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketNotificationOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketNotificationOutput.class);
        return requestHandler;
    }

    public void deleteNotificationAsync(ResponseCallBack<DeleteBucketNotificationOutput> callback) throws QSException {
        RequestHandler<DeleteBucketNotificationOutput> requestHandler = this.deleteNotificationAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketNotificationOutput> deleteNotificationAsyncRequest(ResponseCallBack<DeleteBucketNotificationOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketNotification").apiName("DeleteBucketNotification").serviceName("DELETE Bucket Notification").reqMethod("DELETE").subSourcePath("/<bucket-name>?notification");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketNotificationOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketNotificationOutput.class);
        return requestHandler;
    }

    public DeleteBucketPolicyOutput deletePolicy() throws QSException {
        RequestHandler<DeleteBucketPolicyOutput> requestHandler = this.deletePolicyRequest();
        DeleteBucketPolicyOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketPolicyOutput> deletePolicyRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketPolicy").apiName("DeleteBucketPolicy").serviceName("DELETE Bucket Policy").reqMethod("DELETE").subSourcePath("/<bucket-name>?policy");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketPolicyOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketPolicyOutput.class);
        return requestHandler;
    }

    public void deletePolicyAsync(ResponseCallBack<DeleteBucketPolicyOutput> callback) throws QSException {
        RequestHandler<DeleteBucketPolicyOutput> requestHandler = this.deletePolicyAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketPolicyOutput> deletePolicyAsyncRequest(ResponseCallBack<DeleteBucketPolicyOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketPolicy").apiName("DeleteBucketPolicy").serviceName("DELETE Bucket Policy").reqMethod("DELETE").subSourcePath("/<bucket-name>?policy");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketPolicyOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketPolicyOutput.class);
        return requestHandler;
    }

    public DeleteBucketReplicationOutput deleteReplication() throws QSException {
        RequestHandler<DeleteBucketReplicationOutput> requestHandler = this.deleteReplicationRequest();
        DeleteBucketReplicationOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteBucketReplicationOutput> deleteReplicationRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketReplication").apiName("DeleteBucketReplication").serviceName("DELETE Bucket Replication").reqMethod("DELETE").subSourcePath("/<bucket-name>?replication");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteBucketReplicationOutput> requestHandler = QSRequest.getRequest(builder.build(), null, DeleteBucketReplicationOutput.class);
        return requestHandler;
    }

    public void deleteReplicationAsync(ResponseCallBack<DeleteBucketReplicationOutput> callback) throws QSException {
        RequestHandler<DeleteBucketReplicationOutput> requestHandler = this.deleteReplicationAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteBucketReplicationOutput> deleteReplicationAsyncRequest(ResponseCallBack<DeleteBucketReplicationOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteBucketReplication").apiName("DeleteBucketReplication").serviceName("DELETE Bucket Replication").reqMethod("DELETE").subSourcePath("/<bucket-name>?replication");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteBucketReplicationOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, DeleteBucketReplicationOutput.class);
        return requestHandler;
    }

    public DeleteMultipleObjectsOutput deleteMultipleObjects(DeleteMultipleObjectsInput input) throws QSException {
        RequestHandler<DeleteMultipleObjectsOutput> requestHandler;
        DeleteMultipleObjectsOutput backModel;
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        if ((backModel = (requestHandler = this.deleteMultipleObjectsRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteMultipleObjectsOutput> deleteMultipleObjectsRequest(DeleteMultipleObjectsInput input) throws QSException {
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteMultipleObjects").apiName("DeleteMultipleObjects").serviceName("Delete Multiple Objects").reqMethod("POST").subSourcePath("/<bucket-name>?delete");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<DeleteMultipleObjectsOutput> requestHandler = QSRequest.getRequest(builder.build(), input, DeleteMultipleObjectsOutput.class);
        return requestHandler;
    }

    public void deleteMultipleObjectsAsync(DeleteMultipleObjectsInput input, ResponseCallBack<DeleteMultipleObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        RequestHandler<DeleteMultipleObjectsOutput> requestHandler = this.deleteMultipleObjectsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteMultipleObjectsOutput> deleteMultipleObjectsAsyncRequest(DeleteMultipleObjectsInput input, ResponseCallBack<DeleteMultipleObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteMultipleObjects").apiName("DeleteMultipleObjects").serviceName("Delete Multiple Objects").reqMethod("POST").subSourcePath("/<bucket-name>?delete");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteMultipleObjectsOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, DeleteMultipleObjectsOutput.class);
        return requestHandler;
    }

    public GetBucketACLOutput getACL() throws QSException {
        RequestHandler<GetBucketACLOutput> requestHandler = this.getACLRequest();
        GetBucketACLOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketACLOutput> getACLRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketACL").apiName("GetBucketACL").serviceName("GET Bucket ACL").reqMethod("GET").subSourcePath("/<bucket-name>?acl");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketACLOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketACLOutput.class);
        return requestHandler;
    }

    public void getACLAsync(ResponseCallBack<GetBucketACLOutput> callback) throws QSException {
        RequestHandler<GetBucketACLOutput> requestHandler = this.getACLAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketACLOutput> getACLAsyncRequest(ResponseCallBack<GetBucketACLOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketACL").apiName("GetBucketACL").serviceName("GET Bucket ACL").reqMethod("GET").subSourcePath("/<bucket-name>?acl");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketACLOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketACLOutput.class);
        return requestHandler;
    }

    public GetBucketCNAMEOutput getCNAME(GetBucketCNAMEInput input) throws QSException {
        RequestHandler<GetBucketCNAMEOutput> requestHandler;
        GetBucketCNAMEOutput backModel;
        if (input == null) {
            input = new GetBucketCNAMEInput();
        }
        if ((backModel = (requestHandler = this.getCNAMERequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketCNAMEOutput> getCNAMERequest(GetBucketCNAMEInput input) throws QSException {
        if (input == null) {
            input = new GetBucketCNAMEInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketCNAME").apiName("GetBucketCNAME").serviceName("GET Bucket CNAME").reqMethod("GET").subSourcePath("/<bucket-name>?cname");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketCNAMEOutput> requestHandler = QSRequest.getRequest(builder.build(), input, GetBucketCNAMEOutput.class);
        return requestHandler;
    }

    public void getCNAMEAsync(GetBucketCNAMEInput input, ResponseCallBack<GetBucketCNAMEOutput> callback) throws QSException {
        if (input == null) {
            input = new GetBucketCNAMEInput();
        }
        RequestHandler<GetBucketCNAMEOutput> requestHandler = this.getCNAMEAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketCNAMEOutput> getCNAMEAsyncRequest(GetBucketCNAMEInput input, ResponseCallBack<GetBucketCNAMEOutput> callback) throws QSException {
        if (input == null) {
            input = new GetBucketCNAMEInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketCNAME").apiName("GetBucketCNAME").serviceName("GET Bucket CNAME").reqMethod("GET").subSourcePath("/<bucket-name>?cname");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketCNAMEOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, GetBucketCNAMEOutput.class);
        return requestHandler;
    }

    public GetBucketCORSOutput getCORS() throws QSException {
        RequestHandler<GetBucketCORSOutput> requestHandler = this.getCORSRequest();
        GetBucketCORSOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketCORSOutput> getCORSRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketCORS").apiName("GetBucketCORS").serviceName("GET Bucket CORS").reqMethod("GET").subSourcePath("/<bucket-name>?cors");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketCORSOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketCORSOutput.class);
        return requestHandler;
    }

    public void getCORSAsync(ResponseCallBack<GetBucketCORSOutput> callback) throws QSException {
        RequestHandler<GetBucketCORSOutput> requestHandler = this.getCORSAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketCORSOutput> getCORSAsyncRequest(ResponseCallBack<GetBucketCORSOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketCORS").apiName("GetBucketCORS").serviceName("GET Bucket CORS").reqMethod("GET").subSourcePath("/<bucket-name>?cors");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketCORSOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketCORSOutput.class);
        return requestHandler;
    }

    public GetBucketExternalMirrorOutput getExternalMirror() throws QSException {
        RequestHandler<GetBucketExternalMirrorOutput> requestHandler = this.getExternalMirrorRequest();
        GetBucketExternalMirrorOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketExternalMirrorOutput> getExternalMirrorRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketExternalMirror").apiName("GetBucketExternalMirror").serviceName("GET Bucket External Mirror").reqMethod("GET").subSourcePath("/<bucket-name>?mirror");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketExternalMirrorOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public void getExternalMirrorAsync(ResponseCallBack<GetBucketExternalMirrorOutput> callback) throws QSException {
        RequestHandler<GetBucketExternalMirrorOutput> requestHandler = this.getExternalMirrorAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketExternalMirrorOutput> getExternalMirrorAsyncRequest(ResponseCallBack<GetBucketExternalMirrorOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketExternalMirror").apiName("GetBucketExternalMirror").serviceName("GET Bucket External Mirror").reqMethod("GET").subSourcePath("/<bucket-name>?mirror");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketExternalMirrorOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public GetBucketLifecycleOutput getLifecycle() throws QSException {
        RequestHandler<GetBucketLifecycleOutput> requestHandler = this.getLifecycleRequest();
        GetBucketLifecycleOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketLifecycleOutput> getLifecycleRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketLifecycle").apiName("GetBucketLifecycle").serviceName("GET Bucket Lifecycle").reqMethod("GET").subSourcePath("/<bucket-name>?lifecycle");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketLifecycleOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketLifecycleOutput.class);
        return requestHandler;
    }

    public void getLifecycleAsync(ResponseCallBack<GetBucketLifecycleOutput> callback) throws QSException {
        RequestHandler<GetBucketLifecycleOutput> requestHandler = this.getLifecycleAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketLifecycleOutput> getLifecycleAsyncRequest(ResponseCallBack<GetBucketLifecycleOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketLifecycle").apiName("GetBucketLifecycle").serviceName("GET Bucket Lifecycle").reqMethod("GET").subSourcePath("/<bucket-name>?lifecycle");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketLifecycleOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketLifecycleOutput.class);
        return requestHandler;
    }

    public GetBucketLoggingOutput getLogging() throws QSException {
        RequestHandler<GetBucketLoggingOutput> requestHandler = this.getLoggingRequest();
        GetBucketLoggingOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketLoggingOutput> getLoggingRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketLogging").apiName("GetBucketLogging").serviceName("GET Bucket Logging").reqMethod("GET").subSourcePath("/<bucket-name>?logging");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketLoggingOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketLoggingOutput.class);
        return requestHandler;
    }

    public void getLoggingAsync(ResponseCallBack<GetBucketLoggingOutput> callback) throws QSException {
        RequestHandler<GetBucketLoggingOutput> requestHandler = this.getLoggingAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketLoggingOutput> getLoggingAsyncRequest(ResponseCallBack<GetBucketLoggingOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketLogging").apiName("GetBucketLogging").serviceName("GET Bucket Logging").reqMethod("GET").subSourcePath("/<bucket-name>?logging");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketLoggingOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketLoggingOutput.class);
        return requestHandler;
    }

    public GetBucketNotificationOutput getNotification() throws QSException {
        RequestHandler<GetBucketNotificationOutput> requestHandler = this.getNotificationRequest();
        GetBucketNotificationOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketNotificationOutput> getNotificationRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketNotification").apiName("GetBucketNotification").serviceName("GET Bucket Notification").reqMethod("GET").subSourcePath("/<bucket-name>?notification");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketNotificationOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketNotificationOutput.class);
        return requestHandler;
    }

    public void getNotificationAsync(ResponseCallBack<GetBucketNotificationOutput> callback) throws QSException {
        RequestHandler<GetBucketNotificationOutput> requestHandler = this.getNotificationAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketNotificationOutput> getNotificationAsyncRequest(ResponseCallBack<GetBucketNotificationOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketNotification").apiName("GetBucketNotification").serviceName("GET Bucket Notification").reqMethod("GET").subSourcePath("/<bucket-name>?notification");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketNotificationOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketNotificationOutput.class);
        return requestHandler;
    }

    public GetBucketPolicyOutput getPolicy() throws QSException {
        RequestHandler<GetBucketPolicyOutput> requestHandler = this.getPolicyRequest();
        GetBucketPolicyOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketPolicyOutput> getPolicyRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketPolicy").apiName("GetBucketPolicy").serviceName("GET Bucket Policy").reqMethod("GET").subSourcePath("/<bucket-name>?policy");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketPolicyOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketPolicyOutput.class);
        return requestHandler;
    }

    public void getPolicyAsync(ResponseCallBack<GetBucketPolicyOutput> callback) throws QSException {
        RequestHandler<GetBucketPolicyOutput> requestHandler = this.getPolicyAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketPolicyOutput> getPolicyAsyncRequest(ResponseCallBack<GetBucketPolicyOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketPolicy").apiName("GetBucketPolicy").serviceName("GET Bucket Policy").reqMethod("GET").subSourcePath("/<bucket-name>?policy");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketPolicyOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketPolicyOutput.class);
        return requestHandler;
    }

    public GetBucketReplicationOutput getReplication() throws QSException {
        RequestHandler<GetBucketReplicationOutput> requestHandler = this.getReplicationRequest();
        GetBucketReplicationOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketReplicationOutput> getReplicationRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketReplication").apiName("GetBucketReplication").serviceName("GET Bucket Replication").reqMethod("GET").subSourcePath("/<bucket-name>?replication");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketReplicationOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketReplicationOutput.class);
        return requestHandler;
    }

    public void getReplicationAsync(ResponseCallBack<GetBucketReplicationOutput> callback) throws QSException {
        RequestHandler<GetBucketReplicationOutput> requestHandler = this.getReplicationAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketReplicationOutput> getReplicationAsyncRequest(ResponseCallBack<GetBucketReplicationOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketReplication").apiName("GetBucketReplication").serviceName("GET Bucket Replication").reqMethod("GET").subSourcePath("/<bucket-name>?replication");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketReplicationOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketReplicationOutput.class);
        return requestHandler;
    }

    public GetBucketStatisticsOutput getStatistics() throws QSException {
        RequestHandler<GetBucketStatisticsOutput> requestHandler = this.getStatisticsRequest();
        GetBucketStatisticsOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketStatisticsOutput> getStatisticsRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketStatistics").apiName("GetBucketStatistics").serviceName("GET Bucket Statistics").reqMethod("GET").subSourcePath("/<bucket-name>?stats");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketStatisticsOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketStatisticsOutput.class);
        return requestHandler;
    }

    public void getStatisticsAsync(ResponseCallBack<GetBucketStatisticsOutput> callback) throws QSException {
        RequestHandler<GetBucketStatisticsOutput> requestHandler = this.getStatisticsAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketStatisticsOutput> getStatisticsAsyncRequest(ResponseCallBack<GetBucketStatisticsOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketStatistics").apiName("GetBucketStatistics").serviceName("GET Bucket Statistics").reqMethod("GET").subSourcePath("/<bucket-name>?stats");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketStatisticsOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketStatisticsOutput.class);
        return requestHandler;
    }

    public GetBucketVersioningOutput getVersioning() throws QSException {
        RequestHandler<GetBucketVersioningOutput> requestHandler = this.getVersioningRequest();
        GetBucketVersioningOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetBucketVersioningOutput> getVersioningRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketVersioning").apiName("GetBucketVersioning").serviceName("GET Bucket Versioning").reqMethod("GET").subSourcePath("/<bucket-name>?versioning");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<GetBucketVersioningOutput> requestHandler = QSRequest.getRequest(builder.build(), null, GetBucketVersioningOutput.class);
        return requestHandler;
    }

    public void getVersioningAsync(ResponseCallBack<GetBucketVersioningOutput> callback) throws QSException {
        RequestHandler<GetBucketVersioningOutput> requestHandler = this.getVersioningAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetBucketVersioningOutput> getVersioningAsyncRequest(ResponseCallBack<GetBucketVersioningOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetBucketVersioning").apiName("GetBucketVersioning").serviceName("GET Bucket Versioning").reqMethod("GET").subSourcePath("/<bucket-name>?versioning");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetBucketVersioningOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, GetBucketVersioningOutput.class);
        return requestHandler;
    }

    public HeadBucketOutput head() throws QSException {
        RequestHandler<HeadBucketOutput> requestHandler = this.headRequest();
        HeadBucketOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<HeadBucketOutput> headRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("HeadBucket").apiName("HeadBucket").serviceName("HEAD Bucket").reqMethod("HEAD").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<HeadBucketOutput> requestHandler = QSRequest.getRequest(builder.build(), null, HeadBucketOutput.class);
        return requestHandler;
    }

    public void headAsync(ResponseCallBack<HeadBucketOutput> callback) throws QSException {
        RequestHandler<HeadBucketOutput> requestHandler = this.headAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<HeadBucketOutput> headAsyncRequest(ResponseCallBack<HeadBucketOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("HeadBucket").apiName("HeadBucket").serviceName("HEAD Bucket").reqMethod("HEAD").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<HeadBucketOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, HeadBucketOutput.class);
        return requestHandler;
    }

    public ListMultipartUploadsOutput listMultipartUploads(ListMultipartUploadsInput input) throws QSException {
        RequestHandler<ListMultipartUploadsOutput> requestHandler;
        ListMultipartUploadsOutput backModel;
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        if ((backModel = (requestHandler = this.listMultipartUploadsRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<ListMultipartUploadsOutput> listMultipartUploadsRequest(ListMultipartUploadsInput input) throws QSException {
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListMultipartUploads").apiName("ListMultipartUploads").serviceName("List Multipart Uploads").reqMethod("GET").subSourcePath("/<bucket-name>?uploads");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<ListMultipartUploadsOutput> requestHandler = QSRequest.getRequest(builder.build(), input, ListMultipartUploadsOutput.class);
        return requestHandler;
    }

    public void listMultipartUploadsAsync(ListMultipartUploadsInput input, ResponseCallBack<ListMultipartUploadsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        RequestHandler<ListMultipartUploadsOutput> requestHandler = this.listMultipartUploadsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<ListMultipartUploadsOutput> listMultipartUploadsAsyncRequest(ListMultipartUploadsInput input, ResponseCallBack<ListMultipartUploadsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListMultipartUploads").apiName("ListMultipartUploads").serviceName("List Multipart Uploads").reqMethod("GET").subSourcePath("/<bucket-name>?uploads");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<ListMultipartUploadsOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, ListMultipartUploadsOutput.class);
        return requestHandler;
    }

    public ListObjectVersionsOutput listObjectVersions(ListObjectVersionsInput input) throws QSException {
        RequestHandler<ListObjectVersionsOutput> requestHandler;
        ListObjectVersionsOutput backModel;
        if (input == null) {
            input = new ListObjectVersionsInput();
        }
        if ((backModel = (requestHandler = this.listObjectVersionsRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<ListObjectVersionsOutput> listObjectVersionsRequest(ListObjectVersionsInput input) throws QSException {
        if (input == null) {
            input = new ListObjectVersionsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListObjectVersions").apiName("ListObjectVersions").serviceName("List Object Versions").reqMethod("GET").subSourcePath("/<bucket-name>?versions");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<ListObjectVersionsOutput> requestHandler = QSRequest.getRequest(builder.build(), input, ListObjectVersionsOutput.class);
        return requestHandler;
    }

    public void listObjectVersionsAsync(ListObjectVersionsInput input, ResponseCallBack<ListObjectVersionsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListObjectVersionsInput();
        }
        RequestHandler<ListObjectVersionsOutput> requestHandler = this.listObjectVersionsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<ListObjectVersionsOutput> listObjectVersionsAsyncRequest(ListObjectVersionsInput input, ResponseCallBack<ListObjectVersionsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListObjectVersionsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListObjectVersions").apiName("ListObjectVersions").serviceName("List Object Versions").reqMethod("GET").subSourcePath("/<bucket-name>?versions");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<ListObjectVersionsOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, ListObjectVersionsOutput.class);
        return requestHandler;
    }

    public ListObjectsOutput listObjects(ListObjectsInput input) throws QSException {
        RequestHandler<ListObjectsOutput> requestHandler;
        ListObjectsOutput backModel;
        if (input == null) {
            input = new ListObjectsInput();
        }
        if ((backModel = (requestHandler = this.listObjectsRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<ListObjectsOutput> listObjectsRequest(ListObjectsInput input) throws QSException {
        if (input == null) {
            input = new ListObjectsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListObjects").apiName("ListObjects").serviceName("GET Bucket (List Objects)").reqMethod("GET").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<ListObjectsOutput> requestHandler = QSRequest.getRequest(builder.build(), input, ListObjectsOutput.class);
        return requestHandler;
    }

    public void listObjectsAsync(ListObjectsInput input, ResponseCallBack<ListObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListObjectsInput();
        }
        RequestHandler<ListObjectsOutput> requestHandler = this.listObjectsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<ListObjectsOutput> listObjectsAsyncRequest(ListObjectsInput input, ResponseCallBack<ListObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListObjectsInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListObjects").apiName("ListObjects").serviceName("GET Bucket (List Objects)").reqMethod("GET").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<ListObjectsOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, ListObjectsOutput.class);
        return requestHandler;
    }

    public PutBucketOutput put() throws QSException {
        RequestHandler<PutBucketOutput> requestHandler = this.putRequest();
        PutBucketOutput backModel = requestHandler.send();
        if (backModel != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketOutput> putRequest() throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucket").apiName("PutBucket").serviceName("PUT Bucket").reqMethod("PUT").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketOutput> requestHandler = QSRequest.getRequest(builder.build(), null, PutBucketOutput.class);
        return requestHandler;
    }

    public void putAsync(ResponseCallBack<PutBucketOutput> callback) throws QSException {
        RequestHandler<PutBucketOutput> requestHandler = this.putAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketOutput> putAsyncRequest(ResponseCallBack<PutBucketOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucket").apiName("PutBucket").serviceName("PUT Bucket").reqMethod("PUT").subSourcePath("/<bucket-name>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), null, callback, PutBucketOutput.class);
        return requestHandler;
    }

    public PutBucketACLOutput putACL(PutBucketACLInput input) throws QSException {
        RequestHandler<PutBucketACLOutput> requestHandler;
        PutBucketACLOutput backModel;
        if (input == null) {
            input = new PutBucketACLInput();
        }
        if ((backModel = (requestHandler = this.putACLRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketACLOutput> putACLRequest(PutBucketACLInput input) throws QSException {
        if (input == null) {
            input = new PutBucketACLInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketACL").apiName("PutBucketACL").serviceName("PUT Bucket ACL").reqMethod("PUT").subSourcePath("/<bucket-name>?acl");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketACLOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketACLOutput.class);
        return requestHandler;
    }

    public void putACLAsync(PutBucketACLInput input, ResponseCallBack<PutBucketACLOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketACLInput();
        }
        RequestHandler<PutBucketACLOutput> requestHandler = this.putACLAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketACLOutput> putACLAsyncRequest(PutBucketACLInput input, ResponseCallBack<PutBucketACLOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketACLInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketACL").apiName("PutBucketACL").serviceName("PUT Bucket ACL").reqMethod("PUT").subSourcePath("/<bucket-name>?acl");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketACLOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketACLOutput.class);
        return requestHandler;
    }

    public PutBucketCNAMEOutput putCNAME(PutBucketCNAMEInput input) throws QSException {
        RequestHandler<PutBucketCNAMEOutput> requestHandler;
        PutBucketCNAMEOutput backModel;
        if (input == null) {
            input = new PutBucketCNAMEInput();
        }
        if ((backModel = (requestHandler = this.putCNAMERequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketCNAMEOutput> putCNAMERequest(PutBucketCNAMEInput input) throws QSException {
        if (input == null) {
            input = new PutBucketCNAMEInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketCNAME").apiName("PutBucketCNAME").serviceName("PUT Bucket CNAME").reqMethod("PUT").subSourcePath("/<bucket-name>?cname");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketCNAMEOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketCNAMEOutput.class);
        return requestHandler;
    }

    public void putCNAMEAsync(PutBucketCNAMEInput input, ResponseCallBack<PutBucketCNAMEOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketCNAMEInput();
        }
        RequestHandler<PutBucketCNAMEOutput> requestHandler = this.putCNAMEAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketCNAMEOutput> putCNAMEAsyncRequest(PutBucketCNAMEInput input, ResponseCallBack<PutBucketCNAMEOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketCNAMEInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketCNAME").apiName("PutBucketCNAME").serviceName("PUT Bucket CNAME").reqMethod("PUT").subSourcePath("/<bucket-name>?cname");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketCNAMEOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketCNAMEOutput.class);
        return requestHandler;
    }

    public PutBucketCORSOutput putCORS(PutBucketCORSInput input) throws QSException {
        RequestHandler<PutBucketCORSOutput> requestHandler;
        PutBucketCORSOutput backModel;
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        if ((backModel = (requestHandler = this.putCORSRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketCORSOutput> putCORSRequest(PutBucketCORSInput input) throws QSException {
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketCORS").apiName("PutBucketCORS").serviceName("PUT Bucket CORS").reqMethod("PUT").subSourcePath("/<bucket-name>?cors");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketCORSOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketCORSOutput.class);
        return requestHandler;
    }

    public void putCORSAsync(PutBucketCORSInput input, ResponseCallBack<PutBucketCORSOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        RequestHandler<PutBucketCORSOutput> requestHandler = this.putCORSAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketCORSOutput> putCORSAsyncRequest(PutBucketCORSInput input, ResponseCallBack<PutBucketCORSOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketCORS").apiName("PutBucketCORS").serviceName("PUT Bucket CORS").reqMethod("PUT").subSourcePath("/<bucket-name>?cors");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketCORSOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketCORSOutput.class);
        return requestHandler;
    }

    public PutBucketExternalMirrorOutput putExternalMirror(PutBucketExternalMirrorInput input) throws QSException {
        RequestHandler<PutBucketExternalMirrorOutput> requestHandler;
        PutBucketExternalMirrorOutput backModel;
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        if ((backModel = (requestHandler = this.putExternalMirrorRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketExternalMirrorOutput> putExternalMirrorRequest(PutBucketExternalMirrorInput input) throws QSException {
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketExternalMirror").apiName("PutBucketExternalMirror").serviceName("PUT Bucket External Mirror").reqMethod("PUT").subSourcePath("/<bucket-name>?mirror");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketExternalMirrorOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public void putExternalMirrorAsync(PutBucketExternalMirrorInput input, ResponseCallBack<PutBucketExternalMirrorOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        RequestHandler<PutBucketExternalMirrorOutput> requestHandler = this.putExternalMirrorAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketExternalMirrorOutput> putExternalMirrorAsyncRequest(PutBucketExternalMirrorInput input, ResponseCallBack<PutBucketExternalMirrorOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketExternalMirror").apiName("PutBucketExternalMirror").serviceName("PUT Bucket External Mirror").reqMethod("PUT").subSourcePath("/<bucket-name>?mirror");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketExternalMirrorOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public PutBucketLifecycleOutput putLifecycle(PutBucketLifecycleInput input) throws QSException {
        RequestHandler<PutBucketLifecycleOutput> requestHandler;
        PutBucketLifecycleOutput backModel;
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        if ((backModel = (requestHandler = this.putLifecycleRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketLifecycleOutput> putLifecycleRequest(PutBucketLifecycleInput input) throws QSException {
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketLifecycle").apiName("PutBucketLifecycle").serviceName("PUT Bucket Lifecycle").reqMethod("PUT").subSourcePath("/<bucket-name>?lifecycle");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketLifecycleOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketLifecycleOutput.class);
        return requestHandler;
    }

    public void putLifecycleAsync(PutBucketLifecycleInput input, ResponseCallBack<PutBucketLifecycleOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        RequestHandler<PutBucketLifecycleOutput> requestHandler = this.putLifecycleAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketLifecycleOutput> putLifecycleAsyncRequest(PutBucketLifecycleInput input, ResponseCallBack<PutBucketLifecycleOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketLifecycle").apiName("PutBucketLifecycle").serviceName("PUT Bucket Lifecycle").reqMethod("PUT").subSourcePath("/<bucket-name>?lifecycle");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketLifecycleOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketLifecycleOutput.class);
        return requestHandler;
    }

    public PutBucketLoggingOutput putLogging(PutBucketLoggingInput input) throws QSException {
        RequestHandler<PutBucketLoggingOutput> requestHandler;
        PutBucketLoggingOutput backModel;
        if (input == null) {
            input = new PutBucketLoggingInput();
        }
        if ((backModel = (requestHandler = this.putLoggingRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketLoggingOutput> putLoggingRequest(PutBucketLoggingInput input) throws QSException {
        if (input == null) {
            input = new PutBucketLoggingInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketLogging").apiName("PutBucketLogging").serviceName("PUT Bucket Logging").reqMethod("PUT").subSourcePath("/<bucket-name>?logging");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketLoggingOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketLoggingOutput.class);
        return requestHandler;
    }

    public void putLoggingAsync(PutBucketLoggingInput input, ResponseCallBack<PutBucketLoggingOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketLoggingInput();
        }
        RequestHandler<PutBucketLoggingOutput> requestHandler = this.putLoggingAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketLoggingOutput> putLoggingAsyncRequest(PutBucketLoggingInput input, ResponseCallBack<PutBucketLoggingOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketLoggingInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketLogging").apiName("PutBucketLogging").serviceName("PUT Bucket Logging").reqMethod("PUT").subSourcePath("/<bucket-name>?logging");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketLoggingOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketLoggingOutput.class);
        return requestHandler;
    }

    public PutBucketNotificationOutput putNotification(PutBucketNotificationInput input) throws QSException {
        RequestHandler<PutBucketNotificationOutput> requestHandler;
        PutBucketNotificationOutput backModel;
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        if ((backModel = (requestHandler = this.putNotificationRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketNotificationOutput> putNotificationRequest(PutBucketNotificationInput input) throws QSException {
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketNotification").apiName("PutBucketNotification").serviceName("PUT Bucket Notification").reqMethod("PUT").subSourcePath("/<bucket-name>?notification");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketNotificationOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketNotificationOutput.class);
        return requestHandler;
    }

    public void putNotificationAsync(PutBucketNotificationInput input, ResponseCallBack<PutBucketNotificationOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        RequestHandler<PutBucketNotificationOutput> requestHandler = this.putNotificationAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketNotificationOutput> putNotificationAsyncRequest(PutBucketNotificationInput input, ResponseCallBack<PutBucketNotificationOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketNotification").apiName("PutBucketNotification").serviceName("PUT Bucket Notification").reqMethod("PUT").subSourcePath("/<bucket-name>?notification");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketNotificationOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketNotificationOutput.class);
        return requestHandler;
    }

    public PutBucketPolicyOutput putPolicy(PutBucketPolicyInput input) throws QSException {
        RequestHandler<PutBucketPolicyOutput> requestHandler;
        PutBucketPolicyOutput backModel;
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        if ((backModel = (requestHandler = this.putPolicyRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketPolicyOutput> putPolicyRequest(PutBucketPolicyInput input) throws QSException {
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketPolicy").apiName("PutBucketPolicy").serviceName("PUT Bucket Policy").reqMethod("PUT").subSourcePath("/<bucket-name>?policy");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketPolicyOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketPolicyOutput.class);
        return requestHandler;
    }

    public void putPolicyAsync(PutBucketPolicyInput input, ResponseCallBack<PutBucketPolicyOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        RequestHandler<PutBucketPolicyOutput> requestHandler = this.putPolicyAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketPolicyOutput> putPolicyAsyncRequest(PutBucketPolicyInput input, ResponseCallBack<PutBucketPolicyOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketPolicy").apiName("PutBucketPolicy").serviceName("PUT Bucket Policy").reqMethod("PUT").subSourcePath("/<bucket-name>?policy");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketPolicyOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketPolicyOutput.class);
        return requestHandler;
    }

    public PutBucketReplicationOutput putReplication(PutBucketReplicationInput input) throws QSException {
        RequestHandler<PutBucketReplicationOutput> requestHandler;
        PutBucketReplicationOutput backModel;
        if (input == null) {
            input = new PutBucketReplicationInput();
        }
        if ((backModel = (requestHandler = this.putReplicationRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketReplicationOutput> putReplicationRequest(PutBucketReplicationInput input) throws QSException {
        if (input == null) {
            input = new PutBucketReplicationInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketReplication").apiName("PutBucketReplication").serviceName("PUT Bucket Replication").reqMethod("PUT").subSourcePath("/<bucket-name>?replication");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketReplicationOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketReplicationOutput.class);
        return requestHandler;
    }

    public void putReplicationAsync(PutBucketReplicationInput input, ResponseCallBack<PutBucketReplicationOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketReplicationInput();
        }
        RequestHandler<PutBucketReplicationOutput> requestHandler = this.putReplicationAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketReplicationOutput> putReplicationAsyncRequest(PutBucketReplicationInput input, ResponseCallBack<PutBucketReplicationOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketReplicationInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketReplication").apiName("PutBucketReplication").serviceName("PUT Bucket Replication").reqMethod("PUT").subSourcePath("/<bucket-name>?replication");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketReplicationOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketReplicationOutput.class);
        return requestHandler;
    }

    public PutBucketVersioningOutput putVersioning(PutBucketVersioningInput input) throws QSException {
        RequestHandler<PutBucketVersioningOutput> requestHandler;
        PutBucketVersioningOutput backModel;
        if (input == null) {
            input = new PutBucketVersioningInput();
        }
        if ((backModel = (requestHandler = this.putVersioningRequest(input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutBucketVersioningOutput> putVersioningRequest(PutBucketVersioningInput input) throws QSException {
        if (input == null) {
            input = new PutBucketVersioningInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketVersioning").apiName("PutBucketVersioning").serviceName("PUT Bucket Versioning").reqMethod("PUT").subSourcePath("/<bucket-name>?versioning");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler<PutBucketVersioningOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutBucketVersioningOutput.class);
        return requestHandler;
    }

    public void putVersioningAsync(PutBucketVersioningInput input, ResponseCallBack<PutBucketVersioningOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketVersioningInput();
        }
        RequestHandler<PutBucketVersioningOutput> requestHandler = this.putVersioningAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutBucketVersioningOutput> putVersioningAsyncRequest(PutBucketVersioningInput input, ResponseCallBack<PutBucketVersioningOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketVersioningInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutBucketVersioning").apiName("PutBucketVersioning").serviceName("PUT Bucket Versioning").reqMethod("PUT").subSourcePath("/<bucket-name>?versioning");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutBucketVersioningOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutBucketVersioningOutput.class);
        return requestHandler;
    }

    public AbortMultipartUploadOutput abortMultipartUpload(String objectName, AbortMultipartUploadInput input) throws QSException {
        RequestHandler<AbortMultipartUploadOutput> requestHandler;
        AbortMultipartUploadOutput backModel;
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        if ((backModel = (requestHandler = this.abortMultipartUploadRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<AbortMultipartUploadOutput> abortMultipartUploadRequest(String objectName, AbortMultipartUploadInput input) throws QSException {
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("AbortMultipartUpload").apiName("AbortMultipartUpload").serviceName("Abort Multipart Upload").reqMethod("DELETE").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<AbortMultipartUploadOutput> requestHandler = QSRequest.getRequest(builder.build(), input, AbortMultipartUploadOutput.class);
        return requestHandler;
    }

    public void abortMultipartUploadAsync(String objectName, AbortMultipartUploadInput input, ResponseCallBack<AbortMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        RequestHandler<AbortMultipartUploadOutput> requestHandler = this.abortMultipartUploadAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<AbortMultipartUploadOutput> abortMultipartUploadAsyncRequest(String objectName, AbortMultipartUploadInput input, ResponseCallBack<AbortMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("AbortMultipartUpload").apiName("AbortMultipartUpload").serviceName("Abort Multipart Upload").reqMethod("DELETE").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<AbortMultipartUploadOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, AbortMultipartUploadOutput.class);
        return requestHandler;
    }

    public AppendObjectOutput appendObject(String objectName, AppendObjectInput input) throws QSException {
        RequestHandler<AppendObjectOutput> requestHandler;
        AppendObjectOutput backModel;
        if (input == null) {
            input = new AppendObjectInput();
        }
        if ((backModel = (requestHandler = this.appendObjectRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<AppendObjectOutput> appendObjectRequest(String objectName, AppendObjectInput input) throws QSException {
        if (input == null) {
            input = new AppendObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("AppendObject").apiName("AppendObject").serviceName("Append Object").reqMethod("POST").subSourcePath("/<bucket-name>/<object-key>?append");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<AppendObjectOutput> requestHandler = QSRequest.getRequest(builder.build(), input, AppendObjectOutput.class);
        return requestHandler;
    }

    public void appendObjectAsync(String objectName, AppendObjectInput input, ResponseCallBack<AppendObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new AppendObjectInput();
        }
        RequestHandler<AppendObjectOutput> requestHandler = this.appendObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<AppendObjectOutput> appendObjectAsyncRequest(String objectName, AppendObjectInput input, ResponseCallBack<AppendObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new AppendObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("AppendObject").apiName("AppendObject").serviceName("Append Object").reqMethod("POST").subSourcePath("/<bucket-name>/<object-key>?append");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<AppendObjectOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, AppendObjectOutput.class);
        return requestHandler;
    }

    public CompleteMultipartUploadOutput completeMultipartUpload(String objectName, CompleteMultipartUploadInput input) throws QSException {
        RequestHandler<CompleteMultipartUploadOutput> requestHandler;
        CompleteMultipartUploadOutput backModel;
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        if ((backModel = (requestHandler = this.completeMultipartUploadRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<CompleteMultipartUploadOutput> completeMultipartUploadRequest(String objectName, CompleteMultipartUploadInput input) throws QSException {
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("CompleteMultipartUpload").apiName("CompleteMultipartUpload").serviceName("Complete multipart upload").reqMethod("POST").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<CompleteMultipartUploadOutput> requestHandler = QSRequest.getRequest(builder.build(), input, CompleteMultipartUploadOutput.class);
        return requestHandler;
    }

    public void completeMultipartUploadAsync(String objectName, CompleteMultipartUploadInput input, ResponseCallBack<CompleteMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        RequestHandler<CompleteMultipartUploadOutput> requestHandler = this.completeMultipartUploadAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<CompleteMultipartUploadOutput> completeMultipartUploadAsyncRequest(String objectName, CompleteMultipartUploadInput input, ResponseCallBack<CompleteMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("CompleteMultipartUpload").apiName("CompleteMultipartUpload").serviceName("Complete multipart upload").reqMethod("POST").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<CompleteMultipartUploadOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, CompleteMultipartUploadOutput.class);
        return requestHandler;
    }

    public DeleteObjectOutput deleteObject(String objectName, DeleteObjectInput input) throws QSException {
        RequestHandler<DeleteObjectOutput> requestHandler;
        DeleteObjectOutput backModel;
        if (input == null) {
            input = new DeleteObjectInput();
        }
        if ((backModel = (requestHandler = this.deleteObjectRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<DeleteObjectOutput> deleteObjectRequest(String objectName, DeleteObjectInput input) throws QSException {
        if (input == null) {
            input = new DeleteObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteObject").apiName("DeleteObject").serviceName("DELETE Object").reqMethod("DELETE").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<DeleteObjectOutput> requestHandler = QSRequest.getRequest(builder.build(), input, DeleteObjectOutput.class);
        return requestHandler;
    }

    public void deleteObjectAsync(String objectName, DeleteObjectInput input, ResponseCallBack<DeleteObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteObjectInput();
        }
        RequestHandler<DeleteObjectOutput> requestHandler = this.deleteObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<DeleteObjectOutput> deleteObjectAsyncRequest(String objectName, DeleteObjectInput input, ResponseCallBack<DeleteObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("DeleteObject").apiName("DeleteObject").serviceName("DELETE Object").reqMethod("DELETE").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<DeleteObjectOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, DeleteObjectOutput.class);
        return requestHandler;
    }

    public GetObjectOutput getObject(String objectName, GetObjectInput input) throws QSException {
        RequestHandler<GetObjectOutput> requestHandler;
        GetObjectOutput backModel;
        if (input == null) {
            input = new GetObjectInput();
        }
        if ((backModel = (requestHandler = this.getObjectRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<GetObjectOutput> getObjectRequest(String objectName, GetObjectInput input) throws QSException {
        if (input == null) {
            input = new GetObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetObject").apiName("GetObject").serviceName("GET Object").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<GetObjectOutput> requestHandler = QSRequest.getRequest(builder.build(), input, GetObjectOutput.class);
        return requestHandler;
    }

    public void getObjectAsync(String objectName, GetObjectInput input, ResponseCallBack<GetObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new GetObjectInput();
        }
        RequestHandler<GetObjectOutput> requestHandler = this.getObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<GetObjectOutput> getObjectAsyncRequest(String objectName, GetObjectInput input, ResponseCallBack<GetObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new GetObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetObject").apiName("GetObject").serviceName("GET Object").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<GetObjectOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, GetObjectOutput.class);
        return requestHandler;
    }

    public HeadObjectOutput headObject(String objectName, HeadObjectInput input) throws QSException {
        RequestHandler<HeadObjectOutput> requestHandler;
        HeadObjectOutput backModel;
        if (input == null) {
            input = new HeadObjectInput();
        }
        if ((backModel = (requestHandler = this.headObjectRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<HeadObjectOutput> headObjectRequest(String objectName, HeadObjectInput input) throws QSException {
        if (input == null) {
            input = new HeadObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("HeadObject").apiName("HeadObject").serviceName("HEAD Object").reqMethod("HEAD").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<HeadObjectOutput> requestHandler = QSRequest.getRequest(builder.build(), input, HeadObjectOutput.class);
        return requestHandler;
    }

    public void headObjectAsync(String objectName, HeadObjectInput input, ResponseCallBack<HeadObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new HeadObjectInput();
        }
        RequestHandler<HeadObjectOutput> requestHandler = this.headObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<HeadObjectOutput> headObjectAsyncRequest(String objectName, HeadObjectInput input, ResponseCallBack<HeadObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new HeadObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("HeadObject").apiName("HeadObject").serviceName("HEAD Object").reqMethod("HEAD").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<HeadObjectOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, HeadObjectOutput.class);
        return requestHandler;
    }

    public ImageProcessOutput imageProcess(String objectName, ImageProcessInput input) throws QSException {
        RequestHandler<ImageProcessOutput> requestHandler;
        ImageProcessOutput backModel;
        if (input == null) {
            input = new ImageProcessInput();
        }
        if ((backModel = (requestHandler = this.imageProcessRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<ImageProcessOutput> imageProcessRequest(String objectName, ImageProcessInput input) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ImageProcess").apiName("ImageProcess").serviceName("Image Process").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>?image");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<ImageProcessOutput> requestHandler = QSRequest.getRequest(builder.build(), input, ImageProcessOutput.class);
        return requestHandler;
    }

    public void imageProcessAsync(String objectName, ImageProcessInput input, ResponseCallBack<ImageProcessOutput> callback) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        RequestHandler<ImageProcessOutput> requestHandler = this.imageProcessAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<ImageProcessOutput> imageProcessAsyncRequest(String objectName, ImageProcessInput input, ResponseCallBack<ImageProcessOutput> callback) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ImageProcess").apiName("ImageProcess").serviceName("Image Process").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>?image");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<ImageProcessOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, ImageProcessOutput.class);
        return requestHandler;
    }

    public InitiateMultipartUploadOutput initiateMultipartUpload(String objectName, InitiateMultipartUploadInput input) throws QSException {
        RequestHandler<InitiateMultipartUploadOutput> requestHandler;
        InitiateMultipartUploadOutput backModel;
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        if ((backModel = (requestHandler = this.initiateMultipartUploadRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<InitiateMultipartUploadOutput> initiateMultipartUploadRequest(String objectName, InitiateMultipartUploadInput input) throws QSException {
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("InitiateMultipartUpload").apiName("InitiateMultipartUpload").serviceName("Initiate Multipart Upload").reqMethod("POST").subSourcePath("/<bucket-name>/<object-key>?uploads");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<InitiateMultipartUploadOutput> requestHandler = QSRequest.getRequest(builder.build(), input, InitiateMultipartUploadOutput.class);
        return requestHandler;
    }

    public void initiateMultipartUploadAsync(String objectName, InitiateMultipartUploadInput input, ResponseCallBack<InitiateMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        RequestHandler<InitiateMultipartUploadOutput> requestHandler = this.initiateMultipartUploadAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<InitiateMultipartUploadOutput> initiateMultipartUploadAsyncRequest(String objectName, InitiateMultipartUploadInput input, ResponseCallBack<InitiateMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("InitiateMultipartUpload").apiName("InitiateMultipartUpload").serviceName("Initiate Multipart Upload").reqMethod("POST").subSourcePath("/<bucket-name>/<object-key>?uploads");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<InitiateMultipartUploadOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, InitiateMultipartUploadOutput.class);
        return requestHandler;
    }

    public ListMultipartOutput listMultipart(String objectName, ListMultipartInput input) throws QSException {
        RequestHandler<ListMultipartOutput> requestHandler;
        ListMultipartOutput backModel;
        if (input == null) {
            input = new ListMultipartInput();
        }
        if ((backModel = (requestHandler = this.listMultipartRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<ListMultipartOutput> listMultipartRequest(String objectName, ListMultipartInput input) throws QSException {
        if (input == null) {
            input = new ListMultipartInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListMultipart").apiName("ListMultipart").serviceName("List Multipart").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<ListMultipartOutput> requestHandler = QSRequest.getRequest(builder.build(), input, ListMultipartOutput.class);
        return requestHandler;
    }

    public void listMultipartAsync(String objectName, ListMultipartInput input, ResponseCallBack<ListMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartInput();
        }
        RequestHandler<ListMultipartOutput> requestHandler = this.listMultipartAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<ListMultipartOutput> listMultipartAsyncRequest(String objectName, ListMultipartInput input, ResponseCallBack<ListMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ListMultipart").apiName("ListMultipart").serviceName("List Multipart").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<ListMultipartOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, ListMultipartOutput.class);
        return requestHandler;
    }

    public OptionsObjectOutput optionsObject(String objectName, OptionsObjectInput input) throws QSException {
        RequestHandler<OptionsObjectOutput> requestHandler;
        OptionsObjectOutput backModel;
        if (input == null) {
            input = new OptionsObjectInput();
        }
        if ((backModel = (requestHandler = this.optionsObjectRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<OptionsObjectOutput> optionsObjectRequest(String objectName, OptionsObjectInput input) throws QSException {
        if (input == null) {
            input = new OptionsObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("OptionsObject").apiName("OptionsObject").serviceName("OPTIONS Object").reqMethod("OPTIONS").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<OptionsObjectOutput> requestHandler = QSRequest.getRequest(builder.build(), input, OptionsObjectOutput.class);
        return requestHandler;
    }

    public void optionsObjectAsync(String objectName, OptionsObjectInput input, ResponseCallBack<OptionsObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new OptionsObjectInput();
        }
        RequestHandler<OptionsObjectOutput> requestHandler = this.optionsObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<OptionsObjectOutput> optionsObjectAsyncRequest(String objectName, OptionsObjectInput input, ResponseCallBack<OptionsObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new OptionsObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("OptionsObject").apiName("OptionsObject").serviceName("OPTIONS Object").reqMethod("OPTIONS").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<OptionsObjectOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, OptionsObjectOutput.class);
        return requestHandler;
    }

    public PutObjectOutput putObject(String objectName, PutObjectInput input) throws QSException {
        RequestHandler<PutObjectOutput> requestHandler;
        PutObjectOutput backModel;
        if (input == null) {
            input = new PutObjectInput();
        }
        if ((backModel = (requestHandler = this.putObjectRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<PutObjectOutput> putObjectRequest(String objectName, PutObjectInput input) throws QSException {
        if (input == null) {
            input = new PutObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutObject").apiName("PutObject").serviceName("PUT Object").reqMethod("PUT").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<PutObjectOutput> requestHandler = QSRequest.getRequest(builder.build(), input, PutObjectOutput.class);
        return requestHandler;
    }

    public void putObjectAsync(String objectName, PutObjectInput input, ResponseCallBack<PutObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new PutObjectInput();
        }
        RequestHandler<PutObjectOutput> requestHandler = this.putObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<PutObjectOutput> putObjectAsyncRequest(String objectName, PutObjectInput input, ResponseCallBack<PutObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new PutObjectInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("PutObject").apiName("PutObject").serviceName("PUT Object").reqMethod("PUT").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<PutObjectOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, PutObjectOutput.class);
        return requestHandler;
    }

    public UploadMultipartOutput uploadMultipart(String objectName, UploadMultipartInput input) throws QSException {
        RequestHandler<UploadMultipartOutput> requestHandler;
        UploadMultipartOutput backModel;
        if (input == null) {
            input = new UploadMultipartInput();
        }
        if ((backModel = (requestHandler = this.uploadMultipartRequest(objectName, input)).send()) != null) {
            return backModel;
        }
        return null;
    }

    public RequestHandler<UploadMultipartOutput> uploadMultipartRequest(String objectName, UploadMultipartInput input) throws QSException {
        if (input == null) {
            input = new UploadMultipartInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("UploadMultipart").apiName("UploadMultipart").serviceName("Upload Multipart").reqMethod("PUT").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<UploadMultipartOutput> requestHandler = QSRequest.getRequest(builder.build(), input, UploadMultipartOutput.class);
        return requestHandler;
    }

    public void uploadMultipartAsync(String objectName, UploadMultipartInput input, ResponseCallBack<UploadMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new UploadMultipartInput();
        }
        RequestHandler<UploadMultipartOutput> requestHandler = this.uploadMultipartAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler<UploadMultipartOutput> uploadMultipartAsyncRequest(String objectName, UploadMultipartInput input, ResponseCallBack<UploadMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new UploadMultipartInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("UploadMultipart").apiName("UploadMultipart").serviceName("Upload Multipart").reqMethod("PUT").subSourcePath("/<bucket-name>/<object-key>");
        builder.bucketName(this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        builder.objKey(objectName);
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler<UploadMultipartOutput> requestHandler = QSRequest.getRequestAsync(builder.build(), input, callback, UploadMultipartOutput.class);
        return requestHandler;
    }

    public String GetObjectSignatureUrl(String objectName, long expires) throws QSException {
        RequestHandler requestHandler = this.GetObjectBySignatureUrlRequest(objectName, null, expires);
        return requestHandler.getExpiresRequestUrl();
    }

    public RequestHandler GetObjectBySignatureUrlRequest(String objectName, GetObjectInput input, long expires) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).expires(String.valueOf(expires)).operationName("GetObject").apiName("GetObject").serviceName("Get Object").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>").bucketName(this.bucketName).objKey(objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (input == null) {
            input = new GetObjectInput();
        }
        RequestHandler<OutputModel> requestHandler = QSRequest.getRequest(builder.build(), input, OutputModel.class);
        return requestHandler;
    }

    public GetObjectOutput GetObjectBySignatureUrl(String signaturedRequest) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetObject").apiName("GetObject").serviceName("QingStor").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>");
        OutputModel backModel = QSRequest.sendApiRequest(signaturedRequest, builder.build(), GetObjectOutput.class);
        if (backModel != null) {
            return (GetObjectOutput)backModel;
        }
        return null;
    }

    public void GetObjectBySignatureUrlAsync(String signaturedRequest, ResponseCallBack<GetObjectOutput> callback) throws QSException {
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("GetObject").apiName("GetObject").serviceName("QingStor").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>");
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        QSRequest.sendApiRequestAsync(signaturedRequest, builder.build(), callback, GetObjectOutput.class);
    }

    public RequestHandler<ImageProcessOutput> imageProcessExpiredUrlRequest(String objectName, ImageProcessInput input, long expires) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        OperationContext.OperationContextBuilder builder = OperationContext.builder();
        builder.clientCfg(this.clientCfg).zone(this.zone).credentials(this.cred).operationName("ImageProcess").apiName("ImageProcess").serviceName("Image Process").reqMethod("GET").subSourcePath("/<bucket-name>/<object-key>?image").bucketName(this.bucketName).objKey(objectName);
        if (expires > System.currentTimeMillis() / 1000L) {
            builder.expires(String.valueOf(expires));
        }
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler<ImageProcessOutput> requestHandler = QSRequest.getRequest(builder.build(), input, ImageProcessOutput.class);
        return requestHandler;
    }

    public static class UploadMultipartOutput
    extends OutputModel {
        private String eTag;
        private String xQSContentCopyRange;
        private String xQSEncryptionCustomerAlgorithm;

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="etag")
        public String getETag() {
            return this.eTag;
        }

        public void setXQSContentCopyRange(String xQSContentCopyRange) {
            this.xQSContentCopyRange = xQSContentCopyRange;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-content-copy-range")
        public String getXQSContentCopyRange() {
            return this.xQSContentCopyRange;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class UploadMultipartInput
    extends RequestInputModel {
        private Integer partNumber;
        private String uploadID;
        private Long contentLength;
        private String contentMD5;
        private String xQSCopyRange;
        private String xQSCopySource;
        private String xQSCopySourceEncryptionCustomerAlgorithm;
        private String xQSCopySourceEncryptionCustomerKey;
        private String xQSCopySourceEncryptionCustomerKeyMD5;
        private String xQSCopySourceIfMatch;
        private String xQSCopySourceIfModifiedSince;
        private String xQSCopySourceIfNoneMatch;
        private String xQSCopySourceIfUnmodifiedSince;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private File bodyInputFile;
        private InputStream bodyInputStream;
        private Long fileOffset = -1L;

        public void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @ParamAnnotation(paramType="query", paramName="part_number")
        public Integer getPartNumber() {
            return this.partNumber;
        }

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="content-length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @ParamAnnotation(paramType="header", paramName="content-md5")
        public String getContentMD5() {
            return this.contentMD5;
        }

        public void setXQSCopyRange(String xQSCopyRange) {
            this.xQSCopyRange = xQSCopyRange;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-range")
        public String getXQSCopyRange() {
            return this.xQSCopyRange;
        }

        public void setXQSCopySource(String xQSCopySource) {
            this.xQSCopySource = xQSCopySource;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source")
        public String getXQSCopySource() {
            return this.xQSCopySource;
        }

        public void setXQSCopySourceEncryptionCustomerAlgorithm(String xQSCopySourceEncryptionCustomerAlgorithm) {
            this.xQSCopySourceEncryptionCustomerAlgorithm = xQSCopySourceEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-encryption-customer-algorithm")
        public String getXQSCopySourceEncryptionCustomerAlgorithm() {
            return this.xQSCopySourceEncryptionCustomerAlgorithm;
        }

        public void setXQSCopySourceEncryptionCustomerKey(String xQSCopySourceEncryptionCustomerKey) {
            this.xQSCopySourceEncryptionCustomerKey = xQSCopySourceEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-encryption-customer-key")
        public String getXQSCopySourceEncryptionCustomerKey() {
            return this.xQSCopySourceEncryptionCustomerKey;
        }

        public void setXQSCopySourceEncryptionCustomerKeyMD5(String xQSCopySourceEncryptionCustomerKeyMD5) {
            this.xQSCopySourceEncryptionCustomerKeyMD5 = xQSCopySourceEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-encryption-customer-key-md5")
        public String getXQSCopySourceEncryptionCustomerKeyMD5() {
            return this.xQSCopySourceEncryptionCustomerKeyMD5;
        }

        public void setXQSCopySourceIfMatch(String xQSCopySourceIfMatch) {
            this.xQSCopySourceIfMatch = xQSCopySourceIfMatch;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-match")
        public String getXQSCopySourceIfMatch() {
            return this.xQSCopySourceIfMatch;
        }

        public void setXQSCopySourceIfModifiedSince(String xQSCopySourceIfModifiedSince) {
            this.xQSCopySourceIfModifiedSince = xQSCopySourceIfModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-modified-since")
        public String getXQSCopySourceIfModifiedSince() {
            return this.xQSCopySourceIfModifiedSince;
        }

        public void setXQSCopySourceIfNoneMatch(String xQSCopySourceIfNoneMatch) {
            this.xQSCopySourceIfNoneMatch = xQSCopySourceIfNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-none-match")
        public String getXQSCopySourceIfNoneMatch() {
            return this.xQSCopySourceIfNoneMatch;
        }

        public void setXQSCopySourceIfUnmodifiedSince(String xQSCopySourceIfUnmodifiedSince) {
            this.xQSCopySourceIfUnmodifiedSince = xQSCopySourceIfUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-unmodified-since")
        public String getXQSCopySourceIfUnmodifiedSince() {
            return this.xQSCopySourceIfUnmodifiedSince;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key-md5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFile() {
            return this.bodyInputFile;
        }

        @Deprecated
        public void setBodyInputFile(File bodyInputFile) {
            this.bodyInputFile = bodyInputFile;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        public void setFileOffset(Long fileOffset) {
            this.fileOffset = fileOffset;
        }

        @ParamAnnotation(paramType="query", paramName="file_offset")
        public Long getFileOffset() {
            return this.fileOffset;
        }

        public void setBodyInputFilePart(File bodyInputFilePart) {
            this.bodyInputFile = bodyInputFilePart;
            this.fileOffset = 0L;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFilePart() {
            return this.bodyInputFile;
        }

        @Override
        public String validateParam() {
            if (this.getPartNumber() < 0) {
                return QSStringUtil.getParameterRequired("PartNumber", "UploadMultipartInput");
            }
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "UploadMultipartInput");
            }
            return null;
        }
    }

    public static class PutObjectOutput
    extends OutputModel {
        private String eTag;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSVersionId;

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="etag")
        public String getETag() {
            return this.eTag;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSVersionId(String xQSVersionId) {
            this.xQSVersionId = xQSVersionId;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-version-id")
        public String getXQSVersionId() {
            return this.xQSVersionId;
        }
    }

    public static class PutObjectInput
    extends RequestInputModel {
        private String cacheControl;
        private String contentEncoding;
        private Long contentLength;
        private String contentMD5;
        private String contentType;
        private String expect;
        private String xQSCopySource;
        private String xQSCopySourceEncryptionCustomerAlgorithm;
        private String xQSCopySourceEncryptionCustomerKey;
        private String xQSCopySourceEncryptionCustomerKeyMD5;
        private String xQSCopySourceIfMatch;
        private String xQSCopySourceIfModifiedSince;
        private String xQSCopySourceIfNoneMatch;
        private String xQSCopySourceIfUnmodifiedSince;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private String xQSFetchIfUnmodifiedSince;
        private String xQSFetchSource;
        private Map<String, String> xQSMetaData;
        private String xQSMetadataDirective;
        private String xQSMoveSource;
        private String xQSStorageClass;
        private File bodyInputFile;
        private InputStream bodyInputStream;

        public void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @ParamAnnotation(paramType="header", paramName="cache-control")
        public String getCacheControl() {
            return this.cacheControl;
        }

        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @ParamAnnotation(paramType="header", paramName="content-encoding")
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="content-length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @ParamAnnotation(paramType="header", paramName="content-md5")
        public String getContentMD5() {
            return this.contentMD5;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="content-type")
        public String getContentType() {
            return this.contentType;
        }

        public void setExpect(String expect) {
            this.expect = expect;
        }

        @ParamAnnotation(paramType="header", paramName="expect")
        public String getExpect() {
            return this.expect;
        }

        public void setXQSCopySource(String xQSCopySource) {
            this.xQSCopySource = xQSCopySource;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source")
        public String getXQSCopySource() {
            return this.xQSCopySource;
        }

        public void setXQSCopySourceEncryptionCustomerAlgorithm(String xQSCopySourceEncryptionCustomerAlgorithm) {
            this.xQSCopySourceEncryptionCustomerAlgorithm = xQSCopySourceEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-encryption-customer-algorithm")
        public String getXQSCopySourceEncryptionCustomerAlgorithm() {
            return this.xQSCopySourceEncryptionCustomerAlgorithm;
        }

        public void setXQSCopySourceEncryptionCustomerKey(String xQSCopySourceEncryptionCustomerKey) {
            this.xQSCopySourceEncryptionCustomerKey = xQSCopySourceEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-encryption-customer-key")
        public String getXQSCopySourceEncryptionCustomerKey() {
            return this.xQSCopySourceEncryptionCustomerKey;
        }

        public void setXQSCopySourceEncryptionCustomerKeyMD5(String xQSCopySourceEncryptionCustomerKeyMD5) {
            this.xQSCopySourceEncryptionCustomerKeyMD5 = xQSCopySourceEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-encryption-customer-key-md5")
        public String getXQSCopySourceEncryptionCustomerKeyMD5() {
            return this.xQSCopySourceEncryptionCustomerKeyMD5;
        }

        public void setXQSCopySourceIfMatch(String xQSCopySourceIfMatch) {
            this.xQSCopySourceIfMatch = xQSCopySourceIfMatch;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-match")
        public String getXQSCopySourceIfMatch() {
            return this.xQSCopySourceIfMatch;
        }

        public void setXQSCopySourceIfModifiedSince(String xQSCopySourceIfModifiedSince) {
            this.xQSCopySourceIfModifiedSince = xQSCopySourceIfModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-modified-since")
        public String getXQSCopySourceIfModifiedSince() {
            return this.xQSCopySourceIfModifiedSince;
        }

        public void setXQSCopySourceIfNoneMatch(String xQSCopySourceIfNoneMatch) {
            this.xQSCopySourceIfNoneMatch = xQSCopySourceIfNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-none-match")
        public String getXQSCopySourceIfNoneMatch() {
            return this.xQSCopySourceIfNoneMatch;
        }

        public void setXQSCopySourceIfUnmodifiedSince(String xQSCopySourceIfUnmodifiedSince) {
            this.xQSCopySourceIfUnmodifiedSince = xQSCopySourceIfUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-copy-source-if-unmodified-since")
        public String getXQSCopySourceIfUnmodifiedSince() {
            return this.xQSCopySourceIfUnmodifiedSince;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key-md5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        public void setXQSFetchIfUnmodifiedSince(String xQSFetchIfUnmodifiedSince) {
            this.xQSFetchIfUnmodifiedSince = xQSFetchIfUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-fetch-if-unmodified-since")
        public String getXQSFetchIfUnmodifiedSince() {
            return this.xQSFetchIfUnmodifiedSince;
        }

        public void setXQSFetchSource(String xQSFetchSource) {
            this.xQSFetchSource = xQSFetchSource;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-fetch-source")
        public String getXQSFetchSource() {
            return this.xQSFetchSource;
        }

        public void setXQSMetaData(Map<String, String> xQSMetaData) {
            this.xQSMetaData = xQSMetaData;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-metadata")
        public Map<String, String> getXQSMetaData() {
            return this.xQSMetaData;
        }

        public void setXQSMetadataDirective(String xQSMetadataDirective) {
            this.xQSMetadataDirective = xQSMetadataDirective;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-metadata-directive")
        public String getXQSMetadataDirective() {
            return this.xQSMetadataDirective;
        }

        public void setXQSMoveSource(String xQSMoveSource) {
            this.xQSMoveSource = xQSMoveSource;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-move-source")
        public String getXQSMoveSource() {
            return this.xQSMoveSource;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-storage-class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFile() {
            return this.bodyInputFile;
        }

        public void setBodyInputFile(File bodyInputFile) {
            this.bodyInputFile = bodyInputFile;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        @Override
        public String validateParam() {
            String vValidate;
            Map<String, String> metadata = this.getXQSMetaData();
            if (metadata != null && !QSStringUtil.isEmpty(vValidate = QSParamInvokeUtil.metadataIsValid(metadata))) {
                return vValidate;
            }
            String[] xQSMetadataDirectiveValidValues = new String[]{"COPY", "REPLACE"};
            boolean xQSMetadataDirectiveIsValid = false;
            String xQSMetadataDirective = this.getXQSMetadataDirective();
            if (null == xQSMetadataDirective || "".equals(xQSMetadataDirective)) {
                xQSMetadataDirectiveIsValid = true;
            } else {
                for (String v : xQSMetadataDirectiveValidValues) {
                    if (!v.equals(xQSMetadataDirective)) continue;
                    xQSMetadataDirectiveIsValid = true;
                }
            }
            if (!xQSMetadataDirectiveIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("XQSMetadataDirective", this.getXQSMetadataDirective() + "", xQSMetadataDirectiveValidValues);
            }
            String[] xQSStorageClassValidValues = new String[]{"STANDARD", "STANDARD_IA"};
            boolean xQSStorageClassIsValid = false;
            String xQSStorageClass = this.getXQSStorageClass();
            if (null == xQSStorageClass || "".equals(xQSStorageClass)) {
                xQSStorageClassIsValid = true;
            } else {
                for (String v : xQSStorageClassValidValues) {
                    if (!v.equals(xQSStorageClass)) continue;
                    xQSStorageClassIsValid = true;
                }
            }
            if (!xQSStorageClassIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("XQSStorageClass", this.getXQSStorageClass() + "", xQSStorageClassValidValues);
            }
            return null;
        }
    }

    public static class OptionsObjectOutput
    extends OutputModel {
        private String accessControlAllowHeaders;
        private String accessControlAllowMethods;
        private String accessControlAllowOrigin;
        private String accessControlExposeHeaders;
        private String accessControlMaxAge;

        public void setAccessControlAllowHeaders(String accessControlAllowHeaders) {
            this.accessControlAllowHeaders = accessControlAllowHeaders;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-allow-headers")
        public String getAccessControlAllowHeaders() {
            return this.accessControlAllowHeaders;
        }

        public void setAccessControlAllowMethods(String accessControlAllowMethods) {
            this.accessControlAllowMethods = accessControlAllowMethods;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-allow-methods")
        public String getAccessControlAllowMethods() {
            return this.accessControlAllowMethods;
        }

        public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-allow-origin")
        public String getAccessControlAllowOrigin() {
            return this.accessControlAllowOrigin;
        }

        public void setAccessControlExposeHeaders(String accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-expose-headers")
        public String getAccessControlExposeHeaders() {
            return this.accessControlExposeHeaders;
        }

        public void setAccessControlMaxAge(String accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-max-age")
        public String getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }
    }

    public static class OptionsObjectInput
    extends RequestInputModel {
        private String accessControlRequestHeaders;
        private String accessControlRequestMethod;
        private String origin;

        public void setAccessControlRequestHeaders(String accessControlRequestHeaders) {
            this.accessControlRequestHeaders = accessControlRequestHeaders;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-request-headers")
        public String getAccessControlRequestHeaders() {
            return this.accessControlRequestHeaders;
        }

        public void setAccessControlRequestMethod(String accessControlRequestMethod) {
            this.accessControlRequestMethod = accessControlRequestMethod;
        }

        @ParamAnnotation(paramType="header", paramName="access-control-request-method")
        public String getAccessControlRequestMethod() {
            return this.accessControlRequestMethod;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @ParamAnnotation(paramType="header", paramName="origin")
        public String getOrigin() {
            return this.origin;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getAccessControlRequestMethod())) {
                return QSStringUtil.getParameterRequired("AccessControlRequestMethod", "OptionsObjectInput");
            }
            if (QSStringUtil.isEmpty(this.getOrigin())) {
                return QSStringUtil.getParameterRequired("Origin", "OptionsObjectInput");
            }
            return null;
        }
    }

    public static class ListMultipartOutput
    extends OutputModel {
        private Integer count;
        private List<Types.ObjectPartModel> objectParts;

        public void setCount(Integer count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="element", paramName="count")
        public Integer getCount() {
            return this.count;
        }

        public void setObjectParts(List<Types.ObjectPartModel> objectParts) {
            this.objectParts = objectParts;
        }

        @ParamAnnotation(paramType="element", paramName="object_parts")
        public List<Types.ObjectPartModel> getObjectParts() {
            return this.objectParts;
        }
    }

    public static class ListMultipartInput
    extends RequestInputModel {
        private Integer limit;
        private Integer partNumberMarker;
        private String uploadID;

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        @ParamAnnotation(paramType="query", paramName="part_number_marker")
        public Integer getPartNumberMarker() {
            return this.partNumberMarker;
        }

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "ListMultipartInput");
            }
            return null;
        }
    }

    public static class InitiateMultipartUploadOutput
    extends OutputModel {
        private String bucket;
        private String key;
        private String uploadID;
        private String xQSEncryptionCustomerAlgorithm;

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @ParamAnnotation(paramType="element", paramName="bucket")
        public String getBucket() {
            return this.bucket;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @ParamAnnotation(paramType="element", paramName="key")
        public String getKey() {
            return this.key;
        }

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="element", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class InitiateMultipartUploadInput
    extends RequestInputModel {
        private String contentType;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private Map<String, String> xQSMetaData;
        private String xQSStorageClass;

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="content-type")
        public String getContentType() {
            return this.contentType;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key-md5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        public void setXQSMetaData(Map<String, String> xQSMetaData) {
            this.xQSMetaData = xQSMetaData;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-metadata")
        public Map<String, String> getXQSMetaData() {
            return this.xQSMetaData;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-storage-class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        @Override
        public String validateParam() {
            String vValidate;
            Map<String, String> metadata = this.getXQSMetaData();
            if (metadata != null && !QSStringUtil.isEmpty(vValidate = QSParamInvokeUtil.metadataIsValid(metadata))) {
                return vValidate;
            }
            String[] xQSStorageClassValidValues = new String[]{"STANDARD", "STANDARD_IA"};
            boolean xQSStorageClassIsValid = false;
            String xQSStorageClass = this.getXQSStorageClass();
            if (null == xQSStorageClass || "".equals(xQSStorageClass)) {
                xQSStorageClassIsValid = true;
            } else {
                for (String v : xQSStorageClassValidValues) {
                    if (!v.equals(xQSStorageClass)) continue;
                    xQSStorageClassIsValid = true;
                }
            }
            if (!xQSStorageClassIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("XQSStorageClass", this.getXQSStorageClass() + "", xQSStorageClassValidValues);
            }
            return null;
        }
    }

    public static class ImageProcessOutput
    extends OutputModel {
        private InputStream bodyInputStream;
        private Long contentLength;

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="content-length")
        public Long getContentLength() {
            return this.contentLength;
        }
    }

    public static class ImageProcessInput
    extends RequestInputModel {
        private String action;
        private String responseCacheControl;
        private String responseContentDisposition;
        private String responseContentEncoding;
        private String responseContentLanguage;
        private String responseContentType;
        private String responseExpires;
        private String ifModifiedSince;

        public void setAction(String action) {
            this.action = action;
        }

        @ParamAnnotation(paramType="query", paramName="action")
        public String getAction() {
            return this.action;
        }

        public void setResponseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
        }

        @ParamAnnotation(paramType="query", paramName="response-cache-control")
        public String getResponseCacheControl() {
            return this.responseCacheControl;
        }

        public void setResponseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-disposition")
        public String getResponseContentDisposition() {
            return this.responseContentDisposition;
        }

        public void setResponseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-encoding")
        public String getResponseContentEncoding() {
            return this.responseContentEncoding;
        }

        public void setResponseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-language")
        public String getResponseContentLanguage() {
            return this.responseContentLanguage;
        }

        public void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-type")
        public String getResponseContentType() {
            return this.responseContentType;
        }

        public void setResponseExpires(String responseExpires) {
            this.responseExpires = responseExpires;
        }

        @ParamAnnotation(paramType="query", paramName="response-expires")
        public String getResponseExpires() {
            return this.responseExpires;
        }

        public void setIfModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="if-modified-since")
        public String getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getAction())) {
                return QSStringUtil.getParameterRequired("Action", "ImageProcessInput");
            }
            return null;
        }
    }

    public static class HeadObjectOutput
    extends OutputModel {
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private Long contentLength;
        private String contentType;
        private String eTag;
        private String expires;
        private String lastModified;
        private Boolean xQSDeleteMarker;
        private String xQSEncryptionCustomerAlgorithm;
        private Map<String, String> xQSMetaData;
        private Long xQSNextAppendPosition;
        private String xQSObjectType;
        private String xQSStorageClass;
        private String xQSVersionId;

        public void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @ParamAnnotation(paramType="header", paramName="cache-control")
        public String getCacheControl() {
            return this.cacheControl;
        }

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @ParamAnnotation(paramType="header", paramName="content-disposition")
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @ParamAnnotation(paramType="header", paramName="content-encoding")
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        @ParamAnnotation(paramType="header", paramName="content-language")
        public String getContentLanguage() {
            return this.contentLanguage;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="content-length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="content-type")
        public String getContentType() {
            return this.contentType;
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="etag")
        public String getETag() {
            return this.eTag;
        }

        public void setExpires(String expires) {
            this.expires = expires;
        }

        @ParamAnnotation(paramType="header", paramName="expires")
        public String getExpires() {
            return this.expires;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @ParamAnnotation(paramType="header", paramName="last-modified")
        public String getLastModified() {
            return this.lastModified;
        }

        public void setXQSDeleteMarker(Boolean xQSDeleteMarker) {
            this.xQSDeleteMarker = xQSDeleteMarker;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-delete-marker")
        public Boolean getXQSDeleteMarker() {
            return this.xQSDeleteMarker;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSMetaData(Map<String, String> xQSMetaData) {
            this.xQSMetaData = xQSMetaData;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-metadata")
        public Map<String, String> getXQSMetaData() {
            return this.xQSMetaData;
        }

        public void setXQSNextAppendPosition(Long xQSNextAppendPosition) {
            this.xQSNextAppendPosition = xQSNextAppendPosition;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-next-append-position")
        public Long getXQSNextAppendPosition() {
            return this.xQSNextAppendPosition;
        }

        public void setXQSObjectType(String xQSObjectType) {
            this.xQSObjectType = xQSObjectType;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-object-type")
        public String getXQSObjectType() {
            return this.xQSObjectType;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-storage-class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        public void setXQSVersionId(String xQSVersionId) {
            this.xQSVersionId = xQSVersionId;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-version-id")
        public String getXQSVersionId() {
            return this.xQSVersionId;
        }
    }

    public static class HeadObjectInput
    extends RequestInputModel {
        private String versionID;
        private String ifMatch;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String ifUnmodifiedSince;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;

        public void setVersionID(String versionID) {
            this.versionID = versionID;
        }

        @ParamAnnotation(paramType="query", paramName="version_id")
        public String getVersionID() {
            return this.versionID;
        }

        public void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @ParamAnnotation(paramType="header", paramName="if-match")
        public String getIfMatch() {
            return this.ifMatch;
        }

        public void setIfModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="if-modified-since")
        public String getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        public void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="if-none-match")
        public String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public void setIfUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="if-unmodified-since")
        public String getIfUnmodifiedSince() {
            return this.ifUnmodifiedSince;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key-md5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class GetObjectOutput
    extends OutputModel {
        private InputStream bodyInputStream;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private Long contentLength;
        private String contentRange;
        private String contentType;
        private String eTag;
        private String expires;
        private String lastModified;
        private Boolean xQSDeleteMarker;
        private String xQSEncryptionCustomerAlgorithm;
        private Map<String, String> xQSMetaData;
        private String xQSStorageClass;
        private String xQSVersionId;

        @Deprecated
        public void setResponseCacheControl(String responseCacheControl) {
            this.cacheControl = responseCacheControl;
        }

        @Deprecated
        public String getResponseCacheControl() {
            return this.cacheControl;
        }

        @Deprecated
        public void setResponseContentDisposition(String responseContentDisposition) {
            this.contentDisposition = responseContentDisposition;
        }

        @Deprecated
        public String getResponseContentDisposition() {
            return this.contentDisposition;
        }

        @Deprecated
        public void setResponseContentEncoding(String responseContentEncoding) {
            this.contentEncoding = responseContentEncoding;
        }

        @Deprecated
        public String getResponseContentEncoding() {
            return this.contentEncoding;
        }

        @Deprecated
        public void setResponseContentLanguage(String responseContentLanguage) {
            this.contentLanguage = responseContentLanguage;
        }

        @Deprecated
        public String getResponseContentLanguage() {
            return this.contentLanguage;
        }

        @Deprecated
        public void setResponseContentType(String responseContentType) {
            this.contentType = responseContentType;
        }

        @Deprecated
        public String getResponseContentType() {
            return this.contentType;
        }

        @Deprecated
        public void setResponseExpires(String responseExpires) {
            this.expires = responseExpires;
        }

        @Deprecated
        public String getResponseExpires() {
            return this.expires;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        public void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @ParamAnnotation(paramType="header", paramName="cache-control")
        public String getCacheControl() {
            return this.cacheControl;
        }

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @ParamAnnotation(paramType="header", paramName="content-disposition")
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @ParamAnnotation(paramType="header", paramName="content-encoding")
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        @ParamAnnotation(paramType="header", paramName="content-language")
        public String getContentLanguage() {
            return this.contentLanguage;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="content-length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        @ParamAnnotation(paramType="header", paramName="content-range")
        public String getContentRange() {
            return this.contentRange;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="content-type")
        public String getContentType() {
            return this.contentType;
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="etag")
        public String getETag() {
            return this.eTag;
        }

        public void setExpires(String expires) {
            this.expires = expires;
        }

        @ParamAnnotation(paramType="header", paramName="expires")
        public String getExpires() {
            return this.expires;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @ParamAnnotation(paramType="header", paramName="last-modified")
        public String getLastModified() {
            return this.lastModified;
        }

        public void setXQSDeleteMarker(Boolean xQSDeleteMarker) {
            this.xQSDeleteMarker = xQSDeleteMarker;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-delete-marker")
        public Boolean getXQSDeleteMarker() {
            return this.xQSDeleteMarker;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSMetaData(Map<String, String> xQSMetaData) {
            this.xQSMetaData = xQSMetaData;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-metadata")
        public Map<String, String> getXQSMetaData() {
            return this.xQSMetaData;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-storage-class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        public void setXQSVersionId(String xQSVersionId) {
            this.xQSVersionId = xQSVersionId;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-version-id")
        public String getXQSVersionId() {
            return this.xQSVersionId;
        }
    }

    public static class GetObjectInput
    extends RequestInputModel {
        private String responseCacheControl;
        private String responseContentDisposition;
        private String responseContentEncoding;
        private String responseContentLanguage;
        private String responseContentType;
        private String responseExpires;
        private String versionID;
        private String ifMatch;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String ifUnmodifiedSince;
        private String range;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;

        public void setResponseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
        }

        @ParamAnnotation(paramType="query", paramName="response-cache-control")
        public String getResponseCacheControl() {
            return this.responseCacheControl;
        }

        public void setResponseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-disposition")
        public String getResponseContentDisposition() {
            return this.responseContentDisposition;
        }

        public void setResponseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-encoding")
        public String getResponseContentEncoding() {
            return this.responseContentEncoding;
        }

        public void setResponseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-language")
        public String getResponseContentLanguage() {
            return this.responseContentLanguage;
        }

        public void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-type")
        public String getResponseContentType() {
            return this.responseContentType;
        }

        public void setResponseExpires(String responseExpires) {
            this.responseExpires = responseExpires;
        }

        @ParamAnnotation(paramType="query", paramName="response-expires")
        public String getResponseExpires() {
            return this.responseExpires;
        }

        public void setVersionID(String versionID) {
            this.versionID = versionID;
        }

        @ParamAnnotation(paramType="query", paramName="version_id")
        public String getVersionID() {
            return this.versionID;
        }

        public void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @ParamAnnotation(paramType="header", paramName="if-match")
        public String getIfMatch() {
            return this.ifMatch;
        }

        public void setIfModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="if-modified-since")
        public String getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        public void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="if-none-match")
        public String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public void setIfUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="if-unmodified-since")
        public String getIfUnmodifiedSince() {
            return this.ifUnmodifiedSince;
        }

        public void setRange(String range) {
            this.range = range;
        }

        @ParamAnnotation(paramType="header", paramName="range")
        public String getRange() {
            return this.range;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key-md5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class DeleteObjectOutput
    extends OutputModel {
        private Boolean xQSDeleteMarker;
        private String xQSVersionId;

        public void setXQSDeleteMarker(Boolean xQSDeleteMarker) {
            this.xQSDeleteMarker = xQSDeleteMarker;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-delete-marker")
        public Boolean getXQSDeleteMarker() {
            return this.xQSDeleteMarker;
        }

        public void setXQSVersionId(String xQSVersionId) {
            this.xQSVersionId = xQSVersionId;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-version-id")
        public String getXQSVersionId() {
            return this.xQSVersionId;
        }
    }

    public static class DeleteObjectInput
    extends RequestInputModel {
        private String versionID;

        public void setVersionID(String versionID) {
            this.versionID = versionID;
        }

        @ParamAnnotation(paramType="query", paramName="version_id")
        public String getVersionID() {
            return this.versionID;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class CompleteMultipartUploadOutput
    extends OutputModel {
        private String xQSEncryptionCustomerAlgorithm;

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class CompleteMultipartUploadInput
    extends RequestInputModel {
        private String uploadID;
        private String eTag;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private List<Types.ObjectPartModel> objectParts;
        private String bodyInput;

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="etag")
        public String getETag() {
            return this.eTag;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-encryption-customer-key-md5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        public void setObjectParts(List<Types.ObjectPartModel> objectParts) {
            this.objectParts = objectParts;
        }

        @ParamAnnotation(paramType="element", paramName="object_parts")
        public List<Types.ObjectPartModel> getObjectParts() {
            return this.objectParts;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public CompleteMultipartUploadInput() {
        }

        @Deprecated
        public CompleteMultipartUploadInput(String multipart_upload_id, int partsCount, int startIndex) {
            this.setUploadID(multipart_upload_id);
            this.setBodyInput(this.getCompleteMultipartUploadContent(partsCount, startIndex));
        }

        @Deprecated
        public String getCompleteMultipartUploadContent(int partsCount, int startIndex) {
            if (partsCount < 1 || startIndex < 0) {
                return null;
            }
            StringBuilder uploadJson = new StringBuilder("{\"object_parts\":[");
            for (int i = 0; i < partsCount; ++i) {
                uploadJson.append("{\"part_number\":").append(startIndex++).append("}");
                if (i < partsCount - 1) {
                    uploadJson.append(",");
                    continue;
                }
                uploadJson.append("]}");
            }
            return uploadJson.toString();
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "CompleteMultipartUploadInput");
            }
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getObjectParts() != null && this.getObjectParts().size() > 0) {
                for (int i = 0; i < this.getObjectParts().size(); ++i) {
                    String vValidate = this.getObjectParts().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class AppendObjectOutput
    extends OutputModel {
        private Long xQSNextAppendPosition;

        public void setXQSNextAppendPosition(Long xQSNextAppendPosition) {
            this.xQSNextAppendPosition = xQSNextAppendPosition;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-next-append-position")
        public Long getXQSNextAppendPosition() {
            return this.xQSNextAppendPosition;
        }
    }

    public static class AppendObjectInput
    extends RequestInputModel {
        private Long position;
        private Long contentLength;
        private String contentMD5;
        private String contentType;
        private String xQSStorageClass;
        private File bodyInputFile;
        private InputStream bodyInputStream;

        public void setPosition(Long position) {
            this.position = position;
        }

        @ParamAnnotation(paramType="query", paramName="position")
        public Long getPosition() {
            return this.position;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="content-length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @ParamAnnotation(paramType="header", paramName="content-md5")
        public String getContentMD5() {
            return this.contentMD5;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="content-type")
        public String getContentType() {
            return this.contentType;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="x-qs-storage-class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFile() {
            return this.bodyInputFile;
        }

        public void setBodyInputFile(File bodyInputFile) {
            this.bodyInputFile = bodyInputFile;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        @Override
        public String validateParam() {
            String[] xQSStorageClassValidValues = new String[]{"STANDARD", "STANDARD_IA"};
            boolean xQSStorageClassIsValid = false;
            String xQSStorageClass = this.getXQSStorageClass();
            if (null == xQSStorageClass || "".equals(xQSStorageClass)) {
                xQSStorageClassIsValid = true;
            } else {
                for (String v : xQSStorageClassValidValues) {
                    if (!v.equals(xQSStorageClass)) continue;
                    xQSStorageClassIsValid = true;
                }
            }
            if (!xQSStorageClassIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("XQSStorageClass", this.getXQSStorageClass() + "", xQSStorageClassValidValues);
            }
            return null;
        }
    }

    public static class AbortMultipartUploadOutput
    extends OutputModel {
    }

    public static class AbortMultipartUploadInput
    extends RequestInputModel {
        private String uploadID;

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "AbortMultipartUploadInput");
            }
            return null;
        }
    }

    public static class PutBucketVersioningOutput
    extends OutputModel {
    }

    public static class PutBucketVersioningInput
    extends RequestInputModel {
        private String status;
        private String bodyInput;

        public void setStatus(String status) {
            this.status = status;
        }

        @ParamAnnotation(paramType="element", paramName="status")
        public String getStatus() {
            return this.status;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            String[] statusValidValues = new String[]{"DISABLED", "ENABLED", "SUSPENDED"};
            boolean statusIsValid = false;
            String status = this.getStatus();
            if (null == status || "".equals(status)) {
                statusIsValid = true;
            } else {
                for (String v : statusValidValues) {
                    if (!v.equals(status)) continue;
                    statusIsValid = true;
                }
            }
            if (!statusIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("Status", this.getStatus() + "", statusValidValues);
            }
            return null;
        }
    }

    public static class PutBucketReplicationOutput
    extends OutputModel {
    }

    public static class PutBucketReplicationInput
    extends RequestInputModel {
        private List<Types.RulesModel> rules;
        private String bodyInput;

        public void setRules(List<Types.RulesModel> rules) {
            this.rules = rules;
        }

        @ParamAnnotation(paramType="element", paramName="rules")
        public List<Types.RulesModel> getRules() {
            return this.rules;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getRules() != null && this.getRules().size() > 0) {
                for (int i = 0; i < this.getRules().size(); ++i) {
                    String vValidate = this.getRules().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketPolicyOutput
    extends OutputModel {
    }

    public static class PutBucketPolicyInput
    extends RequestInputModel {
        private List<Types.StatementModel> statement;
        private String bodyInput;

        public void setStatement(List<Types.StatementModel> statement) {
            this.statement = statement;
        }

        @ParamAnnotation(paramType="element", paramName="statement")
        public List<Types.StatementModel> getStatement() {
            return this.statement;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getStatement() != null && this.getStatement().size() > 0) {
                for (int i = 0; i < this.getStatement().size(); ++i) {
                    String vValidate = this.getStatement().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketNotificationOutput
    extends OutputModel {
    }

    public static class PutBucketNotificationInput
    extends RequestInputModel {
        private List<Types.NotificationModel> notifications;
        private String bodyInput;

        public void setNotifications(List<Types.NotificationModel> notifications) {
            this.notifications = notifications;
        }

        @ParamAnnotation(paramType="element", paramName="notifications")
        public List<Types.NotificationModel> getNotifications() {
            return this.notifications;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getNotifications() != null && this.getNotifications().size() > 0) {
                for (int i = 0; i < this.getNotifications().size(); ++i) {
                    String vValidate = this.getNotifications().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketLoggingOutput
    extends OutputModel {
    }

    public static class PutBucketLoggingInput
    extends RequestInputModel {
        private String targetBucket;
        private String targetPrefix;
        private String bodyInput;

        public void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        @ParamAnnotation(paramType="element", paramName="target_bucket")
        public String getTargetBucket() {
            return this.targetBucket;
        }

        public void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        @ParamAnnotation(paramType="element", paramName="target_prefix")
        public String getTargetPrefix() {
            return this.targetPrefix;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (QSStringUtil.isEmpty(this.getTargetBucket())) {
                return QSStringUtil.getParameterRequired("TargetBucket", "PutBucketLoggingInput");
            }
            if (QSStringUtil.isEmpty(this.getTargetPrefix())) {
                return QSStringUtil.getParameterRequired("TargetPrefix", "PutBucketLoggingInput");
            }
            return null;
        }
    }

    public static class PutBucketLifecycleOutput
    extends OutputModel {
    }

    public static class PutBucketLifecycleInput
    extends RequestInputModel {
        private List<Types.RuleModel> rule;
        private String bodyInput;

        public void setRule(List<Types.RuleModel> rule) {
            this.rule = rule;
        }

        @ParamAnnotation(paramType="element", paramName="rule")
        public List<Types.RuleModel> getRule() {
            return this.rule;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getRule() != null && this.getRule().size() > 0) {
                for (int i = 0; i < this.getRule().size(); ++i) {
                    String vValidate = this.getRule().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketExternalMirrorOutput
    extends OutputModel {
    }

    public static class PutBucketExternalMirrorInput
    extends RequestInputModel {
        private String sourceSite;
        private String bodyInput;

        public void setSourceSite(String sourceSite) {
            this.sourceSite = sourceSite;
        }

        @ParamAnnotation(paramType="element", paramName="source_site")
        public String getSourceSite() {
            return this.sourceSite;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (QSStringUtil.isEmpty(this.getSourceSite())) {
                return QSStringUtil.getParameterRequired("SourceSite", "PutBucketExternalMirrorInput");
            }
            return null;
        }
    }

    public static class PutBucketCORSOutput
    extends OutputModel {
    }

    public static class PutBucketCORSInput
    extends RequestInputModel {
        private List<Types.CORSRuleModel> cORSRules;
        private String bodyInput;

        public void setCORSRules(List<Types.CORSRuleModel> cORSRules) {
            this.cORSRules = cORSRules;
        }

        @ParamAnnotation(paramType="element", paramName="cors_rules")
        public List<Types.CORSRuleModel> getCORSRules() {
            return this.cORSRules;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getCORSRules() != null && this.getCORSRules().size() > 0) {
                for (int i = 0; i < this.getCORSRules().size(); ++i) {
                    String vValidate = this.getCORSRules().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketCNAMEOutput
    extends OutputModel {
    }

    public static class PutBucketCNAMEInput
    extends RequestInputModel {
        private String domain;
        private String type;
        private String bodyInput;

        public void setDomain(String domain) {
            this.domain = domain;
        }

        @ParamAnnotation(paramType="element", paramName="domain")
        public String getDomain() {
            return this.domain;
        }

        public void setType(String type) {
            this.type = type;
        }

        @ParamAnnotation(paramType="element", paramName="type")
        public String getType() {
            return this.type;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (QSStringUtil.isEmpty(this.getDomain())) {
                return QSStringUtil.getParameterRequired("Domain", "PutBucketCNAMEInput");
            }
            String[] typeValidValues = new String[]{"normal", "website"};
            boolean typeIsValid = false;
            String type = this.getType();
            if (null == type || "".equals(type)) {
                typeIsValid = true;
            } else {
                for (String v : typeValidValues) {
                    if (!v.equals(type)) continue;
                    typeIsValid = true;
                }
            }
            if (!typeIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("Type", this.getType() + "", typeValidValues);
            }
            return null;
        }
    }

    public static class PutBucketACLOutput
    extends OutputModel {
    }

    public static class PutBucketACLInput
    extends RequestInputModel {
        private List<Types.ACLModel> aCL;
        private String bodyInput;

        public void setACL(List<Types.ACLModel> aCL) {
            this.aCL = aCL;
        }

        @ParamAnnotation(paramType="element", paramName="acl")
        public List<Types.ACLModel> getACL() {
            return this.aCL;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getACL() != null && this.getACL().size() > 0) {
                for (int i = 0; i < this.getACL().size(); ++i) {
                    String vValidate = this.getACL().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketOutput
    extends OutputModel {
    }

    public static class ListObjectsOutput
    extends OutputModel {
        private List<String> commonPrefixes;
        private String delimiter;
        private Boolean hasMore;
        private List<Types.KeyModel> keys;
        private Integer limit;
        private String marker;
        private String name;
        private String nextMarker;
        private Types.OwnerModel owner;
        private String prefix;

        public void setCommonPrefixes(List<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @ParamAnnotation(paramType="element", paramName="common_prefixes")
        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="element", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setHasMore(Boolean hasMore) {
            this.hasMore = hasMore;
        }

        @ParamAnnotation(paramType="element", paramName="has_more")
        public Boolean getHasMore() {
            return this.hasMore;
        }

        public void setKeys(List<Types.KeyModel> keys) {
            this.keys = keys;
        }

        @ParamAnnotation(paramType="element", paramName="keys")
        public List<Types.KeyModel> getKeys() {
            return this.keys;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="element", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        @ParamAnnotation(paramType="element", paramName="marker")
        public String getMarker() {
            return this.marker;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="element", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @ParamAnnotation(paramType="element", paramName="next_marker")
        public String getNextMarker() {
            return this.nextMarker;
        }

        public void setOwner(Types.OwnerModel owner) {
            this.owner = owner;
        }

        @ParamAnnotation(paramType="element", paramName="owner")
        public Types.OwnerModel getOwner() {
            return this.owner;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="element", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }
    }

    public static class ListObjectsInput
    extends RequestInputModel {
        private String delimiter;
        private Integer limit;
        private String marker;
        private String prefix;

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        @ParamAnnotation(paramType="query", paramName="marker")
        public String getMarker() {
            return this.marker;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class ListObjectVersionsOutput
    extends OutputModel {
        private List<String> commonPrefixes;
        private String delimiter;
        private Boolean hasMore;
        private String keyMarker;
        private List<Types.VersionKeyModel> keys;
        private Integer limit;
        private String name;
        private String nextKeyMarker;
        private String nextVersionIDMarker;
        private Types.OwnerModel owner;
        private String prefix;
        private String versionIDMarker;

        public void setCommonPrefixes(List<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @ParamAnnotation(paramType="element", paramName="common_prefixes")
        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="element", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setHasMore(Boolean hasMore) {
            this.hasMore = hasMore;
        }

        @ParamAnnotation(paramType="element", paramName="has_more")
        public Boolean getHasMore() {
            return this.hasMore;
        }

        public void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        @ParamAnnotation(paramType="element", paramName="key_marker")
        public String getKeyMarker() {
            return this.keyMarker;
        }

        public void setKeys(List<Types.VersionKeyModel> keys) {
            this.keys = keys;
        }

        @ParamAnnotation(paramType="element", paramName="keys")
        public List<Types.VersionKeyModel> getKeys() {
            return this.keys;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="element", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="element", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        @ParamAnnotation(paramType="element", paramName="next_key_marker")
        public String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        public void setNextVersionIDMarker(String nextVersionIDMarker) {
            this.nextVersionIDMarker = nextVersionIDMarker;
        }

        @ParamAnnotation(paramType="element", paramName="next_version_id_marker")
        public String getNextVersionIDMarker() {
            return this.nextVersionIDMarker;
        }

        public void setOwner(Types.OwnerModel owner) {
            this.owner = owner;
        }

        @ParamAnnotation(paramType="element", paramName="owner")
        public Types.OwnerModel getOwner() {
            return this.owner;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="element", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setVersionIDMarker(String versionIDMarker) {
            this.versionIDMarker = versionIDMarker;
        }

        @ParamAnnotation(paramType="element", paramName="version_id_marker")
        public String getVersionIDMarker() {
            return this.versionIDMarker;
        }
    }

    public static class ListObjectVersionsInput
    extends RequestInputModel {
        private String delimiter;
        private String keyMarker;
        private Integer limit;
        private String prefix;
        private String versionIDMarker;

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        @ParamAnnotation(paramType="query", paramName="key_marker")
        public String getKeyMarker() {
            return this.keyMarker;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setVersionIDMarker(String versionIDMarker) {
            this.versionIDMarker = versionIDMarker;
        }

        @ParamAnnotation(paramType="query", paramName="version_id_marker")
        public String getVersionIDMarker() {
            return this.versionIDMarker;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class ListMultipartUploadsOutput
    extends OutputModel {
        private List<String> commonPrefixes;
        private String delimiter;
        private Boolean hasMore;
        private Integer limit;
        private String marker;
        private String name;
        private String nextKeyMarker;
        private String nextUploadIDMarker;
        private String prefix;
        private List<Types.UploadsModel> uploads;

        public void setCommonPrefixes(List<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @ParamAnnotation(paramType="element", paramName="common_prefixes")
        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="element", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setHasMore(Boolean hasMore) {
            this.hasMore = hasMore;
        }

        @ParamAnnotation(paramType="element", paramName="has_more")
        public Boolean getHasMore() {
            return this.hasMore;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="element", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        @ParamAnnotation(paramType="element", paramName="marker")
        public String getMarker() {
            return this.marker;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="element", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        @ParamAnnotation(paramType="element", paramName="next_key_marker")
        public String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        public void setNextUploadIDMarker(String nextUploadIDMarker) {
            this.nextUploadIDMarker = nextUploadIDMarker;
        }

        @ParamAnnotation(paramType="element", paramName="next_upload_id_marker")
        public String getNextUploadIDMarker() {
            return this.nextUploadIDMarker;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="element", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setUploads(List<Types.UploadsModel> uploads) {
            this.uploads = uploads;
        }

        @ParamAnnotation(paramType="element", paramName="uploads")
        public List<Types.UploadsModel> getUploads() {
            return this.uploads;
        }
    }

    public static class ListMultipartUploadsInput
    extends RequestInputModel {
        private String delimiter;
        private String keyMarker;
        private Integer limit;
        private String prefix;
        private String uploadIDMarker;

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        @ParamAnnotation(paramType="query", paramName="key_marker")
        public String getKeyMarker() {
            return this.keyMarker;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setUploadIDMarker(String uploadIDMarker) {
            this.uploadIDMarker = uploadIDMarker;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id_marker")
        public String getUploadIDMarker() {
            return this.uploadIDMarker;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class HeadBucketOutput
    extends OutputModel {
    }

    public static class GetBucketVersioningOutput
    extends OutputModel {
        private String status;

        public void setStatus(String status) {
            this.status = status;
        }

        @ParamAnnotation(paramType="element", paramName="status")
        public String getStatus() {
            return this.status;
        }
    }

    public static class GetBucketStatisticsOutput
    extends OutputModel {
        private Long count;
        private String created;
        private String location;
        private String name;
        private Long size;
        private String status;
        private String uRL;

        public void setCount(Long count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="element", paramName="count")
        public Long getCount() {
            return this.count;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        @ParamAnnotation(paramType="element", paramName="created")
        public String getCreated() {
            return this.created;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        @ParamAnnotation(paramType="element", paramName="location")
        public String getLocation() {
            return this.location;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="element", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        @ParamAnnotation(paramType="element", paramName="size")
        public Long getSize() {
            return this.size;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @ParamAnnotation(paramType="element", paramName="status")
        public String getStatus() {
            return this.status;
        }

        public void setURL(String uRL) {
            this.uRL = uRL;
        }

        @ParamAnnotation(paramType="element", paramName="url")
        public String getURL() {
            return this.uRL;
        }
    }

    public static class GetBucketReplicationOutput
    extends OutputModel {
        private List<Types.RulesModel> rules;

        public void setRules(List<Types.RulesModel> rules) {
            this.rules = rules;
        }

        @ParamAnnotation(paramType="element", paramName="rules")
        public List<Types.RulesModel> getRules() {
            return this.rules;
        }
    }

    public static class GetBucketPolicyOutput
    extends OutputModel {
        private List<Types.StatementModel> statement;

        public void setStatement(List<Types.StatementModel> statement) {
            this.statement = statement;
        }

        @ParamAnnotation(paramType="element", paramName="statement")
        public List<Types.StatementModel> getStatement() {
            return this.statement;
        }
    }

    public static class GetBucketNotificationOutput
    extends OutputModel {
        private List<Types.NotificationModel> notifications;

        public void setNotifications(List<Types.NotificationModel> notifications) {
            this.notifications = notifications;
        }

        @ParamAnnotation(paramType="element", paramName="notifications")
        public List<Types.NotificationModel> getNotifications() {
            return this.notifications;
        }
    }

    public static class GetBucketLoggingOutput
    extends OutputModel {
        private String targetBucket;
        private String targetPrefix;

        public void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        @ParamAnnotation(paramType="element", paramName="target_bucket")
        public String getTargetBucket() {
            return this.targetBucket;
        }

        public void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        @ParamAnnotation(paramType="element", paramName="target_prefix")
        public String getTargetPrefix() {
            return this.targetPrefix;
        }
    }

    public static class GetBucketLifecycleOutput
    extends OutputModel {
        private List<Types.RuleModel> rule;

        public void setRule(List<Types.RuleModel> rule) {
            this.rule = rule;
        }

        @ParamAnnotation(paramType="element", paramName="rule")
        public List<Types.RuleModel> getRule() {
            return this.rule;
        }
    }

    public static class GetBucketExternalMirrorOutput
    extends OutputModel {
        private String sourceSite;

        public void setSourceSite(String sourceSite) {
            this.sourceSite = sourceSite;
        }

        @ParamAnnotation(paramType="element", paramName="source_site")
        public String getSourceSite() {
            return this.sourceSite;
        }
    }

    public static class GetBucketCORSOutput
    extends OutputModel {
        private List<Types.CORSRuleModel> cORSRules;

        public void setCORSRules(List<Types.CORSRuleModel> cORSRules) {
            this.cORSRules = cORSRules;
        }

        @ParamAnnotation(paramType="element", paramName="cors_rules")
        public List<Types.CORSRuleModel> getCORSRules() {
            return this.cORSRules;
        }
    }

    public static class GetBucketCNAMEOutput
    extends OutputModel {
        private List<Types.CnameRecordModel> cnameRecords;
        private Integer count;

        public void setCnameRecords(List<Types.CnameRecordModel> cnameRecords) {
            this.cnameRecords = cnameRecords;
        }

        @ParamAnnotation(paramType="element", paramName="cname_records")
        public List<Types.CnameRecordModel> getCnameRecords() {
            return this.cnameRecords;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="element", paramName="count")
        public Integer getCount() {
            return this.count;
        }
    }

    public static class GetBucketCNAMEInput
    extends RequestInputModel {
        private String type;

        public void setType(String type) {
            this.type = type;
        }

        @ParamAnnotation(paramType="query", paramName="type")
        public String getType() {
            return this.type;
        }

        @Override
        public String validateParam() {
            String[] typeValidValues = new String[]{"website", "normal"};
            boolean typeIsValid = false;
            String type = this.getType();
            if (null == type || "".equals(type)) {
                typeIsValid = true;
            } else {
                for (String v : typeValidValues) {
                    if (!v.equals(type)) continue;
                    typeIsValid = true;
                }
            }
            if (!typeIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("Type", this.getType() + "", typeValidValues);
            }
            return null;
        }
    }

    public static class GetBucketACLOutput
    extends OutputModel {
        private List<Types.ACLModel> aCL;
        private Types.OwnerModel owner;

        public void setACL(List<Types.ACLModel> aCL) {
            this.aCL = aCL;
        }

        @ParamAnnotation(paramType="element", paramName="acl")
        public List<Types.ACLModel> getACL() {
            return this.aCL;
        }

        public void setOwner(Types.OwnerModel owner) {
            this.owner = owner;
        }

        @ParamAnnotation(paramType="element", paramName="owner")
        public Types.OwnerModel getOwner() {
            return this.owner;
        }
    }

    public static class DeleteMultipleObjectsOutput
    extends OutputModel {
        private List<Types.KeyModel> deleted;
        private List<Types.KeyDeleteErrorModel> errors;

        public void setDeleted(List<Types.KeyModel> deleted) {
            this.deleted = deleted;
        }

        @ParamAnnotation(paramType="element", paramName="deleted")
        public List<Types.KeyModel> getDeleted() {
            return this.deleted;
        }

        public void setErrors(List<Types.KeyDeleteErrorModel> errors) {
            this.errors = errors;
        }

        @ParamAnnotation(paramType="element", paramName="errors")
        public List<Types.KeyDeleteErrorModel> getErrors() {
            return this.errors;
        }
    }

    public static class DeleteMultipleObjectsInput
    extends RequestInputModel {
        private List<Types.KeyModel> objects;
        private Boolean quiet;
        private String bodyInput;

        public void setObjects(List<Types.KeyModel> objects) {
            this.objects = objects;
        }

        @ParamAnnotation(paramType="element", paramName="objects")
        public List<Types.KeyModel> getObjects() {
            return this.objects;
        }

        public void setQuiet(Boolean quiet) {
            this.quiet = quiet;
        }

        @ParamAnnotation(paramType="element", paramName="quiet")
        public Boolean getQuiet() {
            return this.quiet;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (this.getObjects() != null && this.getObjects().size() > 0) {
                for (int i = 0; i < this.getObjects().size(); ++i) {
                    String vValidate = this.getObjects().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class DeleteBucketReplicationOutput
    extends OutputModel {
    }

    public static class DeleteBucketPolicyOutput
    extends OutputModel {
    }

    public static class DeleteBucketNotificationOutput
    extends OutputModel {
    }

    public static class DeleteBucketLoggingOutput
    extends OutputModel {
    }

    public static class DeleteBucketLifecycleOutput
    extends OutputModel {
    }

    public static class DeleteBucketExternalMirrorOutput
    extends OutputModel {
    }

    public static class DeleteBucketCORSOutput
    extends OutputModel {
    }

    public static class DeleteBucketCNAMEOutput
    extends OutputModel {
    }

    public static class DeleteBucketCNAMEInput
    extends RequestInputModel {
        private String domain;
        private String bodyInput;

        public void setDomain(String domain) {
            this.domain = domain;
        }

        @ParamAnnotation(paramType="element", paramName="domain")
        public String getDomain() {
            return this.domain;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        @Override
        public String validateParam() {
            if (!QSStringUtil.isEmpty(this.getBodyInput())) {
                return null;
            }
            if (QSStringUtil.isEmpty(this.getDomain())) {
                return QSStringUtil.getParameterRequired("Domain", "DeleteBucketCNAMEInput");
            }
            return null;
        }
    }

    public static class DeleteBucketOutput
    extends OutputModel {
    }
}

