/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.constants.ParamType;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QSParamInvokeUtil {
    @Deprecated
    public static <T extends RequestInputModel> Map<String, Object> getRequestParams(T model, String paramType) {
        return QSParamInvokeUtil.getRequestParams(model, ParamType.valueOf(paramType));
    }

    public static <T extends RequestInputModel> Map<String, Object> getRequestParams(T model, ParamType paramType) {
        HashMap<String, Object> retParametersMap = new HashMap<String, Object>();
        if (model != null) {
            try {
                for (Class<?> tmpClass = model.getClass(); tmpClass != Object.class; tmpClass = tmpClass.getSuperclass()) {
                    QSParamInvokeUtil.initParameterMap(tmpClass, model, retParametersMap, paramType.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ParamType.HEADER.equals((Object)paramType) && !retParametersMap.containsKey("Date")) {
            retParametersMap.put("Date", QSSignatureUtil.formatDateTime(ZonedDateTime.now()));
        }
        return retParametersMap;
    }

    private static void initParameterMap(Class<?> objClass, Object source, Map<String, Object> retParametersMap, String paramType) throws QSException {
        Field[] fields;
        for (Field field : fields = objClass.getDeclaredFields()) {
            Method[] methods;
            String methodName = "get" + QSStringUtil.capitalize(field.getName());
            String fieldName = field.getName();
            for (Method m : methods = objClass.getDeclaredMethods()) {
                ParamAnnotation annotation;
                if (!m.getName().equalsIgnoreCase(methodName) || (annotation = m.getAnnotation(ParamAnnotation.class)) == null) continue;
                if (!annotation.paramName().equals("")) {
                    fieldName = annotation.paramName();
                }
                if (!paramType.equals(annotation.paramType()) && !paramType.equals("")) continue;
                QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
            }
        }
    }

    private static void setParameterToMap(Method m, Object source, Map<String, Object> targetParametersMap, String paramKey) throws QSException {
        try {
            Object objValue = m.invoke(source, (Object[])null);
            if (objValue != null) {
                targetParametersMap.put(paramKey, objValue);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new QSException("IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new QSException("InvocationTargetException", e);
        }
    }

    public static void invokeObject2Map(Class<?> sourceClass, Object source, Map<String, Object> targetParametersMap) throws QSException {
        Field[] declaredField;
        for (Field field : declaredField = sourceClass.getDeclaredFields()) {
            Method[] methods;
            String methodName = "get" + QSStringUtil.capitalize(field.getName());
            String fieldName = field.getName();
            for (Method m : methods = sourceClass.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(methodName)) continue;
                ParamAnnotation annotation = m.getAnnotation(ParamAnnotation.class);
                if (annotation != null && !QSStringUtil.isEmpty(annotation.paramName())) {
                    fieldName = annotation.paramName();
                }
                QSParamInvokeUtil.setParameterToMap(m, source, targetParametersMap, fieldName);
            }
        }
    }

    public static <T extends OutputModel> T getOutputModel(Class<T> className) throws QSException {
        try {
            return (T)((OutputModel)className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new QSException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static Map serializeParams(Map parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                int cnt = ((List)value).size();
                for (int i = 0; i < cnt; ++i) {
                    Object v2 = ((List)value).get(i);
                    if (v2 instanceof Map) {
                        for (Object key2 : ((Map)v2).keySet()) {
                            result.put(key + "." + (i + 1) + "." + key2, ((Map)v2).get(key2));
                        }
                        continue;
                    }
                    result.put(key + "." + (i + 1), v2);
                }
                continue;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean) {
                result.put(key, String.valueOf(value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static OutputModel getOutputModel(ResponseCallBack o) throws QSException {
        Type[] typeClass = o.getClass().getGenericInterfaces();
        try {
            if (typeClass[0] instanceof ParameterizedType) {
                Class actualType = (Class)((ParameterizedType)typeClass[0]).getActualTypeArguments()[0];
                return (OutputModel)actualType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (OutputModel)OutputModel.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new QSException(e.getMessage(), e);
        }
    }

    public static String metadataIsValid(Map<String, String> metadata) {
        boolean valid = true;
        String errK = "";
        String errV = "";
        String cause = "";
        int kLen = 0;
        int vLen = 0;
        block0: for (Map.Entry<String, String> e : metadata.entrySet()) {
            String k = e.getKey().toLowerCase();
            String v = e.getValue();
            kLen += k.length();
            vLen += v.length();
            for (char ch : k.toCharArray()) {
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch <= '9' && ch >= '0' || ch == '-' || ch == '.') continue;
                errK = k;
                errV = v;
                valid = false;
                cause = "key characters are not in the legal character set";
                break block0;
            }
            for (char ch : v.toCharArray()) {
                if (ch >= ' ' && ch < '\u007f') continue;
                errK = k;
                errV = v;
                valid = false;
                cause = "value has characters is not a printable ASCII character";
                break block0;
            }
            if (kLen <= 512 && vLen <= 2048) continue;
            errK = k;
            errV = v;
            valid = false;
            cause = "key/values size exceed the max size limit";
            break;
        }
        if (!valid) {
            return String.format("%s/%s is not allowed, reason: %s", errK, errV, cause);
        }
        return null;
    }
}

