/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.constants.ParamType;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import com.qingstor.sdk.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSSignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(QSSignatureUtil.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String ALGORITHM = "HmacSHA256";
    private static final String GMT_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).withZone(ZoneId.of("GMT"));
    private static Set<String> subSources = new HashSet<String>();

    @Deprecated
    public static String generateQSURL(Map<String, String> parameters, String requestUrl) throws QSException {
        parameters = QSParamInvokeUtil.serializeParams(parameters);
        StringBuilder sbStringToSign = new StringBuilder();
        Object[] sortedKeys = parameters.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        int count = 0;
        for (Object key : sortedKeys) {
            if (((String)key).equals("image")) continue;
            if (count != 0) {
                sbStringToSign.append("&");
            }
            String value = (String)parameters.get(key);
            sbStringToSign.append(UrlUtils.rfc3986UriEncode((String)key, true)).append("=").append(value == null ? null : UrlUtils.rfc3986UriEncode(value, true));
            ++count;
        }
        if (sbStringToSign.length() > 0) {
            if (requestUrl.indexOf("?") > 0) {
                return String.format("%s&%s", requestUrl, sbStringToSign.toString());
            }
            return String.format("%s?%s", requestUrl, sbStringToSign.toString());
        }
        return requestUrl;
    }

    public static String generateAuthorization(String accessKey, String secretKey, String method, String requestURI, Map<String, String> params, Map<String, String> headers) {
        String signature = QSSignatureUtil.generateSignature(secretKey, method, requestURI, params, headers);
        return String.format("QS %s:%s", accessKey, signature);
    }

    public static String generateAuthorization(String accessKey, String secretKey, String strToSign) {
        String signature = QSSignatureUtil.generateSignature(secretKey, strToSign);
        return String.format("QS %s:%s", accessKey, signature);
    }

    public static String generateSignature(String secretKey, String method, String requestURI, Map<String, String> params, Map<String, String> headers) {
        String strToSign = QSSignatureUtil.getStringToSignature(method, requestURI, params, headers);
        log.debug("== String to sign ==\n" + strToSign + "\n");
        String signature = QSSignatureUtil.generateSignature(secretKey, strToSign);
        return signature;
    }

    public static String getStringToSignature(String method, String authPath, Map<String, String> params, Map<String, String> headers) {
        String SEPARATOR = "&";
        StringBuilder strToSign = new StringBuilder();
        strToSign.append(method.toUpperCase()).append("\n");
        String contentMD5 = "";
        String contentType = "";
        if (headers != null) {
            if (headers.containsKey("content-md5")) {
                contentMD5 = headers.get("content-md5");
            }
            if (headers.containsKey("content-type")) {
                contentType = headers.get("content-type");
            }
        }
        strToSign.append(contentMD5).append("\n");
        strToSign.append(contentType);
        String dateStr = "";
        if (headers != null) {
            if (headers.containsKey("Date")) {
                dateStr = headers.get("Date");
            }
            if (headers.containsKey("Expires")) {
                dateStr = headers.get("Expires");
            }
        }
        strToSign.append("\n").append(dateStr);
        if (headers != null) {
            Object[] sortedHeadersKeys = headers.keySet().toArray(new String[0]);
            Arrays.sort(sortedHeadersKeys);
            for (Object key : sortedHeadersKeys) {
                if (!((String)key).startsWith("x-qs-") && !((String)key).startsWith("X-QS-")) continue;
                strToSign.append(String.format("\n%s:%s", ((String)key).toLowerCase(), headers.get(key)));
            }
        }
        StringBuilder canonicalizedQuery = new StringBuilder();
        if (params != null) {
            Object[] sortedParamsKeys = params.keySet().toArray(new String[0]);
            Arrays.sort(sortedParamsKeys);
            for (Object key : sortedParamsKeys) {
                if (!QSSignatureUtil.isSubSource((String)key)) continue;
                if (canonicalizedQuery.length() > 0) {
                    canonicalizedQuery.append("&");
                }
                try {
                    canonicalizedQuery.append((String)key);
                    String value = String.valueOf(params.get(key));
                    if (value.isEmpty() || value.equals("null")) continue;
                    canonicalizedQuery.append("=").append(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        String canonicalizedResource = authPath;
        if (canonicalizedQuery.length() > 0) {
            canonicalizedResource = canonicalizedResource + "?" + canonicalizedQuery;
        }
        strToSign.append(String.format("\n%s", canonicalizedResource));
        log.debug("== String to sign ==\n" + strToSign + "\n");
        return strToSign.toString();
    }

    public static String generateSignature(String secretKey, String strToSign) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(secretKey.getBytes(DEFAULT_CHARSET), ALGORITHM));
            byte[] signData = mac.doFinal(strToSign.getBytes(DEFAULT_CHARSET));
            return Base64.getEncoder().encodeToString(signData);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSubSource(String key) {
        return subSources.contains(key);
    }

    public static String formatDateTime(ZonedDateTime time) {
        return time.format(timeFormatter);
    }

    @Deprecated
    public static String formatGmtDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(GMT_DATE_FORMAT, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateStr = df.format(date);
        if (dateStr.indexOf("+") > 0) {
            return dateStr.substring(0, dateStr.indexOf("+"));
        }
        return dateStr;
    }

    @Deprecated
    public static String getObjectAuthRequestUrl(EnvContext envContext, String zone, String bucketName, String objectName, int expiresSecond) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        try {
            objectName = QSStringUtil.asciiCharactersEncoding(objectName);
            context.put("RequestZone", zone);
            context.put("envContext", envContext);
            context.put("OperationName", "GetObject");
            context.put("APIName", "GetObject");
            context.put("ServiceName", "QingStor");
            context.put("RequestMethod", "GET");
            context.put("RequestURI", "/<bucket-name>/<object-key>");
            context.put("bucketNameInput", bucketName);
            context.put("objectNameInput", objectName);
            long expiresTime = new Date().getTime() / 1000L + (long)expiresSecond;
            String expireAuth = QSSignatureUtil.getExpireAuth(context, expiresTime, new RequestInputModel());
            String serviceUrl = envContext.getEndpoint().toString();
            String storRequestUrl = serviceUrl.replace("://", "://%s." + zone + ".");
            if (objectName.indexOf("?") > 0) {
                return String.format(storRequestUrl + "/%s&access_key_id=%s&expires=%s&signature=%s", bucketName, objectName, envContext.getAccessKeyId(), expiresTime + "", expireAuth);
            }
            return String.format(storRequestUrl + "/%s?access_key_id=%s&expires=%s&signature=%s", bucketName, objectName, envContext.getAccessKeyId(), expiresTime + "", expireAuth);
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("Auth signature error", e);
        }
    }

    @Deprecated
    public static String getExpireAuth(Map context, long expiresSecond, RequestInputModel params) throws UnsupportedEncodingException {
        EnvContext envContext = (EnvContext)context.get("envContext");
        Map<String, Object> paramsQuery = QSParamInvokeUtil.getRequestParams(params, ParamType.QUERY);
        Map<String, Object> paramsHeaders = QSParamInvokeUtil.getRequestParams(params, ParamType.HEADER);
        paramsHeaders.remove("Date");
        paramsHeaders.clear();
        paramsHeaders.put("Expires", expiresSecond + "");
        String method = (String)context.get("RequestMethod");
        String bucketName = (String)context.get("bucketNameInput");
        String requestPath = (String)context.get("RequestURI");
        requestPath = requestPath.replace("<bucket-name>", bucketName);
        if (context.containsKey("objectNameInput")) {
            requestPath = requestPath.replace("<object-key>", (String)context.get("objectNameInput"));
        }
        String authSign = QSSignatureUtil.generateSignature(envContext.getSecretAccessKey(), method, requestPath, paramsQuery, paramsHeaders);
        return URLEncoder.encode(authSign, "UTF-8");
    }

    static {
        subSources.addAll(Arrays.asList("acl", "cors", "delete", "mirror", "part_number", "policy", "stats", "upload_id", "uploads", "image", "append", "position", "notification", "lifecycle", "logging", "cname", "response-expires", "response-cache-control", "response-content-type", "response-content-language", "response-content-encoding", "response-content-disposition", "versioning", "version_id", "versions"));
    }
}

