/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.config.ClientConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Set;
import okhttp3.HttpUrl;

public class UrlUtils {
    public static String rfc3986UriEncode(String segment, boolean encodeForwardSlash) {
        String encodedSegment;
        try {
            encodedSegment = URLEncoder.encode(segment, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
        encodedSegment = encodedSegment.replace("*", "%2A").replace("+", "%20").replace("%7E", "~");
        if (!encodeForwardSlash) {
            encodedSegment = encodedSegment.replace("%2F", "/");
        }
        return encodedSegment;
    }

    public static HttpUrl calcFinalEndpoint(URI endpoint, String zone, String bucket, ClientConfiguration config) {
        HttpUrl uri = HttpUrl.get((URI)endpoint);
        if (uri == null) {
            return null;
        }
        return uri.newBuilder().host(UrlUtils.buildCanonicalHost(uri, zone, bucket, config)).build();
    }

    private static String buildCanonicalHost(HttpUrl endpoint, String zone, String bucket, ClientConfiguration config) {
        String host = endpoint.host();
        if (config.isRawHost()) {
            return host;
        }
        if (config.isCnameSupport() && UrlUtils.escapeFromExcluded(host, config.cnameExcludeSet())) {
            return host;
        }
        StringBuilder canonicalHost = new StringBuilder();
        if (bucket != null && config.isVirtualHostEnabled()) {
            canonicalHost.append(bucket).append(".");
        }
        if (zone != null) {
            canonicalHost.append(zone).append(".");
        }
        return canonicalHost.append(host).toString();
    }

    private static boolean escapeFromExcluded(String hostToFilter, Set<String> cnameExcludeSet) {
        if (hostToFilter != null && !hostToFilter.trim().isEmpty()) {
            String canonicalHost = hostToFilter.toLowerCase();
            for (String excl : cnameExcludeSet) {
                if (!canonicalHost.endsWith(excl)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Host name can not be null.");
    }

    public static String calcResourcePath(String bucket, String key, boolean pathMode) {
        return pathMode ? UrlUtils.makeResourcePath(bucket, key) : UrlUtils.makeResourcePath(key);
    }

    private static String makeResourcePath(String key) {
        return key != null ? UrlUtils.rfc3986UriEncode(key, false) : "";
    }

    private static String makeResourcePath(String bucket, String key) {
        if (bucket != null) {
            return bucket + (key != null ? "/" + UrlUtils.rfc3986UriEncode(key, false) : "");
        }
        return "";
    }
}

