/*
 * Decompiled with CFR 0.152.
 */
package com.yuvalshavit.antlr4;

import com.yuvalshavit.antlr4.DenterOptions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;

public abstract class DenterHelper {
    private final Queue<Token> dentsBuffer = new ArrayDeque<Token>();
    private final Deque<Integer> indentations = new ArrayDeque<Integer>();
    private final int nlToken;
    private final int indentToken;
    private final int dedentToken;
    private boolean reachedEof;
    private EofHandler eofHandler = new StandardEofHandler();

    protected DenterHelper(int nlToken, int indentToken, int dedentToken) {
        this.nlToken = nlToken;
        this.indentToken = indentToken;
        this.dedentToken = dedentToken;
    }

    public Token nextToken() {
        Token t;
        this.initIfFirstRun();
        Token token = t = this.dentsBuffer.isEmpty() ? this.pullToken() : this.dentsBuffer.remove();
        if (this.reachedEof) {
            return t;
        }
        Token r = t.getType() == this.nlToken ? this.handleNewlineToken(t) : (t.getType() == -1 ? this.eofHandler.apply(t) : t);
        return r;
    }

    public DenterOptions getOptions() {
        return new DenterOptionsImpl();
    }

    protected abstract Token pullToken();

    private void initIfFirstRun() {
        if (this.indentations.isEmpty()) {
            Token firstRealToken;
            this.indentations.push(0);
            while ((firstRealToken = this.pullToken()).getType() == this.nlToken) {
            }
            if (firstRealToken.getCharPositionInLine() > 0) {
                this.indentations.push(firstRealToken.getCharPositionInLine());
                this.dentsBuffer.add(this.createToken(this.indentToken, firstRealToken));
            }
            this.dentsBuffer.add(firstRealToken);
        }
    }

    private Token handleNewlineToken(Token t) {
        Token r;
        int prevIndent;
        Token nextNext = this.pullToken();
        while (nextNext.getType() == this.nlToken) {
            t = nextNext;
            nextNext = this.pullToken();
        }
        if (nextNext.getType() == -1) {
            return this.eofHandler.apply(nextNext);
        }
        String nlText = t.getText();
        int indent = nlText.length() - 1;
        if (indent > 0 && nlText.charAt(0) == '\r') {
            --indent;
        }
        if (indent == (prevIndent = this.indentations.peek().intValue())) {
            r = t;
        } else if (indent > prevIndent) {
            r = this.createToken(this.indentToken, t);
            this.indentations.push(indent);
        } else {
            r = this.unwindTo(indent, t);
        }
        this.dentsBuffer.add(nextNext);
        return r;
    }

    private Token createToken(int tokenType, Token copyFrom) {
        String tokenTypeStr = tokenType == this.nlToken ? "newline" : (tokenType == this.indentToken ? "indent" : (tokenType == this.dedentToken ? "dedent" : null));
        InjectedToken r = new InjectedToken(copyFrom, tokenTypeStr);
        r.setType(tokenType);
        return r;
    }

    private Token unwindTo(int targetIndent, Token copyFrom) {
        int prevIndent;
        assert (this.dentsBuffer.isEmpty()) : this.dentsBuffer;
        this.dentsBuffer.add(this.createToken(this.nlToken, copyFrom));
        while ((prevIndent = this.indentations.pop().intValue()) != targetIndent) {
            if (targetIndent > prevIndent) {
                this.indentations.push(prevIndent);
                this.dentsBuffer.add(this.createToken(this.indentToken, copyFrom));
                break;
            }
            this.dentsBuffer.add(this.createToken(this.dedentToken, copyFrom));
        }
        this.indentations.push(targetIndent);
        return this.dentsBuffer.remove();
    }

    public static Builder0 builder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements Builder0,
    Builder1,
    Builder2,
    Builder3 {
        private int nl;
        private int indent;
        private int dedent;

        private BuilderImpl() {
        }

        @Override
        public Builder1 nl(int nl) {
            this.nl = nl;
            return this;
        }

        @Override
        public Builder2 indent(int indent) {
            this.indent = indent;
            return this;
        }

        @Override
        public Builder3 dedent(int dedent) {
            this.dedent = dedent;
            return this;
        }

        @Override
        public DenterHelper pullToken(TokenPuller puller) {
            final TokenPuller p = puller;
            return new DenterHelper(this.nl, this.indent, this.dedent){

                @Override
                protected Token pullToken() {
                    return p.pullToken();
                }
            };
        }
    }

    public static interface TokenPuller {
        public Token pullToken();
    }

    public static interface Builder3 {
        public DenterHelper pullToken(TokenPuller var1);
    }

    public static interface Builder2 {
        public Builder3 dedent(int var1);
    }

    public static interface Builder1 {
        public Builder2 indent(int var1);
    }

    public static interface Builder0 {
        public Builder1 nl(int var1);
    }

    private static class InjectedToken
    extends CommonToken {
        private String type;

        private InjectedToken(Token oldToken, String type) {
            super(oldToken);
            this.type = type;
        }

        public String getText() {
            if (this.type != null) {
                this.setText(this.type);
            }
            return super.getText();
        }
    }

    private class DenterOptionsImpl
    implements DenterOptions {
        private DenterOptionsImpl() {
        }

        @Override
        public void ignoreEOF() {
            DenterHelper.this.eofHandler = new EofHandler(){

                @Override
                public Token apply(Token t) {
                    DenterHelper.this.reachedEof = true;
                    return t;
                }
            };
        }
    }

    private static interface EofHandler {
        public Token apply(Token var1);
    }

    private final class StandardEofHandler
    implements EofHandler {
        private StandardEofHandler() {
        }

        @Override
        public Token apply(Token t) {
            Token r;
            if (DenterHelper.this.indentations.isEmpty()) {
                r = DenterHelper.this.createToken(DenterHelper.this.nlToken, t);
                DenterHelper.this.dentsBuffer.add(t);
            } else {
                r = DenterHelper.this.unwindTo(0, t);
                DenterHelper.this.dentsBuffer.add(t);
            }
            DenterHelper.this.reachedEof = true;
            return r;
        }
    }
}

