/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.obf.ClassTree;
import com.yworks.yguard.obf.Cons;
import java.util.Enumeration;
import java.util.Vector;

public class TreeItem {
    protected boolean isSynthetic;
    protected int access;
    protected ClassTree classTree = null;
    protected TreeItem parent = null;
    protected String sep = "/";
    private String inName = null;
    private String outName = null;
    private boolean isFixed = false;
    private boolean isFromScript = false;
    private boolean isFromScriptMap = false;

    public static boolean isNRMatch(String pattern, String string) {
        try {
            Enumeration enum1 = ClassTree.getNameEnum(pattern);
            Enumeration enum2 = ClassTree.getNameEnum(string);
            while (enum1.hasMoreElements() && enum2.hasMoreElements()) {
                Cons nameSegment1 = (Cons)enum1.nextElement();
                char tag1 = ((Character)nameSegment1.car).charValue();
                String name1 = (String)nameSegment1.cdr;
                Cons nameSegment2 = (Cons)enum2.nextElement();
                char tag2 = ((Character)nameSegment2.car).charValue();
                String name2 = (String)nameSegment2.cdr;
                if (tag1 == tag2 && TreeItem.isMatch(name1, name2)) continue;
                return false;
            }
            if (enum1.hasMoreElements() || enum2.hasMoreElements()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isMatch(String pattern, String string) {
        if (pattern == null || string == null) {
            return false;
        }
        if (pattern.indexOf(42) == -1) {
            return pattern.equals(string);
        }
        int pos = -1;
        if (pattern.charAt(0) != '*') {
            pos = pattern.indexOf(42);
            String head = pattern.substring(0, pos);
            if (string.length() < head.length()) {
                return false;
            }
            if (!string.substring(0, head.length()).equals(head)) {
                return false;
            }
            pattern = pattern.substring(pos);
            string = string.substring(pos);
        }
        if (pattern.charAt(pattern.length() - 1) != '*') {
            pos = pattern.lastIndexOf(42);
            String tail = pattern.substring(pos + 1);
            if (string.length() < tail.length()) {
                return false;
            }
            if (!string.substring(string.length() - tail.length()).equals(tail)) {
                return false;
            }
            pattern = pattern.substring(0, pos + 1);
            string = string.substring(0, string.length() - tail.length());
        }
        Vector<String> section = new Vector<String>();
        pos = pattern.indexOf(42);
        int rpos = -1;
        while ((rpos = pattern.indexOf(42, pos + 1)) != -1) {
            if (rpos != pos + 1) {
                section.addElement(pattern.substring(pos + 1, rpos));
            }
            pos = rpos;
        }
        Enumeration enumeration = section.elements();
        while (enumeration.hasMoreElements()) {
            String chunk = (String)enumeration.nextElement();
            pos = string.indexOf(chunk);
            if (pos == -1) {
                return false;
            }
            string = string.substring(pos + chunk.length());
        }
        return true;
    }

    public TreeItem(TreeItem parent, String name) {
        this.parent = parent;
        this.inName = name;
        if (parent != null) {
            this.classTree = parent.classTree;
        }
    }

    public int getModifiers() {
        return this.access;
    }

    public String getInName() {
        return this.inName;
    }

    public void setOutName(String outName) {
        this.outName = outName;
        this.isFixed = true;
    }

    public String getOutName() {
        return this.outName != null ? this.outName : this.inName;
    }

    public String getObfName() {
        return this.outName;
    }

    public void setFromScript() {
        this.isFromScript = true;
    }

    public void setFromScriptMap() {
        this.isFromScriptMap = true;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public boolean isFromScript() {
        return this.isFromScript;
    }

    public boolean isFromScriptMap() {
        return this.isFromScriptMap;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public void setParent(TreeItem parent) {
        this.parent = parent;
    }

    public TreeItem getParent() {
        return this.parent;
    }

    public String getFullInName() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.parent == null) {
            return this.getInName();
        }
        return this.parent.getFullInName() + this.sep + this.getInName();
    }

    public String getFullOutName() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.parent == null) {
            return this.getOutName();
        }
        return this.parent.getFullOutName() + this.sep + this.getOutName();
    }
}

