/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.BootstrapMethod;
import com.yworks.yguard.obf.classfile.ClassFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BootstrapMethodsAttrInfo
extends AttrInfo {
    private BootstrapMethod[] bootstrapMethods;

    protected BootstrapMethodsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "BootstrapMethods";
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        int u2numBootstrapMethods = din.readUnsignedShort();
        this.bootstrapMethods = new BootstrapMethod[u2numBootstrapMethods];
        for (int i = 0; i < u2numBootstrapMethods; ++i) {
            this.bootstrapMethods[i] = BootstrapMethod.read(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        int u2numBootstrapMethods = this.bootstrapMethods.length;
        dout.writeShort(u2numBootstrapMethods);
        for (int i = 0; i < u2numBootstrapMethods; ++i) {
            this.bootstrapMethods[i].write(dout);
        }
    }

    public BootstrapMethod[] getBootstrapMethods() {
        return this.bootstrapMethods;
    }
}

