/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.yworks.yshrink.core.ClassResolver;
import java.net.URL;
import java.net.URLClassLoader;

public class URLCpResolver
implements ClassResolver {
    URLClassLoader urlClassLoader;

    public URLCpResolver(URL[] urls) {
        this.urlClassLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
    }

    @Override
    public Class resolve(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, false, this.urlClassLoader);
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = ncdfe.getMessage();
            message = message == null || message.equals(className) ? className : message + "[" + className + "]";
            throw new ClassNotFoundException(message, ncdfe);
        }
        catch (LinkageError le) {
            throw new ClassNotFoundException(className, le);
        }
    }

    @Override
    public void close() throws Exception {
        this.urlClassLoader.close();
    }
}

