/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.zackehh.jackson.scope.SafeExecution;
import com.zackehh.jackson.stream.JiveCollectors;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class Jive {
    private Jive() {
    }

    public static ArrayNode concat(ArrayNode ... nodes) {
        return Jive.arrayCollect(Arrays.stream(nodes).flatMap(Jive::stream));
    }

    public static boolean contains(ArrayNode node, JsonNode value) {
        return Jive.some(node, (JsonNode e) -> e.equals((Object)value));
    }

    public static boolean contains(ObjectNode node, JsonNode value) {
        return Jive.some(node, (Map.Entry<String, JsonNode> e) -> ((JsonNode)e.getValue()).equals((Object)value));
    }

    public static ArrayNode drop(ArrayNode node, int count) {
        return Jive.transform(node, (Stream<JsonNode> s) -> s.skip(count));
    }

    public static <T> Optional<T> execute(Callable<T> execution) {
        try {
            return Optional.ofNullable(execution.call());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> execute(ObjectMapper mapper, SafeExecution<T> execution) {
        return Jive.execute(() -> execution.apply(mapper));
    }

    public static boolean every(ArrayNode node, Predicate<JsonNode> predicate) {
        return Jive.stream(node).allMatch(predicate);
    }

    public static boolean every(ObjectNode node, Predicate<Map.Entry<String, JsonNode>> predicate) {
        return Jive.stream(node).allMatch(predicate);
    }

    public static ArrayNode filter(ArrayNode node, Predicate<JsonNode> predicate) {
        return Jive.transform(node, (Stream<JsonNode> s) -> s.filter(predicate));
    }

    public static ObjectNode filter(ObjectNode node, Predicate<Map.Entry<String, JsonNode>> predicate) {
        return Jive.transform(node, (Stream<Map.Entry<String, JsonNode>> s) -> s.filter(predicate));
    }

    public static Optional<JsonNode> find(ArrayNode node, Predicate<JsonNode> predicate) {
        return Jive.stream(node).filter(predicate).findFirst();
    }

    public static Optional<Map.Entry<String, JsonNode>> find(ObjectNode node, Predicate<Map.Entry<String, JsonNode>> predicate) {
        return Jive.stream(node).filter(predicate).findFirst();
    }

    public static Set<String> keys(ObjectNode node) {
        return Jive.stream(node).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static JsonNode last(ArrayNode node) {
        return node.path(node.size() - 1);
    }

    public static ArrayNode map(ArrayNode node, Function<JsonNode, JsonNode> function) {
        return Jive.transform(node, (Stream<JsonNode> s) -> s.map(function));
    }

    public static ObjectNode map(ObjectNode node, Function<Map.Entry<String, JsonNode>, Map.Entry<String, JsonNode>> function) {
        return Jive.transform(node, (Stream<Map.Entry<String, JsonNode>> s) -> s.map(function));
    }

    public static ObjectNode merge(ObjectNode ... nodes) {
        return Jive.objectCollect(Arrays.stream(nodes).flatMap(Jive::stream));
    }

    public static ArrayNode newArrayNode() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public static ArrayNode newArrayNode(JsonNode ... nodes) {
        return Jive.arrayCollect(Arrays.stream(nodes));
    }

    public static BigIntegerNode newBigIntegerNode(@Nonnull BigInteger value) {
        return BigIntegerNode.valueOf((BigInteger)Objects.requireNonNull(value));
    }

    public static DecimalNode newDecimalNode(@Nonnull BigDecimal value) {
        return DecimalNode.valueOf((BigDecimal)Objects.requireNonNull(value));
    }

    public static BooleanNode newBooleanNode(@Nonnull Boolean value) {
        return BooleanNode.valueOf((boolean)Objects.requireNonNull(value));
    }

    public static BinaryNode newBinaryNode(@Nonnull byte[] value) {
        return BinaryNode.valueOf((byte[])Objects.requireNonNull(value));
    }

    public static DoubleNode newDoubleNode(@Nonnull Double value) {
        return DoubleNode.valueOf((double)Objects.requireNonNull(value));
    }

    public static FloatNode newFloatNode(@Nonnull Float value) {
        return FloatNode.valueOf((float)Objects.requireNonNull(value).floatValue());
    }

    public static IntNode newIntNode(@Nonnull Integer value) {
        return IntNode.valueOf((int)Objects.requireNonNull(value));
    }

    public static LongNode newLongNode(@Nonnull Long value) {
        return LongNode.valueOf((long)Objects.requireNonNull(value));
    }

    public static POJONode newPojoNode(@Nonnull Object value) {
        return new POJONode(Objects.requireNonNull(value));
    }

    public static ShortNode newShortNode(@Nonnull Short value) {
        return ShortNode.valueOf((short)Objects.requireNonNull(value));
    }

    public static TextNode newTextNode(@Nonnull String value) {
        return TextNode.valueOf((String)Objects.requireNonNull(value));
    }

    public static Iterable<JsonNode> newIterable(JsonNode node) {
        return node == null ? Jive.newArrayNode() : (node.isArray() ? node : Jive.newArrayNode(node));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, JsonNode value) {
        return new AbstractMap.SimpleEntry<String, JsonNode>(key, value);
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, BigDecimal value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, BigInteger value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Boolean value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, byte[] value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Double value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Float value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Integer value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Long value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Object value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, Short value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static Map.Entry<String, JsonNode> newJsonEntry(String key, String value) {
        return Jive.newJsonEntry(key, Jive.newJsonNode(value));
    }

    public static JsonNode newJsonNode(BigDecimal value) {
        return Jive.safeNode(value, Jive::newDecimalNode);
    }

    public static JsonNode newJsonNode(BigInteger value) {
        return Jive.safeNode(value, Jive::newBigIntegerNode);
    }

    public static JsonNode newJsonNode(Boolean value) {
        return Jive.safeNode(value, Jive::newBooleanNode);
    }

    public static JsonNode newJsonNode(byte[] value) {
        return Jive.safeNode(value, Jive::newBinaryNode);
    }

    public static JsonNode newJsonNode(Double value) {
        return Jive.safeNode(value, Jive::newDoubleNode);
    }

    public static JsonNode newJsonNode(Float value) {
        return Jive.safeNode(value, Jive::newFloatNode);
    }

    public static JsonNode newJsonNode(Integer value) {
        return Jive.safeNode(value, Jive::newIntNode);
    }

    public static JsonNode newJsonNode(Long value) {
        return Jive.safeNode(value, Jive::newLongNode);
    }

    public static JsonNode newJsonNode(Object value) {
        return Jive.safeNode(value, Jive::newPojoNode);
    }

    public static JsonNode newJsonNode(Short value) {
        return Jive.safeNode(value, Jive::newShortNode);
    }

    public static JsonNode newJsonNode(String value) {
        return Jive.safeNode(value, Jive::newTextNode);
    }

    public static ObjectNode newObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    @SafeVarargs
    public static ObjectNode newObjectNode(Map.Entry<String, JsonNode> ... entries) {
        return Jive.objectCollect(Arrays.stream(entries));
    }

    public static boolean none(ArrayNode node, Predicate<JsonNode> predicate) {
        return !Jive.some(node, predicate);
    }

    public static boolean none(ObjectNode node, Predicate<Map.Entry<String, JsonNode>> predicate) {
        return !Jive.some(node, predicate);
    }

    public static ObjectNode omit(ObjectNode node, String ... keys) {
        return Jive.omit(node, new HashSet<String>(Arrays.asList(keys)));
    }

    public static ObjectNode omit(ObjectNode node, Collection<String> keys) {
        return Jive.reject(node, (Map.Entry<String, JsonNode> e) -> keys.contains(e.getKey()));
    }

    public static ObjectNode pick(ObjectNode node, String ... keys) {
        return Jive.pick(node, new HashSet<String>(Arrays.asList(keys)));
    }

    public static ObjectNode pick(ObjectNode node, Collection<String> keys) {
        return Jive.filter(node, (Map.Entry<String, JsonNode> e) -> keys.contains(e.getKey()));
    }

    public static <T> T reduce(ArrayNode node, T initial, BiFunction<T, JsonNode, T> function) {
        return Jive.stream(node).reduce(initial, function, new RightOperator());
    }

    public static <T> T reduce(ObjectNode node, T initial, BiFunction<T, Map.Entry<String, JsonNode>, T> function) {
        return Jive.stream(node).reduce(initial, function, new RightOperator());
    }

    public static ArrayNode reject(ArrayNode node, Predicate<JsonNode> predicate) {
        return Jive.filter(node, (JsonNode e) -> !predicate.test((JsonNode)e));
    }

    public static ObjectNode reject(ObjectNode node, Predicate<Map.Entry<String, JsonNode>> predicate) {
        return Jive.filter(node, (Map.Entry<String, JsonNode> e) -> !predicate.test((Map.Entry<String, JsonNode>)e));
    }

    public static boolean some(ArrayNode node, Predicate<JsonNode> predicate) {
        return Jive.stream(node).anyMatch(predicate);
    }

    public static boolean some(ObjectNode node, Predicate<Map.Entry<String, JsonNode>> predicate) {
        return Jive.stream(node).anyMatch(predicate);
    }

    public static Stream<JsonNode> stream(ArrayNode node) {
        return StreamSupport.stream(node.spliterator(), false);
    }

    public static Stream<Map.Entry<String, JsonNode>> stream(ObjectNode node) {
        return StreamSupport.stream(((Iterable)() -> ((ObjectNode)node).fields()).spliterator(), false);
    }

    public static ArrayNode take(ArrayNode node, int count) {
        return Jive.transform(node, (Stream<JsonNode> s) -> s.limit(count));
    }

    public static ArrayNode transform(ArrayNode node, Function<Stream<JsonNode>, Stream<JsonNode>> transformer) {
        return Jive.arrayCollect(transformer.apply(Jive.stream(node)));
    }

    public static ObjectNode transform(ObjectNode node, Function<Stream<Map.Entry<String, JsonNode>>, Stream<Map.Entry<String, JsonNode>>> transformer) {
        return Jive.objectCollect(transformer.apply(Jive.stream(node)));
    }

    public static ArrayNode uniq(ArrayNode node) {
        return Jive.transform(node, Stream::distinct);
    }

    public static ArrayNode values(ObjectNode node) {
        return Jive.arrayCollect(Jive.stream(node).map(Map.Entry::getValue));
    }

    private static ArrayNode arrayCollect(Stream<JsonNode> stream) {
        return stream.collect(JiveCollectors.toArrayNode());
    }

    private static ObjectNode objectCollect(Stream<Map.Entry<String, JsonNode>> stream) {
        return stream.collect(JiveCollectors.toObjectNode());
    }

    private static <T> JsonNode safeNode(T value, Function<T, JsonNode> mapper) {
        return value == null ? NullNode.getInstance() : mapper.apply(value);
    }

    static class RightOperator<T>
    implements BinaryOperator<T> {
        RightOperator() {
        }

        @Override
        public T apply(T left, T right) {
            return right;
        }
    }
}

