/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.jackson.stream.collectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ObjectNodeCollector
implements Collector<Map.Entry<String, JsonNode>, ObjectNode, ObjectNode> {
    @Override
    public Supplier<ObjectNode> supplier() {
        return () -> ((JsonNodeFactory)JsonNodeFactory.instance).objectNode();
    }

    @Override
    public BiConsumer<ObjectNode, Map.Entry<String, JsonNode>> accumulator() {
        return (acc, entry) -> acc.set((String)entry.getKey(), (JsonNode)entry.getValue());
    }

    @Override
    public BinaryOperator<ObjectNode> combiner() {
        return (l, r) -> {
            Iterator it = r.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                l.set((String)entry.getKey(), (JsonNode)entry.getValue());
            }
            return l;
        };
    }

    @Override
    public Function<ObjectNode, ObjectNode> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
    }
}

