/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.ws.connection;

import com.zauberlabs.commons.ws.SoapHandlers;
import com.zauberlabs.commons.ws.connection.Configuration;
import com.zauberlabs.commons.ws.connection.PortFactory;
import com.zauberlabs.commons.ws.security.UsernameTokenProfile;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class ConnectionBuilder<A> {
    private Class<? extends Service> serviceType;
    private Class<A> portType;
    private URL wsdlUrl;
    private String endpoint;
    private PortFactory portFactory = new Basic();
    private Collection<SOAPHandler<SOAPMessageContext>> headers = new LinkedList<SOAPHandler<SOAPMessageContext>>();
    private Collection<Configuration<? super A>> configurations = new LinkedList<Configuration<? super A>>();

    public ConnectionBuilder(Class<A> portType) {
        this.portType = portType;
    }

    public static <A> ConnectionBuilder<A> fromPortType(Class<A> portType) {
        return new ConnectionBuilder<A>(portType);
    }

    public ConnectionBuilder<A> withServiceType(Class<? extends Service> serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    public ConnectionBuilder<A> withWsdlUrl(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
        return this;
    }

    public ConnectionBuilder<A> withClasspathWsdl(String resourceName) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Resource " + resourceName + " not found");
        }
        return this.withWsdlUrl(resource);
    }

    public ConnectionBuilder<A> withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConnectionBuilder<A> withHeader(SOAPHandler<SOAPMessageContext> header) {
        this.headers.add(header);
        return this;
    }

    public ConnectionBuilder<A> withPortFactory(PortFactory portFactory) {
        this.portFactory = portFactory;
        return this;
    }

    public final ConnectionBuilder<A> withPortQName(String qname) {
        return this.withPortQName(QName.valueOf(qname));
    }

    public final ConnectionBuilder<A> withPortQName(QName qname) {
        return this.withPortFactory(new WithQName(qname));
    }

    public final ConnectionBuilder<A> withUsernameTokenAuth(String username, String password) {
        return this.withHeader(new UsernameTokenProfile(username, password));
    }

    public ConnectionBuilder<A> withConfiguration(Configuration<? super A> configuration) {
        this.configurations.add(configuration);
        return this;
    }

    public A build() {
        try {
            if (this.wsdlUrl == null) {
                throw new IllegalArgumentException("The wsdl Url or Classpath is missing");
            }
            Object service = this.createService(this.serviceType, this.wsdlUrl);
            A port = this.portFactory.createPort(service, this.portType);
            this.configureEndpoint(port);
            this.configureHeaders(port);
            this.configureHooks(port);
            return port;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureHooks(A port) {
        for (Configuration<A> config : this.configurations) {
            config.configure(port);
        }
    }

    protected void configureHeaders(A port) {
        for (SOAPHandler<SOAPMessageContext> header : this.headers) {
            SoapHandlers.add(this.provideBindings(port), header);
        }
    }

    protected void configureEndpoint(A port) {
        if (this.endpoint != null) {
            Map requestContext = this.provideBindings(port).getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", this.endpoint);
        }
    }

    protected Object createService(Class<? extends Service> serviceType, URL wsdlUrl) throws Exception {
        return serviceType.getConstructor(URL.class).newInstance(wsdlUrl);
    }

    protected BindingProvider provideBindings(A port) {
        return (BindingProvider)port;
    }

    static class WithQName
    implements PortFactory {
        private QName portName;

        public WithQName(QName portName) {
            this.portName = portName;
        }

        @Override
        public <A> A createPort(Object service, Class<A> portType) {
            return (A)((Service)service).getPort(this.portName, portType);
        }
    }

    static class Basic
    implements PortFactory {
        Basic() {
        }

        @Override
        public <A> A createPort(Object service, Class<A> portType) {
            return (A)((Service)service).getPort(portType);
        }
    }
}

