/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.ws.connection.cxf;

import com.zauberlabs.commons.ws.connection.Configuration;
import com.zauberlabs.commons.ws.connection.cxf.AbstractClientConfiguration;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

public class TrafficDebugging
extends AbstractClientConfiguration {
    private final PrintWriter out;

    public TrafficDebugging(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void configureClient(Client client) {
        client.getInInterceptors().add(new LoggingInInterceptor(this.out){

            protected void log(String message) {
                TrafficDebugging.this.logMessage(this.transform(message));
            }
        });
        client.getOutInterceptors().add(new LoggingOutInterceptor(this.out){

            protected void log(String message) {
                TrafficDebugging.this.logMessage(this.transform(message));
            }
        });
    }

    protected void logMessage(String message) {
        this.out.print(message);
        this.out.flush();
    }

    public static Configuration<Object> configuration(OutputStream out) {
        return new TrafficDebugging(new PrintWriter(out));
    }

    public static Configuration<Object> toSysout() {
        return TrafficDebugging.configuration(System.out);
    }
}

