/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.ws.security;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class UsernameTokenProfile
implements SOAPHandler<SOAPMessageContext> {
    private static String SOAPENVNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    private static String SOAPENVPrefix = "soapenv";
    private static String WSSENamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static String WSSEPrefix = "wsse";
    private static String WSSEPasswordText = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private String username;
    private String password;

    public static void sign(BindingProvider bindingProvider, String username, String password) {
        List handlerChain = bindingProvider.getBinding().getHandlerChain();
        handlerChain.add(new UsernameTokenProfile(username, password));
        bindingProvider.getBinding().setHandlerChain(handlerChain);
    }

    public UsernameTokenProfile(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public final boolean handleMessage(SOAPMessageContext smc) {
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            this.addWSSecurityHeader(smc, this.username, this.password);
        }
        return true;
    }

    public final boolean handleFault(SOAPMessageContext smc) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private void addWSSecurityHeader(SOAPMessageContext smc, String username, String password) {
        try {
            SOAPMessage message = smc.getMessage();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                message.getSOAPPart().getEnvelope().addHeader();
                header = message.getSOAPHeader();
            }
            SOAPElement heSecurity = header.addChildElement("Security", WSSEPrefix, WSSENamespace);
            heSecurity.addAttribute(message.getSOAPPart().getEnvelope().createName("mustUnderstand", SOAPENVPrefix, SOAPENVNamespace), "1");
            SOAPElement heUsernameToken = heSecurity.addChildElement("UsernameToken", WSSEPrefix, WSSENamespace);
            heUsernameToken.addChildElement("Username", WSSEPrefix, WSSENamespace).addTextNode(username);
            SOAPElement hePassword = heUsernameToken.addChildElement("Password", WSSEPrefix, WSSENamespace);
            hePassword.addAttribute(message.getSOAPPart().getEnvelope().createName("Type"), WSSEPasswordText);
            hePassword.addTextNode(password);
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to add WS-Security header to request", e);
        }
    }
}

