/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.ws.security;

import com.zauberlabs.commons.ws.security.BasicCredential;
import com.zauberlabs.commons.ws.security.Credential;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    private static String SOAPENV_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static String SOAPENV_PREFIX = "soapenv";
    private static String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static String WSSE_PREFIX = "wsse";
    private static String WSSE_PASSWORD_TEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private final Credential credential;

    public static void sign(BindingProvider bindingProvider, String username, String password) {
        List handlerChain = bindingProvider.getBinding().getHandlerChain();
        handlerChain.add(new SecurityHandler(new BasicCredential(username, password)));
        bindingProvider.getBinding().setHandlerChain(handlerChain);
    }

    public SecurityHandler(Credential credential) {
        this.credential = credential;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public final boolean handleMessage(SOAPMessageContext smc) {
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            this.addWSSecurityHeader(smc, this.credential.getUsername(), this.credential.getPassword());
        }
        return true;
    }

    public final boolean handleFault(SOAPMessageContext smc) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private void addWSSecurityHeader(SOAPMessageContext smc, String username, String password) {
        try {
            SOAPMessage message = smc.getMessage();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                message.getSOAPPart().getEnvelope().addHeader();
                header = message.getSOAPHeader();
            }
            SOAPElement heSecurity = header.addChildElement("Security", WSSE_PREFIX, WSSE_NAMESPACE);
            heSecurity.addAttribute(message.getSOAPPart().getEnvelope().createName("mustUnderstand", SOAPENV_PREFIX, SOAPENV_NAMESPACE), "1");
            SOAPElement heUsernameToken = heSecurity.addChildElement("UsernameToken", WSSE_PREFIX, WSSE_NAMESPACE);
            heUsernameToken.addChildElement("Username", WSSE_PREFIX, WSSE_NAMESPACE).addTextNode(username);
            SOAPElement hePassword = heUsernameToken.addChildElement("Password", WSSE_PREFIX, WSSE_NAMESPACE);
            hePassword.addAttribute(message.getSOAPPart().getEnvelope().createName("Type"), WSSE_PASSWORD_TEXT);
            hePassword.addTextNode(password);
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to add WS-Security header to request", e);
        }
    }
}

