/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsAsyncClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequest;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.FutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import org.springframework.util.concurrent.SuccessCallback;

public class HttpComponentsAsyncClientHttpRequestExt
extends AbstractBufferingAsyncClientHttpRequest {
    private final HttpAsyncClient httpClient;
    private final HttpUriRequest httpRequest;
    private final HttpContext httpContext;

    HttpComponentsAsyncClientHttpRequestExt(HttpAsyncClient httpClient, HttpUriRequest httpRequest, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpRequest = httpRequest;
        this.httpContext = httpContext;
    }

    public HttpMethod getMethod() {
        return HttpMethod.resolve((String)this.httpRequest.getMethod());
    }

    public URI getURI() {
        return this.httpRequest.getURI();
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public HttpAsyncClient getHttpClient() {
        return this.httpClient;
    }

    public HttpUriRequest getHttpRequest() {
        return this.httpRequest;
    }

    protected ListenableFuture<ClientHttpResponse> executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        HttpComponentsClientHttpRequest.addHeaders((HttpUriRequest)this.httpRequest, (HttpHeaders)headers);
        if (this.httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.httpRequest;
            NByteArrayEntity requestEntity = new NByteArrayEntity(bufferedOutput);
            entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
        }
        HttpResponseFutureCallback callback = new HttpResponseFutureCallback();
        Future futureResponse = this.httpClient.execute(this.httpRequest, this.httpContext, (FutureCallback)callback);
        return new ClientHttpResponseFuture(futureResponse, callback);
    }

    private static class ClientHttpResponseFuture
    extends FutureAdapter<ClientHttpResponse, HttpResponse>
    implements ListenableFuture<ClientHttpResponse> {
        private final HttpResponseFutureCallback callback;

        public ClientHttpResponseFuture(Future<HttpResponse> futureResponse, HttpResponseFutureCallback callback) {
            super(futureResponse);
            this.callback = callback;
        }

        protected ClientHttpResponse adapt(HttpResponse response) {
            return new HttpComponentsAsyncClientHttpResponse(response);
        }

        public void addCallback(ListenableFutureCallback<? super ClientHttpResponse> callback) {
            this.callback.addCallback(callback);
        }

        public void addCallback(SuccessCallback<? super ClientHttpResponse> successCallback, FailureCallback failureCallback) {
            this.callback.addSuccessCallback(successCallback);
            this.callback.addFailureCallback(failureCallback);
        }
    }

    private static class HttpResponseFutureCallback
    implements FutureCallback<HttpResponse> {
        private final ListenableFutureCallbackRegistry<ClientHttpResponse> callbacks = new ListenableFutureCallbackRegistry();

        private HttpResponseFutureCallback() {
        }

        public void addCallback(ListenableFutureCallback<? super ClientHttpResponse> callback) {
            this.callbacks.addCallback(callback);
        }

        public void addSuccessCallback(SuccessCallback<? super ClientHttpResponse> callback) {
            this.callbacks.addSuccessCallback(callback);
        }

        public void addFailureCallback(FailureCallback callback) {
            this.callbacks.addFailureCallback(callback);
        }

        public void completed(HttpResponse result) {
            this.callbacks.success((Object)new HttpComponentsAsyncClientHttpResponse(result));
        }

        public void failed(Exception ex) {
            this.callbacks.failure((Throwable)ex);
        }

        public void cancelled() {
        }
    }
}

