/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestExt;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;

public class HttpComponentsAsyncClientHttpRequestExtFactory
extends HttpComponentsAsyncClientHttpRequestFactory {
    public HttpComponentsAsyncClientHttpRequestExtFactory() {
    }

    public HttpComponentsAsyncClientHttpRequestExtFactory(CloseableHttpAsyncClient httpAsyncClient) {
        super(httpAsyncClient);
    }

    public HttpComponentsAsyncClientHttpRequestExtFactory(CloseableHttpClient httpClient, CloseableHttpAsyncClient httpAsyncClient) {
        super(httpClient, httpAsyncClient);
    }

    public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) throws IOException {
        CloseableHttpAsyncClient asyncClient = this.getHttpAsyncClient();
        this.startAsyncClient();
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (context.getAttribute("http.request-config") == null) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                config = ((Configurable)httpRequest).getConfig();
            }
            if (config == null) {
                config = this.createRequestConfig(asyncClient);
            }
            if (config != null) {
                context.setAttribute("http.request-config", (Object)config);
            }
        }
        return new HttpComponentsAsyncClientHttpRequestExt((HttpAsyncClient)asyncClient, httpRequest, context);
    }

    private void startAsyncClient() {
        CloseableHttpAsyncClient asyncClient = this.getHttpAsyncClient();
        if (!asyncClient.isRunning()) {
            asyncClient.start();
        }
    }
}

