/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart;

import com.zavtech.morpheus.array.Array;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.frame.DataFrameLeastSquares;
import com.zavtech.morpheus.util.Bounds;
import com.zavtech.morpheus.viz.chart.Chart;
import com.zavtech.morpheus.viz.chart.ChartException;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.math3.special.Erf;

public interface ChartFactory {
    public boolean isSupported(Chart<?> var1);

    public void show(int var1, Iterable<Chart<?>> var2);

    public void show(int var1, Stream<Chart<?>> var2);

    public String javascript(Chart<?> ... var1);

    public String javascript(Iterable<Chart<?>> var1);

    public <X extends Comparable> Chart<XyPlot<X>> ofXY(Class<X> var1, Consumer<Chart<XyPlot<X>>> var2);

    public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> ofPiePlot(boolean var1, Consumer<Chart<PiePlot<X, S>>> var2);

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withLinePlot(DataFrame<X, S> frame, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.rows().keyType(), chart -> {
            ((XyPlot)chart.plot()).data().add(frame);
            ((XyPlot)chart.plot()).render(0).withLines(false, false);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withLinePlot(DataFrame<?, S> frame, S domainKey, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.cols().type(domainKey), chart -> {
            ((XyPlot)chart.plot()).data().add(frame, domainKey);
            ((XyPlot)chart.plot()).render(0).withLines(false, false);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withAreaPlot(DataFrame<X, S> frame, boolean stacked, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.rows().keyType(), chart -> {
            ((XyPlot)chart.plot()).data().add(frame);
            ((XyPlot)chart.plot()).render(0).withArea(stacked);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withAreaPlot(DataFrame<?, S> frame, boolean stacked, S domainKey, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.cols().type(domainKey), chart -> {
            ((XyPlot)chart.plot()).data().add(frame, domainKey);
            ((XyPlot)chart.plot()).render(0).withArea(stacked);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withScatterPlot(DataFrame<X, S> frame, boolean shapes, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.rows().keyType(), chart -> {
            ((XyPlot)chart.plot()).data().add(frame);
            if (shapes) {
                ((XyPlot)chart.plot()).render(0).withShapes();
            } else {
                ((XyPlot)chart.plot()).render(0).withDots();
            }
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withScatterPlot(DataFrame<?, S> frame, boolean shapes, S domainKey, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.cols().type(domainKey), chart -> {
            ((XyPlot)chart.plot()).data().add(frame, domainKey);
            if (shapes) {
                ((XyPlot)chart.plot()).render(0).withShapes();
            } else {
                ((XyPlot)chart.plot()).render(0).withDots();
            }
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withBarPlot(DataFrame<X, S> frame, boolean stacked, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.rows().keyType(), chart -> {
            ((XyPlot)chart.plot()).data().add(frame);
            ((XyPlot)chart.plot()).render(0).withBars(stacked, 0.0);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<XyPlot<X>> withBarPlot(DataFrame<?, S> frame, boolean stacked, S domainKey, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.ofXY(frame.cols().type(domainKey), chart -> {
            ((XyPlot)chart.plot()).data().add(frame, domainKey);
            ((XyPlot)chart.plot()).render(0).withBars(stacked, 0.0);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> withPiePlot(DataFrame<X, S> frame, boolean is3d, Consumer<Chart<PiePlot<X, S>>> configurator) {
        if (frame == null) {
            throw new IllegalArgumentException("The DataFrame cannot be null");
        }
        return this.ofPiePlot(is3d, chart -> {
            ((PiePlot)chart.plot()).data().apply(frame);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> withPiePlot(DataFrame<X, S> frame, boolean is3d, S dataKey, Consumer<Chart<PiePlot<X, S>>> configurator) {
        if (frame == null) {
            throw new IllegalArgumentException("The DataFrame cannot be null");
        }
        return this.ofPiePlot(is3d, chart -> {
            ((PiePlot)chart.plot()).data().apply(frame, dataKey);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> withPiePlot(DataFrame<?, S> frame, boolean is3d, S dataKey, S labelKey, Consumer<Chart<PiePlot<X, S>>> configurator) {
        if (frame == null) {
            throw new IllegalArgumentException("The DataFrame cannot be null");
        }
        return this.ofPiePlot(is3d, chart -> {
            ((PiePlot)chart.plot()).data().apply(frame, dataKey, labelKey);
            if (configurator != null) {
                configurator.accept((Chart)chart);
            }
        });
    }

    default public <R, C extends Comparable> Chart<XyPlot<Double>> withHistPlot(DataFrame<R, C> frame, int binCount, Consumer<Chart<XyPlot<Double>>> configurator) {
        if (frame == null) {
            throw new IllegalArgumentException("The DataFrame cannot be null");
        }
        if (frame.colCount() < 1) {
            throw new ChartException("The histogram data frame should contain at least one 1 column with frequency values");
        }
        if (frame.rowCount() < 2) {
            throw new ChartException("The histogram data frame should have at least 2 rows");
        }
        Iterator colKeyIterator = frame.cols().keys().iterator();
        DataFrame hist0 = frame.cols().hist(binCount, (Object[])new Comparable[]{(Comparable)colKeyIterator.next()});
        double stepSize0 = (Double)hist0.rows().key(1) - (Double)hist0.rows().key(0);
        return this.withBarPlot(hist0, false, chart -> {
            ((XyPlot)chart.plot()).data().at(0).withLowerDomainInterval(v -> v + stepSize0);
            ((XyPlot)chart.plot()).axes().range(0).label().withText("Frequency");
            ((XyPlot)chart.plot()).axes().domain().label().withText("Values");
            while (colKeyIterator.hasNext()) {
                DataFrame histN = frame.cols().hist(binCount, (Object[])new Comparable[]{(Comparable)colKeyIterator.next()});
                double stepSizeN = (Double)histN.rows().key(1) - (Double)histN.rows().key(0);
                int index = ((XyPlot)chart.plot()).data().add(histN);
                ((XyPlot)chart.plot()).data().at(index).withLowerDomainInterval(v -> v + stepSizeN);
                ((XyPlot)chart.plot()).render(index).withBars(false, 0.0);
            }
            if (configurator != null) {
                configurator.accept((Chart<XyPlot<Double>>)chart);
            }
        });
    }

    default public <R, C extends Comparable> Chart<XyPlot<Double>> withHistPlot(DataFrame<R, C> frame, int binCount, boolean sharedBins, Consumer<Chart<XyPlot<Double>>> configurator) {
        if (frame.colCount() < 1) {
            throw new ChartException("The histogram data frame should contain at least one 1 column with frequency values");
        }
        if (frame.rowCount() < 2) {
            throw new ChartException("The histogram data frame should have at least 2 rows");
        }
        if (!sharedBins) {
            return this.withHistPlot(frame, binCount, configurator);
        }
        DataFrame hist = frame.cols().hist(binCount, (Object[])new Comparable[0]);
        double first = (Double)hist.rows().key(0);
        double second = (Double)hist.rows().key(1);
        double stepSize = second - first;
        return this.withBarPlot(hist, false, chart -> {
            chart.title().withText("Histogram");
            chart.title().withFont(new Font("Arial", 0, 16));
            ((XyPlot)chart.plot()).data().at(0).withLowerDomainInterval(v -> v + stepSize);
            ((XyPlot)chart.plot()).axes().range(0).label().withText("Frequency");
            ((XyPlot)chart.plot()).axes().domain().label().withText("Values");
            if (configurator != null) {
                configurator.accept((Chart<XyPlot<Double>>)chart);
            }
        });
    }

    default public <R, C extends Comparable> Chart<XyPlot<Double>> withHistPlot(DataFrame<R, C> frame, int binCount, C columnKey, Consumer<Chart<XyPlot<Double>>> configurator) {
        if (frame == null) {
            throw new IllegalArgumentException("The DataFrame cannot be null");
        }
        if (frame.colCount() < 1) {
            throw new ChartException("The histogram data frame should contain at least one 1 column with frequency values");
        }
        if (frame.rowCount() < 2) {
            throw new ChartException("The histogram data frame should have at least 2 rows");
        }
        DataFrame series = frame.cols().select((Object[])new Comparable[]{columnKey});
        return this.withHistPlot(series, binCount, configurator);
    }

    default public <R extends Comparable, C extends Comparable> Chart<XyPlot<Integer>> withAcf(DataFrameLeastSquares<R, C> model, int maxLags, double alpha, Consumer<Chart<XyPlot<Integer>>> consumer) {
        DataFrame acf = model.getResidualsAcf(maxLags);
        Array bounds = Array.of((Object[])new String[]{"Upper", "Lower"});
        Array lags = acf.rows().keyArray();
        double erfInv = Math.sqrt(2.0) * Erf.erfInv((double)(1.0 - alpha));
        double upper = 1.0 * erfInv / Math.sqrt(maxLags);
        double lower = -1.0 * erfInv / Math.sqrt(maxLags);
        int maxLag = (Integer)acf.rows().lastKey().orElseThrow(() -> new RuntimeException("No data in autocorrelation matrix"));
        DataFrame boundsFrame = DataFrame.ofDoubles((Iterable)lags, (Iterable)bounds, v -> v.colOrdinal() == 0 ? upper : lower);
        return Chart.create().withBarPlot(acf, false, chart -> {
            chart.title().withText("Autocorrelation Function (ACF)");
            chart.title().withFont(new Font("Arial", 1, 16));
            ((XyPlot)chart.plot()).data().add(boundsFrame);
            ((XyPlot)chart.plot()).render(1).withLines(false, true);
            ((XyPlot)chart.plot()).data().at(0).withLowerDomainInterval(v -> v + 1);
            ((XyPlot)chart.plot()).axes().domain().label().withText("Lag");
            ((XyPlot)chart.plot()).axes().range(0).label().withText("Autocorrelation");
            ((XyPlot)chart.plot()).axes().domain().withRange(Bounds.of((Object)-1, (Object)maxLag));
            ((XyPlot)chart.plot()).style((Comparable)((Object)"Upper")).withColor(Color.BLUE).withDashes(true).withLineWidth(1.0f);
            ((XyPlot)chart.plot()).style((Comparable)((Object)"Lower")).withColor(Color.BLUE).withDashes(true).withLineWidth(1.0f);
            if (consumer != null) {
                consumer.accept((Chart<XyPlot<Integer>>)chart);
            }
        });
    }

    default public <R extends Comparable, C extends Comparable> Chart<XyPlot<Double>> withResidualsVsFitted(DataFrameLeastSquares<R, C> model, Consumer<Chart<XyPlot<Double>>> consumer) {
        DataFrame residuals = model.getResiduals();
        DataFrame fittedValues = model.getFittedValues();
        DataFrame zeroLine = fittedValues.copy().cols().add((Object)"Zero", Double.class, v -> 0.0);
        DataFrame combined = DataFrame.concatColumns((DataFrame[])new DataFrame[]{residuals, fittedValues});
        return Chart.create().withLinePlot(combined, "Fitted", chart -> {
            chart.title().withText("Least Squares Residuals vs Fitted Values");
            chart.title().withFont(new Font("Arial", 1, 15));
            ((XyPlot)chart.plot()).data().add(zeroLine, "Fitted");
            ((XyPlot)chart.plot()).render(0).withDots();
            ((XyPlot)chart.plot()).render(1).withLines(false, false);
            ((XyPlot)chart.plot()).style((Comparable)((Object)"Zero")).withColor(Color.BLACK).withLineWidth(2.0f);
            ((XyPlot)chart.plot()).style((Comparable)((Object)"Residuals")).withColor(Color.RED).withPointsVisible(true);
            ((XyPlot)chart.plot()).axes().domain().label().withText("Fitted Values");
            ((XyPlot)chart.plot()).axes().domain().format().withPattern("0.00;-0.00");
            ((XyPlot)chart.plot()).axes().range(0).label().withText("Residuals");
            ((XyPlot)chart.plot()).axes().range(0).format().withPattern("0.00;-0.00");
            chart.legend().on().bottom();
            if (consumer != null) {
                consumer.accept((Chart<XyPlot<Double>>)chart);
            }
        });
    }
}

