/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart;

import com.zavtech.morpheus.util.Collect;
import com.zavtech.morpheus.viz.chart.Chart;
import com.zavtech.morpheus.viz.chart.ChartFactory;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import com.zavtech.morpheus.viz.google.GChartFactory;
import com.zavtech.morpheus.viz.jfree.JFChartFactory;
import com.zavtech.morpheus.viz.js.JsCode;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChartFactoryProxy
implements ChartFactory {
    private ChartFactory defaultFactory = new JFChartFactory();
    private ChartFactory swingFactory = new JFChartFactory();
    private ChartFactory htmlFactory = new GChartFactory();

    ChartFactoryProxy() {
    }

    public void htmlMode() {
        this.defaultFactory = this.htmlFactory;
    }

    public void swingMode() {
        this.defaultFactory = this.swingFactory;
    }

    public ChartFactory asHtml() {
        return this.htmlFactory;
    }

    public ChartFactory asSwing() {
        return this.swingFactory;
    }

    @Override
    public boolean isSupported(Chart<?> chart) {
        return true;
    }

    @Override
    public String javascript(Chart<?> ... charts) {
        return this.javascript(Collect.asList((Object[])charts));
    }

    @Override
    public String javascript(Iterable<Chart<?>> charts) {
        if (this.isMixedCharts(charts)) {
            List chartList = Collect.asList(charts);
            return JsCode.create(jsCode -> {
                jsCode.newLine().write("google.charts.load('current', {'packages':['corechart']});", new Object[0]);
                jsCode.newLine().write("google.charts.setOnLoadCallback(%s);", "drawCharts");
                jsCode.newLine();
                jsCode.newFunction("drawCharts", init -> {
                    for (int i = 0; i < chartList.size(); ++i) {
                        init.write("drawChart_%s()", i);
                        init.newLine();
                    }
                });
                for (int i = 0; i < chartList.size(); ++i) {
                    Chart chart = (Chart)chartList.get(i);
                    String functionName = String.format("drawChart_%s", i);
                    String divId = chart.options().getId().orElse(String.format("chart_%s", i));
                    jsCode.newLine().newLine();
                    chart.accept((JsCode)jsCode, functionName, divId);
                }
            });
        }
        if (this.containsSwingCharts(charts)) {
            return this.swingFactory.javascript(charts);
        }
        if (this.containsHtmlCharts(charts)) {
            return this.htmlFactory.javascript(charts);
        }
        if (charts.iterator().hasNext()) {
            throw new IllegalArgumentException("Unrecognized chart type in Iterable");
        }
        return "console.info('No charts!')";
    }

    @Override
    public void show(int columns, Iterable<Chart<?>> charts) {
        Iterator<Chart<?>> iterator = charts.iterator();
        if (iterator.hasNext()) {
            Chart<?> first = iterator.next();
            if (this.htmlFactory.isSupported(first)) {
                this.htmlFactory.show(columns, charts);
            } else if (this.swingFactory.isSupported(first)) {
                this.swingFactory.show(columns, charts);
            }
        }
    }

    @Override
    public void show(int columns, Stream<Chart<?>> charts) {
        List<Chart<?>> chartList = charts.collect(Collectors.toList());
        Iterator iterator = chartList.iterator();
        if (iterator.hasNext()) {
            Chart first = (Chart)iterator.next();
            if (this.htmlFactory.isSupported(first)) {
                this.htmlFactory.show(columns, chartList);
            } else if (this.swingFactory.isSupported(first)) {
                this.swingFactory.show(columns, chartList);
            }
        }
    }

    @Override
    public <X extends Comparable> Chart<XyPlot<X>> ofXY(Class<X> domainType, Consumer<Chart<XyPlot<X>>> configurator) {
        return this.defaultFactory.ofXY(domainType, configurator);
    }

    @Override
    public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> ofPiePlot(boolean is3d, Consumer<Chart<PiePlot<X, S>>> configurator) {
        return this.defaultFactory.ofPiePlot(is3d, configurator);
    }

    private boolean isMixedCharts(Iterable<Chart<?>> charts) {
        return this.containsHtmlCharts(charts) && this.containsSwingCharts(charts);
    }

    private boolean containsHtmlCharts(Iterable<Chart<?>> charts) {
        for (Chart<?> chart : charts) {
            if (!this.htmlFactory.isSupported(chart)) continue;
            return true;
        }
        return false;
    }

    private boolean containsSwingCharts(Iterable<Chart<?>> charts) {
        for (Chart<?> chart : charts) {
            if (!this.swingFactory.isSupported(chart)) continue;
            return true;
        }
        return false;
    }
}

