/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart;

import java.awt.Dimension;
import java.util.Optional;

public interface ChartOptions {
    public Optional<String> getId();

    public Optional<Dimension> getPreferredSize();

    public ChartOptions withId(String var1);

    public ChartOptions withPreferredSize(int var1, int var2);

    public static class Default
    implements ChartOptions {
        private String id;
        private Dimension preferredSize = new Dimension(800, 500);

        @Override
        public Optional<String> getId() {
            return Optional.ofNullable(this.id);
        }

        @Override
        public Optional<Dimension> getPreferredSize() {
            return Optional.ofNullable(this.preferredSize);
        }

        @Override
        public ChartOptions withId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ChartOptions withPreferredSize(int width, int height) {
            this.preferredSize = new Dimension(width, height);
            return this;
        }
    }
}

