/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart;

import java.util.HashMap;
import java.util.Map;

public enum ChartShape {
    CIRCLE,
    SQUARE,
    DIAMOND,
    TRIANGLE_UP,
    TRIANGLE_DOWN,
    TRIANGLE_RIGHT,
    TRIANGLE_LEFT;


    public static class DefaultProvider
    implements Provider {
        private volatile int index = -1;
        private ChartShape[] shapes = ChartShape.values();
        private Map<Object, ChartShape> shapeMap = new HashMap<Object, ChartShape>();

        @Override
        public ChartShape getShape(Object key) {
            ChartShape shape = this.shapeMap.get(key);
            if (shape == null) {
                shape = this.next();
                this.shapeMap.put(key, shape);
            }
            return shape;
        }

        private ChartShape next() {
            ++this.index;
            if (this.index < this.shapes.length) {
                return this.shapes[this.index];
            }
            this.index = 0;
            return this.shapes[this.index];
        }
    }

    public static interface Provider {
        public ChartShape getShape(Object var1);
    }
}

